/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jagg;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import net.sf.jagg.Aggregator;

public class AggregatorCache {
    private static AggregatorCache theAggregatorCache = null;
    private final HashMap<String, List<Aggregator>> myAggregators = new HashMap();

    private AggregatorCache() {
    }

    public static AggregatorCache getAggregatorCache() {
        if (theAggregatorCache == null) {
            theAggregatorCache = new AggregatorCache();
        }
        return theAggregatorCache;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Aggregator getAggregator(Aggregator archetype) {
        if (archetype == null) {
            return null;
        }
        Aggregator agg = null;
        HashMap<String, List<Aggregator>> hashMap = this.myAggregators;
        synchronized (hashMap) {
            if (!archetype.isInUse()) {
                archetype.setInUse(true);
                agg = archetype;
            }
            if (agg == null) {
                List<Aggregator> aggsList = this.myAggregators.get(archetype.toString());
                if (aggsList != null) {
                    int size = aggsList.size();
                    for (int a = 0; a < size; ++a) {
                        Aggregator candidate = aggsList.get(a);
                        if (candidate.isInUse()) continue;
                        agg = candidate;
                        agg.setInUse(true);
                        break;
                    }
                }
                if (aggsList == null) {
                    aggsList = new ArrayList<Aggregator>();
                    this.myAggregators.put(archetype.toString(), aggsList);
                }
                if (agg == null) {
                    agg = archetype.replicate();
                    agg.setInUse(true);
                    aggsList.add(agg);
                }
            }
        }
        return agg;
    }
}

