/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jagg;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.concurrent.Callable;
import net.sf.jagg.AggregateValue;
import net.sf.jagg.Aggregations;
import net.sf.jagg.Aggregator;
import net.sf.jagg.PositionedAggregatorList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class AggregateRunner<T>
implements Callable<PositionedAggregatorList<T>> {
    private List<Aggregator> myAggregators;
    private List<T> myValuesList;
    private Comparator<? super T> myComparator;
    private int myStart;
    private int myEnd;
    private int myPosition;
    private boolean amIUsingSuperAggregation;
    private List<String> myProperties;

    public AggregateRunner(List<Aggregator> aggregators, List<T> valuesList, int pos, Comparator<? super T> comparator, int start, int end, boolean useSuperAggregation, List<String> properties) {
        this.myAggregators = aggregators;
        this.myValuesList = valuesList;
        this.myComparator = comparator;
        this.myStart = start;
        this.myEnd = end;
        this.myPosition = pos;
        this.amIUsingSuperAggregation = useSuperAggregation;
        this.myProperties = properties;
    }

    @Override
    public PositionedAggregatorList<T> call() {
        int numProperties = this.myProperties != null ? this.myProperties.size() : 0;
        ArrayList<Integer> defaultGroupingSet = new ArrayList<Integer>(numProperties);
        for (int i = 0; i < numProperties; ++i) {
            defaultGroupingSet.add(i);
        }
        PositionedAggregatorList pal = new PositionedAggregatorList(this.myPosition);
        int startIndex = this.myStart;
        int endIndex = Aggregations.indexOfLastMatching(this.myValuesList, this.myComparator, startIndex, this.myEnd);
        T currObject = this.myValuesList.get(startIndex);
        int aggSize = this.myAggregators.size();
        List<Aggregator> initAggList = this.getAggregatorsList();
        for (int i = startIndex; i <= endIndex; ++i) {
            T value = this.myValuesList.get(i);
            for (int a = 0; a < aggSize; ++a) {
                Aggregator agg = initAggList.get(a);
                agg.iterate(value);
            }
        }
        pal.setInitialList(currObject, initAggList);
        if (endIndex == this.myEnd) {
            return pal;
        }
        startIndex = endIndex + 1;
        ArrayList aggValues = new ArrayList();
        List<Aggregator> currAggList = this.getAggregatorsList();
        boolean currInEndingAggList = false;
        while (startIndex <= this.myEnd) {
            currObject = this.myValuesList.get(startIndex);
            endIndex = Aggregations.indexOfLastMatching(this.myValuesList, this.myComparator, startIndex, this.myEnd);
            if (this.amIUsingSuperAggregation && startIndex > 0) {
                currAggList = this.getAggregatorsList();
            } else {
                for (int a = 0; a < aggSize; ++a) {
                    Aggregator agg = currAggList.get(a);
                    agg.init();
                }
            }
            for (int i = startIndex; i <= endIndex; ++i) {
                T value = this.myValuesList.get(i);
                for (int a = 0; a < aggSize; ++a) {
                    Aggregator agg = currAggList.get(a);
                    agg.iterate(value);
                }
            }
            if (endIndex == this.myEnd) {
                pal.setEndingList(currObject, currAggList);
                currInEndingAggList = true;
            } else {
                AggregateValue<T> aggValue = new AggregateValue<T>(currObject);
                for (int a = 0; a < aggSize; ++a) {
                    Aggregator agg = currAggList.get(a);
                    Object result = agg.terminate();
                    agg.setInUse(false);
                    aggValue.setAggregateValue(agg, result);
                }
                if (this.myProperties != null) {
                    aggValue.assignPropsAndGroupingSet(this.myProperties, defaultGroupingSet);
                }
                if (this.amIUsingSuperAggregation) {
                    aggValue.assignAggregators(currAggList);
                }
                aggValues.add(aggValue);
            }
            startIndex = endIndex + 1;
        }
        if (!this.amIUsingSuperAggregation && !currInEndingAggList) {
            for (int a = 0; a < aggSize; ++a) {
                Aggregator agg = currAggList.get(a);
                agg.setInUse(false);
            }
        }
        pal.setMiddleAggValues(aggValues);
        return pal;
    }

    private List<Aggregator> getAggregatorsList() {
        int aggSize = this.myAggregators.size();
        ArrayList<Aggregator> aggList = new ArrayList<Aggregator>(aggSize);
        for (int a = 0; a < aggSize; ++a) {
            Aggregator archetype = this.myAggregators.get(a);
            Aggregator agg = Aggregator.getAggregator(archetype);
            agg.init();
            aggList.add(agg);
        }
        return aggList;
    }
}

