/*
 * Decompiled with CFR 0.152.
 */
package net.sf.ghost4j.document;

import com.lowagie.text.pdf.PdfReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import net.sf.ghost4j.document.AbstractDocument;
import net.sf.ghost4j.document.DocumentException;
import org.apache.commons.io.IOUtils;

public class PDFDocument
extends AbstractDocument {
    private static final long serialVersionUID = 6331191005700202153L;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void load(InputStream inputStream) throws IOException {
        ByteArrayInputStream bais;
        block6: {
            super.load(inputStream);
            bais = null;
            PdfReader reader = null;
            try {
                try {
                    bais = new ByteArrayInputStream(this.content);
                    reader = new PdfReader((InputStream)bais);
                }
                catch (Exception e) {
                    throw new IOException("PDF document is not valid");
                }
                Object var6_4 = null;
                if (reader == null) break block6;
            }
            catch (Throwable throwable) {
                Object var6_5 = null;
                if (reader != null) {
                    reader.close();
                }
                IOUtils.closeQuietly((InputStream)bais);
                throw throwable;
            }
            reader.close();
        }
        IOUtils.closeQuietly((InputStream)bais);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int getPageCount() throws DocumentException {
        ByteArrayInputStream bais;
        int pageCount;
        block7: {
            pageCount = 0;
            if (this.content == null) {
                return pageCount;
            }
            bais = null;
            PdfReader reader = null;
            try {
                try {
                    bais = new ByteArrayInputStream(this.content);
                    reader = new PdfReader((InputStream)bais);
                    pageCount = reader.getNumberOfPages();
                }
                catch (Exception e) {
                    throw new DocumentException(e);
                }
                Object var6_4 = null;
                if (reader == null) break block7;
            }
            catch (Throwable throwable) {
                Object var6_5 = null;
                if (reader != null) {
                    reader.close();
                }
                IOUtils.closeQuietly((InputStream)bais);
                throw throwable;
            }
            reader.close();
        }
        IOUtils.closeQuietly((InputStream)bais);
        return pageCount;
    }

    public String getType() {
        return "PDF";
    }
}

