/*
 * Decompiled with CFR 0.152.
 */
package net.sf.ghost4j.analyzer;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import net.sf.ghost4j.Ghostscript;
import net.sf.ghost4j.GhostscriptException;
import net.sf.ghost4j.analyzer.AbstractRemoteAnalyzer;
import net.sf.ghost4j.analyzer.AnalysisItem;
import net.sf.ghost4j.analyzer.AnalyzerException;
import net.sf.ghost4j.analyzer.FontAnalysisItem;
import net.sf.ghost4j.document.Document;
import net.sf.ghost4j.document.DocumentException;
import net.sf.ghost4j.document.PDFDocument;
import net.sf.ghost4j.util.DiskStore;
import org.apache.commons.io.IOUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FontAnalyzer
extends AbstractRemoteAnalyzer {
    public FontAnalyzer() {
        this.supportedDocumentClasses = new Class[1];
        this.supportedDocumentClasses[0] = PDFDocument.class;
    }

    public static void main(String[] args) throws AnalyzerException {
        FontAnalyzer.startRemoteAnalyzer(new FontAnalyzer());
    }

    @Override
    public List<AnalysisItem> run(Document document) throws IOException, AnalyzerException, DocumentException {
        this.assertDocumentSupported(document);
        return this.run((PDFDocument)document);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private List<AnalysisItem> run(PDFDocument document) throws IOException, AnalyzerException {
        ArrayList<AnalysisItem> arrayList;
        Ghostscript gs = Ghostscript.getInstance();
        DiskStore diskStore = DiskStore.getInstance();
        String inputDiskStoreKey = document.toString() + String.valueOf(System.currentTimeMillis() + String.valueOf((int)(Math.random() * 1000.0)));
        document.write(diskStore.addFile(inputDiskStoreKey));
        String[] gsArgs = new String[]{"-dQUIET", "-dNOPAUSE", "-dBATCH", "-dNODISPLAY", "-sFile=" + diskStore.getFile(inputDiskStoreKey).getAbsolutePath(), "-sOutputFile=%stdout", "-f", "-"};
        InputStream is = this.getClass().getClassLoader().getResourceAsStream("script/AnalyzePDFFonts.ps");
        try {
            try {
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                Ghostscript ghostscript = gs;
                synchronized (ghostscript) {
                    gs.setStdIn(is);
                    gs.setStdOut(baos);
                    gs.initialize(gsArgs);
                }
                ArrayList<AnalysisItem> result = new ArrayList<AnalysisItem>();
                String scriptResult = baos.toString();
                String[] lines = scriptResult.split("\n");
                boolean inResults = false;
                for (String line : lines) {
                    String[] columns;
                    if (line.equals("---")) {
                        inResults = true;
                        continue;
                    }
                    if (!inResults || (columns = line.split(" ")).length != 2) continue;
                    FontAnalysisItem font = new FontAnalysisItem();
                    String name = columns[0];
                    String[] nameParts = name.split("\\+");
                    if (nameParts.length > 1) {
                        name = nameParts[1];
                        font.setSubSet(true);
                    }
                    font.setName(name);
                    font.setEmbedded(false);
                    if (columns[1].equals("EM") || columns[1].equals("SU")) {
                        font.setEmbedded(true);
                    }
                    result.add(font);
                }
                baos.close();
                arrayList = result;
                Object var21_21 = null;
            }
            catch (GhostscriptException e) {
                throw new AnalyzerException(e);
            }
        }
        catch (Throwable throwable) {
            Object var21_22 = null;
            IOUtils.closeQuietly((InputStream)is);
            try {
                Ghostscript.deleteInstance();
            }
            catch (GhostscriptException e2) {
                throw new AnalyzerException(e2);
            }
            diskStore.removeFile(inputDiskStoreKey);
            throw throwable;
        }
        IOUtils.closeQuietly((InputStream)is);
        try {}
        catch (GhostscriptException e2) {
            throw new AnalyzerException(e2);
        }
        Ghostscript.deleteInstance();
        diskStore.removeFile(inputDiskStoreKey);
        return arrayList;
    }
}

