/*
 * Decompiled with CFR 0.152.
 */
package gnu.cajo.utils;

import gnu.cajo.invoke.Remote;
import gnu.cajo.invoke.RemoteInvoke;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.io.IOException;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.rmi.NotBoundException;
import java.rmi.RemoteException;
import java.util.MissingResourceException;
import java.util.ResourceBundle;

public abstract class BaseProxy
implements Serializable {
    protected transient Remote remoteThis;
    protected RemoteInvoke item;
    protected MainThread runnable;
    public transient Thread thread;
    public Container container;
    public String bundle;
    public String[] strings;

    public void setItem(RemoteInvoke item) {
        if (this.item != null) {
            throw new IllegalArgumentException("Item already set");
        }
        this.item = item;
    }

    public Container init(Remote remoteRef) {
        if (this.remoteThis == null) {
            this.remoteThis = remoteRef;
            if (this.bundle != null) {
                ResourceBundle rb = ResourceBundle.getBundle(this.bundle);
                for (int i = 0; i < this.strings.length; ++i) {
                    try {
                        this.strings[i] = rb.getString(this.strings[i]);
                        continue;
                    }
                    catch (MissingResourceException e) {
                        this.strings[i] = e.getLocalizedMessage();
                    }
                }
            }
            if (this.runnable != null) {
                this.thread = new Thread(this.runnable);
                this.thread.start();
            }
        } else {
            throw new IllegalArgumentException("Item already initialized");
        }
        return this.container;
    }

    public Remote getItem(String url) throws RemoteException, NotBoundException, IOException, ClassNotFoundException, InstantiationException, IllegalAccessException, MalformedURLException {
        return new Remote(Remote.getItem(url));
    }

    public String getDescription() {
        return "not defined";
    }

    public void contact(String url) {
    }

    public class Panel
    extends Container {
        public final void update(Graphics g) {
            this.paint(g);
        }

        public final void paint(Graphics g) {
            this.paintComponents(g);
        }

        public final Dimension getPreferredSize() {
            return this.getSize();
        }
    }

    public abstract class MainThread
    implements Runnable,
    Serializable {
        public abstract void run();
    }
}

