/*
 * Decompiled with CFR 0.152.
 */
package net.sf.ehcache.management.service.impl;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.lang.management.ManagementFactory;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.management.InstanceAlreadyExistsException;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import net.sf.ehcache.Cache;
import net.sf.ehcache.CacheException;
import net.sf.ehcache.CacheManager;
import net.sf.ehcache.Ehcache;
import net.sf.ehcache.Status;
import net.sf.ehcache.config.ManagementRESTServiceConfiguration;
import net.sf.ehcache.event.CacheManagerEventListener;
import net.sf.ehcache.management.resource.CacheConfigEntity;
import net.sf.ehcache.management.resource.CacheEntity;
import net.sf.ehcache.management.resource.CacheManagerConfigEntity;
import net.sf.ehcache.management.resource.CacheManagerEntity;
import net.sf.ehcache.management.resource.CacheStatisticSampleEntity;
import net.sf.ehcache.management.sampled.CacheManagerSampler;
import net.sf.ehcache.management.sampled.CacheManagerSamplerImpl;
import net.sf.ehcache.management.sampled.CacheSampler;
import net.sf.ehcache.management.sampled.CacheSamplerImpl;
import net.sf.ehcache.management.service.AgentService;
import net.sf.ehcache.management.service.CacheManagerService;
import net.sf.ehcache.management.service.CacheService;
import net.sf.ehcache.management.service.EntityResourceFactory;
import net.sf.ehcache.management.service.SamplerRepositoryService;
import net.sf.ehcache.management.service.impl.CacheConfigurationEntityBuilder;
import net.sf.ehcache.management.service.impl.CacheEntityBuilder;
import net.sf.ehcache.management.service.impl.CacheManagerConfigurationEntityBuilder;
import net.sf.ehcache.management.service.impl.CacheManagerEntityBuilder;
import net.sf.ehcache.management.service.impl.CacheStatisticSampleEntityBuilder;
import net.sf.ehcache.management.service.impl.DfltSamplerRepositoryServiceMBean;
import net.sf.ehcache.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.terracotta.management.ServiceExecutionException;
import org.terracotta.management.ServiceLocator;
import org.terracotta.management.resource.AgentEntity;
import org.terracotta.management.resource.AgentMetadataEntity;
import org.terracotta.management.resource.services.LicenseService;
import org.terracotta.management.resource.services.Utils;
import org.terracotta.modules.ehcache.store.nonstop.NonStopBypass;

public class DfltSamplerRepositoryService
implements SamplerRepositoryService,
EntityResourceFactory,
CacheManagerService,
CacheService,
AgentService,
DfltSamplerRepositoryServiceMBean {
    private static final Logger LOG = LoggerFactory.getLogger(DfltSamplerRepositoryService.class);
    public static final String MBEAN_NAME_PREFIX = "net.sf.ehcache:type=RepositoryService";
    public static final String AGENCY = "Ehcache";
    private final ThreadLocal<Boolean> tsaBridged = new ThreadLocal<Boolean>(){

        @Override
        protected Boolean initialValue() {
            return false;
        }
    };
    private final Map<String, SamplerRepoEntry> cacheManagerSamplerRepo = new HashMap<String, SamplerRepoEntry>();
    private final ReadWriteLock cacheManagerSamplerRepoLock = new ReentrantReadWriteLock();
    private volatile ObjectName objectName;
    protected final ManagementRESTServiceConfiguration configuration;
    private final Thread precalculationThread;
    private final ConcurrentMap<String, ConcurrentMap<String, Object>> precalculatedSizes = new ConcurrentHashMap();

    public DfltSamplerRepositoryService(String clientUUID, ManagementRESTServiceConfiguration configuration) {
        this.configuration = configuration;
        if (clientUUID != null) {
            this.registerMBean(clientUUID);
        }
        final int delay = Integer.getInteger("net.sf.ehcache.agent.precalculation.delay", 30);
        LOG.debug("agent precalculation delay: {}", (Object)delay);
        if (delay > 0) {
            this.precalculationThread = new Thread(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    while (true) {
                        try {
                            NonStopBypass.setBypassEnabledForCurrentThread((boolean)true);
                            Thread.sleep((long)delay * 1000L);
                            DfltSamplerRepositoryService.this.precalculate();
                            continue;
                        }
                        catch (InterruptedException ie) {
                            return;
                        }
                        catch (Exception e) {
                            LOG.warn("Error precalculating clustered caches size", (Throwable)e);
                            continue;
                        }
                        finally {
                            NonStopBypass.setBypassEnabledForCurrentThread((boolean)false);
                            continue;
                        }
                        break;
                    }
                }
            });
            this.precalculationThread.setName("Ehcache Agent Precalculation Thread");
            this.precalculationThread.setDaemon(true);
            this.precalculationThread.start();
        } else {
            this.precalculationThread = null;
        }
    }

    @Override
    public final synchronized void registerMBean(String clientUUID) {
        if (clientUUID == null) {
            throw new NullPointerException("clientUUID cannot be null");
        }
        if (this.objectName == null) {
            ObjectName objectName;
            try {
                objectName = new ObjectName("net.sf.ehcache:type=RepositoryService,node=" + clientUUID);
                MBeanServer platformMBeanServer = ManagementFactory.getPlatformMBeanServer();
                platformMBeanServer.registerMBean(this, objectName);
            }
            catch (InstanceAlreadyExistsException iaee) {
                objectName = null;
            }
            catch (Exception e) {
                LOG.warn("Error registering SamplerRepositoryService MBean with UUID: " + clientUUID, (Throwable)e);
                objectName = null;
            }
            this.objectName = objectName;
        }
    }

    @Override
    public void dispose() {
        if (this.precalculationThread != null) {
            this.precalculationThread.interrupt();
            try {
                this.precalculationThread.join(3000L);
            }
            catch (InterruptedException ie) {
                Thread.currentThread().interrupt();
            }
            this.precalculatedSizes.clear();
        }
        if (this.objectName != null) {
            try {
                MBeanServer platformMBeanServer = ManagementFactory.getPlatformMBeanServer();
                platformMBeanServer.unregisterMBean(this.objectName);
            }
            catch (Exception e) {
                LOG.warn("Error unregistering SamplerRepositoryService MBean: " + this.objectName, (Throwable)e);
            }
        }
    }

    long getPrecalculatedSize(String cmName, String cName) {
        ConcurrentMap cacheMap = (ConcurrentMap)this.precalculatedSizes.get(cmName);
        if (cacheMap == null) {
            return 0L;
        }
        Object size = cacheMap.get(cName);
        if (size == null) {
            return 0L;
        }
        return (Long)size;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void precalculate() {
        LOG.debug("starting precalculation...");
        HashMap<String, SamplerRepoEntry> samplerRepo = new HashMap<String, SamplerRepoEntry>();
        ReadWriteLock readWriteLock = this.cacheManagerSamplerRepoLock;
        synchronized (readWriteLock) {
            samplerRepo.putAll(this.cacheManagerSamplerRepo);
        }
        for (Map.Entry entry : samplerRepo.entrySet()) {
            Collection<CacheSampler> cacheSamplers = ((SamplerRepoEntry)entry.getValue()).getComprehensiveCacheSamplers(null);
            String cmName = (String)entry.getKey();
            ConcurrentMap map = (ConcurrentMap)this.precalculatedSizes.get(cmName);
            if (map == null) {
                map = new ConcurrentHashMap();
                this.precalculatedSizes.put(cmName, map);
            }
            LOG.debug("processing precalculation for cache manager {}", (Object)cmName);
            for (CacheSampler sampler : cacheSamplers) {
                String cName = sampler.getCacheName();
                LOG.debug("processing precalculation for cache {}", (Object)cName);
                if (!sampler.isTerracottaClustered()) continue;
                long size = sampler.getSize();
                map.put(cName, size);
                LOG.debug("precalculatedSizes cache {} size: {}", (Object)cName, (Object)size);
            }
        }
        LOG.debug("precalculation done.");
    }

    @Override
    public byte[] invoke(String ticket, String token, String iaCallbackUrl, String methodName, Class<?>[] argsTypes, Object[] args) {
        try {
            this.tsaBridged.set(true);
            Method method = this.getClass().getMethod(methodName, argsTypes);
            Object res = method.invoke((Object)this, args);
            byte[] byArray = this.serialize(res);
            return byArray;
        }
        catch (Exception e) {
            Throwable t = DfltSamplerRepositoryService.getRootCause(e);
            if (t instanceof RuntimeException) {
                throw (RuntimeException)t;
            }
            throw new RuntimeException(t);
        }
        finally {
            this.tsaBridged.set(false);
        }
    }

    @Override
    public String getVersion() {
        return this.getClass().getPackage().getImplementationVersion();
    }

    @Override
    public String getAgency() {
        return AGENCY;
    }

    private static Throwable getRootCause(Throwable t) {
        Throwable last = null;
        while (t != null) {
            last = t;
            t = t.getCause();
        }
        if (last instanceof InvocationTargetException) {
            last = ((InvocationTargetException)last).getTargetException();
        }
        return last;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] serialize(Object obj) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ObjectOutputStream oos = new ObjectOutputStream(baos);
        try {
            oos.writeObject(obj);
        }
        finally {
            oos.close();
        }
        return baos.toByteArray();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void register(CacheManager cacheManager) {
        String cmName = cacheManager.getName();
        this.cacheManagerSamplerRepoLock.writeLock().lock();
        try {
            if (!this.cacheManagerSamplerRepo.containsKey(cmName)) {
                SamplerRepoEntry entry = new SamplerRepoEntry(cacheManager);
                cacheManager.setCacheManagerEventListener((CacheManagerEventListener)entry);
                this.cacheManagerSamplerRepo.put(cmName, entry);
            }
        }
        finally {
            this.cacheManagerSamplerRepoLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unregister(CacheManager cacheManager) {
        this.cacheManagerSamplerRepoLock.writeLock().lock();
        try {
            SamplerRepoEntry entry = this.cacheManagerSamplerRepo.remove(cacheManager.getName());
            entry.destroy();
        }
        finally {
            this.cacheManagerSamplerRepoLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean hasRegistered() {
        this.cacheManagerSamplerRepoLock.readLock().lock();
        try {
            boolean bl = !this.cacheManagerSamplerRepo.isEmpty();
            return bl;
        }
        finally {
            this.cacheManagerSamplerRepoLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Collection<CacheManagerEntity> createCacheManagerEntities(Set<String> cacheManagerNames, Set<String> attributes) {
        Collection<Object> entities;
        CacheManagerEntityBuilder builder = null;
        this.cacheManagerSamplerRepoLock.readLock().lock();
        try {
            if (cacheManagerNames == null) {
                for (SamplerRepoEntry entry : this.cacheManagerSamplerRepo.values()) {
                    builder = builder == null ? CacheManagerEntityBuilder.createWith(entry.getCacheManagerSampler()) : builder.add(entry.getCacheManagerSampler());
                }
            } else {
                for (String cmName : cacheManagerNames) {
                    SamplerRepoEntry entry = this.cacheManagerSamplerRepo.get(cmName);
                    if (entry == null) continue;
                    builder = builder == null ? CacheManagerEntityBuilder.createWith(entry.getCacheManagerSampler()) : builder.add(entry.getCacheManagerSampler());
                }
            }
            entities = builder == null ? new HashSet(0) : (attributes == null ? builder.build() : builder.add(attributes).build());
        }
        finally {
            this.cacheManagerSamplerRepoLock.readLock().unlock();
        }
        return entities;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Collection<CacheManagerConfigEntity> createCacheManagerConfigEntities(Set<String> cacheManagerNames) {
        Collection<CacheManagerConfigEntity> entities;
        CacheManagerConfigurationEntityBuilder builder = null;
        this.cacheManagerSamplerRepoLock.readLock().lock();
        try {
            if (cacheManagerNames == null) {
                for (SamplerRepoEntry entry : this.cacheManagerSamplerRepo.values()) {
                    builder = builder == null ? CacheManagerConfigurationEntityBuilder.createWith(entry.getCacheManagerSampler()) : builder.add(entry.getCacheManagerSampler());
                }
            } else {
                for (String cmName : cacheManagerNames) {
                    SamplerRepoEntry entry = this.cacheManagerSamplerRepo.get(cmName);
                    if (entry == null) continue;
                    builder = builder == null ? CacheManagerConfigurationEntityBuilder.createWith(entry.getCacheManagerSampler()) : builder.add(entry.getCacheManagerSampler());
                }
            }
            entities = builder == null ? new HashSet<CacheManagerConfigEntity>(0) : builder.build();
        }
        finally {
            this.cacheManagerSamplerRepoLock.readLock().unlock();
        }
        return entities;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Collection<CacheEntity> createCacheEntities(Set<String> cacheManagerNames, Set<String> cacheNames, Set<String> attributes) {
        Collection<Object> entities;
        CacheEntityBuilder builder = null;
        this.cacheManagerSamplerRepoLock.readLock().lock();
        try {
            NonStopBypass.setBypassEnabledForCurrentThread((boolean)true);
            if (cacheManagerNames == null) {
                for (Map.Entry<String, SamplerRepoEntry> entry : this.cacheManagerSamplerRepo.entrySet()) {
                    for (CacheSampler sampler : entry.getValue().getComprehensiveCacheSamplers(cacheNames)) {
                        builder = builder == null ? CacheEntityBuilder.createWith(this, sampler, entry.getKey()) : builder.add(sampler, entry.getKey());
                    }
                }
            } else {
                for (String cmName : cacheManagerNames) {
                    SamplerRepoEntry entry = this.cacheManagerSamplerRepo.get(cmName);
                    if (entry == null) continue;
                    for (CacheSampler sampler : entry.getComprehensiveCacheSamplers(cacheNames)) {
                        builder = builder == null ? CacheEntityBuilder.createWith(this, sampler, cmName) : builder.add(sampler, cmName);
                    }
                }
            }
            entities = builder == null ? new HashSet(0) : (attributes == null ? builder.build() : builder.add(attributes).build());
        }
        finally {
            NonStopBypass.setBypassEnabledForCurrentThread((boolean)false);
            this.cacheManagerSamplerRepoLock.readLock().unlock();
        }
        return entities;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Collection<CacheConfigEntity> createCacheConfigEntities(Set<String> cacheManagerNames, Set<String> cacheNames) {
        Collection<CacheConfigEntity> entities;
        CacheConfigurationEntityBuilder builder = null;
        this.cacheManagerSamplerRepoLock.readLock().lock();
        try {
            if (cacheManagerNames == null) {
                for (Map.Entry<String, SamplerRepoEntry> entry : this.cacheManagerSamplerRepo.entrySet()) {
                    for (CacheSampler sampler : entry.getValue().getComprehensiveCacheSamplers(cacheNames)) {
                        builder = builder == null ? CacheConfigurationEntityBuilder.createWith(entry.getValue().getCacheManagerSampler(), sampler.getCacheName()) : builder.add(entry.getValue().getCacheManagerSampler(), sampler.getCacheName());
                    }
                }
            } else {
                for (String cmName : cacheManagerNames) {
                    SamplerRepoEntry entry = this.cacheManagerSamplerRepo.get(cmName);
                    if (entry == null) continue;
                    for (CacheSampler sampler : entry.getComprehensiveCacheSamplers(cacheNames)) {
                        builder = builder == null ? CacheConfigurationEntityBuilder.createWith(entry.getCacheManagerSampler(), sampler.getCacheName()) : builder.add(entry.getCacheManagerSampler(), sampler.getCacheName());
                    }
                }
            }
            entities = builder == null ? new HashSet<CacheConfigEntity>(0) : builder.build();
        }
        finally {
            this.cacheManagerSamplerRepoLock.readLock().unlock();
        }
        return entities;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Collection<CacheStatisticSampleEntity> createCacheStatisticSampleEntity(Set<String> cacheManagerNames, Set<String> cacheNames, Set<String> sampleNames) {
        CacheStatisticSampleEntityBuilder builder = CacheStatisticSampleEntityBuilder.createWith(sampleNames);
        this.cacheManagerSamplerRepoLock.readLock().lock();
        try {
            if (cacheManagerNames == null) {
                for (Map.Entry entry : this.cacheManagerSamplerRepo.entrySet()) {
                    for (CacheSampler sampler : ((SamplerRepoEntry)entry.getValue()).getComprehensiveCacheSamplers(cacheNames)) {
                        builder.add(sampler, (String)entry.getKey());
                    }
                }
            } else {
                for (String string : cacheManagerNames) {
                    SamplerRepoEntry entry = this.cacheManagerSamplerRepo.get(string);
                    if (entry == null) continue;
                    for (CacheSampler sampler : entry.getComprehensiveCacheSamplers(cacheNames)) {
                        builder.add(sampler, string);
                    }
                }
            }
            Collection<CacheStatisticSampleEntity> collection = builder.build();
            return collection;
        }
        finally {
            this.cacheManagerSamplerRepoLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void createOrUpdateCache(String cacheManagerName, String cacheName, CacheEntity resource) throws ServiceExecutionException {
        block4: {
            this.cacheManagerSamplerRepoLock.readLock().lock();
            try {
                SamplerRepoEntry entry = this.cacheManagerSamplerRepo.get(cacheManagerName);
                if (entry != null) {
                    entry.updateCache(cacheName, resource);
                    break block4;
                }
                throw new UnsupportedOperationException("Create cache not implemented!");
            }
            finally {
                this.cacheManagerSamplerRepoLock.readLock().unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clearCache(String cacheManagerName, String cacheName) {
        this.cacheManagerSamplerRepoLock.readLock().lock();
        try {
            SamplerRepoEntry entry = this.cacheManagerSamplerRepo.get(cacheManagerName);
            if (entry != null) {
                entry.clearCache(cacheName);
            }
        }
        finally {
            this.cacheManagerSamplerRepoLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateCacheManager(String cacheManagerName, CacheManagerEntity resource) throws ServiceExecutionException {
        this.cacheManagerSamplerRepoLock.writeLock().lock();
        try {
            SamplerRepoEntry entry = this.cacheManagerSamplerRepo.get(cacheManagerName);
            if (entry != null) {
                Object mblhsAttr;
                Object mbldsAttr;
                Object mblhAttr;
                CacheManagerSampler cms = entry.getCacheManagerSampler();
                Object mbldAttr = resource.getAttributes().get("MaxBytesLocalDisk");
                if (mbldAttr != null) {
                    cms.setMaxBytesLocalDisk(Long.parseLong(mbldAttr.toString()));
                }
                if ((mblhAttr = resource.getAttributes().get("MaxBytesLocalHeap")) != null) {
                    cms.setMaxBytesLocalDisk(Long.parseLong(mblhAttr.toString()));
                }
                if ((mbldsAttr = resource.getAttributes().get("MaxBytesLocalDiskAsString")) != null) {
                    cms.setMaxBytesLocalDiskAsString(mbldsAttr.toString());
                }
                if ((mblhsAttr = resource.getAttributes().get("MaxBytesLocalHeapAsString")) != null) {
                    cms.setMaxBytesLocalHeapAsString(mblhsAttr.toString());
                }
            }
        }
        finally {
            this.cacheManagerSamplerRepoLock.writeLock().unlock();
        }
    }

    @Override
    public Collection<AgentEntity> getAgents(Set<String> ids) throws ServiceExecutionException {
        if (ids.isEmpty()) {
            return Collections.singleton(this.buildAgentEntity());
        }
        ArrayList<AgentEntity> result = new ArrayList<AgentEntity>();
        for (String id : ids) {
            if (!id.equals("embedded")) {
                throw new ServiceExecutionException("Unknown agent ID : " + id);
            }
            result.add(this.buildAgentEntity());
        }
        return result;
    }

    private AgentEntity buildAgentEntity() {
        AgentEntity e = new AgentEntity();
        e.setAgentId("embedded");
        e.setVersion(this.getClass().getPackage().getImplementationVersion());
        e.setAgencyOf(AGENCY);
        StringBuilder sb = new StringBuilder();
        for (String cmName : this.cacheManagerSamplerRepo.keySet()) {
            sb.append(cmName).append(",");
        }
        if (sb.indexOf(",") > -1) {
            sb.deleteCharAt(sb.length() - 1);
        }
        e.getRootRepresentables().put("cacheManagerNames", sb.toString());
        return e;
    }

    @Override
    public Collection<AgentMetadataEntity> getAgentsMetadata(Set<String> ids) throws ServiceExecutionException {
        if (ids.isEmpty()) {
            return Collections.singleton(this.buildAgentMetadata());
        }
        ArrayList<AgentMetadataEntity> result = new ArrayList<AgentMetadataEntity>();
        for (String id : ids) {
            if (!id.equals("embedded")) {
                throw new ServiceExecutionException("Unknown agent ID : " + id);
            }
            result.add(this.buildAgentMetadata());
        }
        return result;
    }

    private AgentMetadataEntity buildAgentMetadata() {
        AgentMetadataEntity ame = new AgentMetadataEntity();
        ame.setAgentId("embedded");
        ame.setAgencyOf(AGENCY);
        ame.setVersion(this.getClass().getPackage().getImplementationVersion());
        ame.setAvailable(true);
        if (this.isTsaBridged()) {
            ame.setSecured(this.isTsaSecured());
            ame.setSslEnabled(this.isTsaSecured());
            ame.setNeedClientAuth(false);
        } else {
            ame.setSecured(Utils.trimToNull((String)this.configuration.getSecurityServiceLocation()) != null);
            ame.setSslEnabled(Utils.trimToNull((String)this.configuration.getSecurityServiceLocation()) != null);
            ame.setNeedClientAuth(this.configuration.isNeedClientAuth());
        }
        ame.setLicensed(((LicenseService)ServiceLocator.locate(LicenseService.class)).isLicensed());
        ame.setSampleHistorySize(this.configuration.getSampleHistorySize());
        ame.setSampleIntervalSeconds(this.configuration.getSampleIntervalSeconds());
        ame.setEnabled(this.configuration.isEnabled());
        return ame;
    }

    protected boolean isTsaBridged() {
        return this.tsaBridged.get();
    }

    protected boolean isTsaSecured() {
        return false;
    }

    private static final class SamplerRepoEntry
    implements CacheManagerEventListener {
        private static final String ENABLED_ATTR = "Enabled";
        private static final String BULK_LOAD_ENABLED = "ClusterBulkLoadEnabled";
        private static final String MAX_ELEMENTS_ON_DISK = "MaxElementsOnDisk";
        private static final String MAX_BYTES_LOCAL_DISK = "MaxBytesLocalDisk";
        private static final String MAX_BYTES_LOCAL_DISK_STRING = "MaxBytesLocalDiskAsString";
        private static final String MAX_BYTES_LOCAL_HEAP = "MaxBytesLocalHeap";
        private static final String MAX_BYTES_LOCAL_HEAP_STRING = "MaxBytesLocalHeapAsString";
        private static final String LOGGING_ENABLED = "LoggingEnabled";
        private static final String TIME_TO_IDLE_SEC = "TimeToIdleSeconds";
        private static final String TIME_TO_LIVE_SEC = "TimeToLiveSeconds";
        private static final String MAX_ENTRIES_LOCAL_HEAP = "MaxEntriesLocalHeap";
        private static final String MAX_ENTRIES_IN_CACHE = "MaxEntriesInCache";
        private CacheManager cacheManager;
        private CacheManagerSampler cacheManagerSampler;
        private Map<String, CacheSampler> cacheSamplersByName;
        private volatile Status status = Status.STATUS_UNINITIALISED;
        private final ReadWriteLock cacheSamplerMapLock = new ReentrantReadWriteLock();

        public SamplerRepoEntry(CacheManager cacheManager) {
            if (cacheManager == null) {
                throw new IllegalArgumentException("cacheManager == null");
            }
            this.cacheManagerSampler = new CacheManagerSamplerImpl(cacheManager);
            this.cacheManager = cacheManager;
            String[] cNames = cacheManager.getCacheNames();
            this.cacheSamplersByName = new HashMap<String, CacheSampler>(cNames.length);
            for (String cName : cNames) {
                this.cacheSamplersByName.put(cName, (CacheSampler)new CacheSamplerImpl(cacheManager.getEhcache(cName)));
            }
        }

        public CacheManagerSampler getCacheManagerSampler() {
            return this.cacheManagerSampler;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Collection<CacheSampler> getComprehensiveCacheSamplers(Set<String> cacheSamplerNames) {
            HashSet<CacheSampler> samplers = new HashSet<CacheSampler>();
            this.cacheSamplerMapLock.readLock().lock();
            try {
                if (cacheSamplerNames == null) {
                    for (CacheSampler cs : this.cacheSamplersByName.values()) {
                        samplers.add(cs);
                    }
                } else {
                    for (String cName : cacheSamplerNames) {
                        CacheSampler cs = this.cacheSamplersByName.get(cName);
                        if (cs == null) continue;
                        samplers.add(cs);
                    }
                }
            }
            finally {
                this.cacheSamplerMapLock.readLock().unlock();
            }
            return samplers;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void clearCache(String cacheSamplerName) {
            this.cacheSamplerMapLock.writeLock().lock();
            try {
                CacheSampler cs = this.cacheSamplersByName.get(cacheSamplerName);
                if (cs != null) {
                    cs.removeAll();
                }
            }
            finally {
                this.cacheSamplerMapLock.writeLock().unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void updateCache(String cacheSamplerName, CacheEntity cacheResource) throws ServiceExecutionException {
            block17: {
                this.cacheSamplerMapLock.writeLock().lock();
                try {
                    CacheSampler cs = this.cacheSamplersByName.get(cacheSamplerName);
                    if (cs == null) break block17;
                    try {
                        Object ttlAttr;
                        Object ttiAttr;
                        Integer meicAttr;
                        Integer melhAttr;
                        Object mblhsAttr;
                        Object mblhAttr;
                        Object mbldsAttr;
                        Object mbldAttr;
                        Boolean loggingEnabledAttr;
                        Integer maxElementsOnDiskAttr;
                        Boolean enabledBlkLoad;
                        Boolean enabledAttr = (Boolean)cacheResource.getAttributes().get(ENABLED_ATTR);
                        if (enabledAttr != null) {
                            cs.setEnabled(enabledAttr.booleanValue());
                        }
                        if ((enabledBlkLoad = (Boolean)cacheResource.getAttributes().get(BULK_LOAD_ENABLED)) != null) {
                            cs.setNodeBulkLoadEnabled(enabledBlkLoad.booleanValue());
                        }
                        if ((maxElementsOnDiskAttr = (Integer)cacheResource.getAttributes().get(MAX_ELEMENTS_ON_DISK)) != null) {
                            cs.setMaxElementsOnDisk(maxElementsOnDiskAttr.intValue());
                        }
                        if ((loggingEnabledAttr = (Boolean)cacheResource.getAttributes().get(LOGGING_ENABLED)) != null) {
                            cs.setLoggingEnabled(loggingEnabledAttr.booleanValue());
                        }
                        if ((mbldAttr = cacheResource.getAttributes().get(MAX_BYTES_LOCAL_DISK)) != null) {
                            cs.setMaxBytesLocalDisk(Long.parseLong(mbldAttr.toString()));
                        }
                        if ((mbldsAttr = cacheResource.getAttributes().get(MAX_BYTES_LOCAL_DISK_STRING)) != null) {
                            cs.setMaxBytesLocalDiskAsString(mbldsAttr.toString());
                        }
                        if ((mblhAttr = cacheResource.getAttributes().get(MAX_BYTES_LOCAL_HEAP)) != null) {
                            cs.setMaxBytesLocalHeap(Long.parseLong(mblhAttr.toString()));
                        }
                        if ((mblhsAttr = cacheResource.getAttributes().get(MAX_BYTES_LOCAL_HEAP_STRING)) != null) {
                            cs.setMaxBytesLocalHeapAsString(mblhsAttr.toString());
                        }
                        if ((melhAttr = (Integer)cacheResource.getAttributes().get(MAX_ENTRIES_LOCAL_HEAP)) != null) {
                            cs.setMaxEntriesLocalHeap((long)melhAttr.intValue());
                        }
                        if ((meicAttr = (Integer)cacheResource.getAttributes().get(MAX_ENTRIES_IN_CACHE)) != null) {
                            cs.setMaxEntriesInCache((long)meicAttr.intValue());
                        }
                        if ((ttiAttr = cacheResource.getAttributes().get(TIME_TO_IDLE_SEC)) != null) {
                            cs.setTimeToIdleSeconds(Long.parseLong(ttiAttr.toString()));
                        }
                        if ((ttlAttr = cacheResource.getAttributes().get(TIME_TO_LIVE_SEC)) != null) {
                            cs.setTimeToLiveSeconds(Long.parseLong(ttlAttr.toString()));
                        }
                    }
                    catch (RuntimeException e) {
                        throw new ServiceExecutionException((Throwable)e);
                    }
                }
                finally {
                    this.cacheSamplerMapLock.writeLock().unlock();
                }
            }
        }

        public void init() throws CacheException {
            this.status = Status.STATUS_ALIVE;
        }

        public Status getStatus() {
            return this.status;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void dispose() throws CacheException {
            this.cacheSamplerMapLock.writeLock().lock();
            try {
                this.cacheSamplersByName.clear();
                this.cacheSamplersByName = null;
            }
            finally {
                this.cacheSamplerMapLock.writeLock().unlock();
            }
            this.status = Status.STATUS_SHUTDOWN;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void notifyCacheAdded(String cacheName) {
            this.cacheSamplerMapLock.writeLock().lock();
            try {
                Cache c = this.cacheManager.getCache(cacheName);
                if (c != null) {
                    this.cacheSamplersByName.put(cacheName, (CacheSampler)new CacheSamplerImpl((Ehcache)c));
                }
            }
            finally {
                this.cacheSamplerMapLock.writeLock().unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void notifyCacheRemoved(String cacheName) {
            this.cacheSamplerMapLock.writeLock().lock();
            try {
                this.cacheSamplersByName.remove(cacheName);
            }
            finally {
                this.cacheSamplerMapLock.writeLock().unlock();
            }
        }

        public void destroy() {
            this.cacheManagerSampler = null;
            this.cacheManager = null;
        }
    }
}

