/*
 * Decompiled with CFR 0.152.
 */
package net.sf.ehcache.management.resource.services;

import java.lang.management.ManagementFactory;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.management.AttributeNotFoundException;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanException;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.management.ReflectionException;
import javax.ws.rs.Path;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.PathSegment;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import net.sf.ehcache.management.jmx.CacheManagerJmxClient;
import net.sf.ehcache.management.resource.CacheManagerEntity;
import net.sf.ehcache.management.resource.services.CacheManagersResourceService;

@Path(value="/agents/tsa/cacheManagers")
public class ClusteredCacheManagersResourceServiceImpl
implements CacheManagersResourceService {
    private static final List<String> EXCLUDED_ATTRIBUTES = Arrays.asList("MBeanRegisteredName", "Name");

    public Collection<CacheManagerEntity> getCacheManagers(UriInfo info) {
        String ids = (String)((PathSegment)info.getPathSegments().get(0)).getMatrixParameters().getFirst((Object)"ids");
        if (ids != null && !"embedded".equals(ids)) {
            throw new WebApplicationException(Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)String.format("Agent ID must be '%s'.", "embedded")).build());
        }
        try {
            String names = (String)((PathSegment)info.getPathSegments().get(1)).getMatrixParameters().getFirst((Object)"names");
            MBeanServer platformMBeanServer = ManagementFactory.getPlatformMBeanServer();
            List<ObjectName> cacheManagerObjectNames = this.findCacheManagerObjectNames(platformMBeanServer, names == null ? null : names.split(","));
            ArrayList<CacheManagerEntity> result = new ArrayList<CacheManagerEntity>();
            for (ObjectName cacheManagerObjectName : cacheManagerObjectNames) {
                MBeanAttributeInfo[] attributes;
                CacheManagerEntity e = new CacheManagerEntity();
                e.setAgentId("embedded");
                String cacheManagerName = (String)platformMBeanServer.getAttribute(cacheManagerObjectName, "Name");
                e.setName(cacheManagerName);
                MultivaluedMap qParams = info.getQueryParameters();
                for (MBeanAttributeInfo attribute : attributes = platformMBeanServer.getMBeanInfo(cacheManagerObjectName).getAttributes()) {
                    String attrName = attribute.getName();
                    if (EXCLUDED_ATTRIBUTES.contains(attrName) || qParams != null && qParams.get((Object)"show") != null && !((List)qParams.get((Object)"show")).contains(attrName)) continue;
                    Object attrValue = platformMBeanServer.getAttribute(cacheManagerObjectName, attrName);
                    e.getAttributes().put(attrName, attrValue);
                }
                result.add(e);
            }
            return result;
        }
        catch (Exception ex) {
            throw new WebApplicationException(Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)ex.getMessage()).build());
        }
    }

    public void updateCacheManager(@Context UriInfo info, CacheManagerEntity resource) {
        throw new WebApplicationException(Response.status((Response.Status)Response.Status.SERVICE_UNAVAILABLE).entity((Object)"Not yet implemented").build());
    }

    private List<ObjectName> findCacheManagerObjectNames(MBeanServer platformMBeanServer, String[] cacheManagerNamesArg) throws MalformedObjectNameException, InstanceNotFoundException, ReflectionException, AttributeNotFoundException, MBeanException {
        Map<String, ObjectName> allCacheManagerObjectNamesByCacheManagerName = CacheManagerJmxClient.getAllCacheManagerObjectNamesByCacheManagerName(platformMBeanServer);
        ArrayList<ObjectName> cacheManagerObjectNames = new ArrayList<ObjectName>();
        if (cacheManagerNamesArg == null) {
            for (ObjectName cacheManagerObjectName : allCacheManagerObjectNamesByCacheManagerName.values()) {
                cacheManagerObjectNames.add(cacheManagerObjectName);
            }
        } else {
            for (String name : cacheManagerNamesArg) {
                ObjectName objectName = allCacheManagerObjectNamesByCacheManagerName.get(name);
                cacheManagerObjectNames.add(objectName);
            }
        }
        return cacheManagerObjectNames;
    }
}

