/*
 * Decompiled with CFR 0.152.
 */
package net.sf.ehcache.management.service.impl;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import net.sf.ehcache.management.service.AccessorPrefix;
import org.slf4j.Logger;

abstract class ConstrainableEntityBuilderSupport<SAMPLER> {
    private Set<String> constraints;

    ConstrainableEntityBuilderSupport() {
    }

    abstract Logger getLog();

    protected void addConstraints(Set<String> constraints) {
        if (constraints == null) {
            throw new IllegalArgumentException("constraints == null");
        }
        if (this.constraints == null) {
            this.constraints = constraints;
        } else {
            this.constraints.addAll(constraints);
        }
    }

    protected Set<String> getAttributeConstraints() {
        return this.constraints;
    }

    protected void buildAttributeMapByAttribute(Class<?> api, SAMPLER sampler, Map<String, Object> attributeMap, Collection<String> attributes, String nameAccessor) {
        for (String attribute : attributes) {
            Method method = null;
            for (AccessorPrefix prefix : AccessorPrefix.values()) {
                try {
                    method = api.getMethod((Object)((Object)prefix) + attribute, new Class[0]);
                    break;
                }
                catch (NoSuchMethodException e) {
                }
            }
            if (method == null || nameAccessor.equals(method.getName())) continue;
            this.addAttribute(sampler, attributeMap, attribute, method);
        }
    }

    protected void buildAttributeMapByApi(Class<?> api, SAMPLER sampler, Map<String, Object> attributeMap, Collection<String> attributes, String nameAccessor) {
        for (Method method : api.getMethods()) {
            String name = method.getName();
            String trimmedName = AccessorPrefix.trimPrefix(name);
            if (nameAccessor.equals(name) || !AccessorPrefix.isAccessor(name) || attributes != null && !attributes.contains(trimmedName)) continue;
            this.addAttribute(sampler, attributeMap, trimmedName, method);
        }
    }

    private void addAttribute(SAMPLER sampler, Map<String, Object> attributeMap, String attribute, Method method) {
        try {
            attributeMap.put(attribute, method.invoke(sampler, new Object[0]));
        }
        catch (IllegalAccessException e) {
            this.getLog().warn(String.format("Failed to invoke method %s while constructing entity due to access restriction.", method.getName()));
        }
        catch (InvocationTargetException e) {
            this.getLog().warn(String.format("Failed to invoke method %s while constructing entity. %s", method.getName(), e.getMessage()));
        }
    }
}

