/*
 * Decompiled with CFR 0.152.
 */
package net.sf.ehcache.management.resource.services;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import javax.ws.rs.Path;
import javax.ws.rs.core.PathSegment;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import net.sf.ehcache.management.EmbeddedEhcacheServiceLocator;
import net.sf.ehcache.management.resource.CacheManagerConfigEntity;
import net.sf.ehcache.management.resource.ConfigContainerEntity;
import net.sf.ehcache.management.resource.services.CacheManagerConfigsResourceService;
import net.sf.ehcache.management.service.EntityResourceFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.terracotta.management.resource.services.validator.RequestValidator;

@Path(value="/agents/cacheManagers/configs")
public final class CacheManagerConfigsResourceServiceImpl
implements CacheManagerConfigsResourceService {
    private static final Logger LOG = LoggerFactory.getLogger(CacheManagerConfigsResourceService.class);
    private final EntityResourceFactory entityResourceFactory;
    private final RequestValidator validator;

    public CacheManagerConfigsResourceServiceImpl() {
        EmbeddedEhcacheServiceLocator entityRsrcFactoryLocator = EmbeddedEhcacheServiceLocator.locator();
        this.entityResourceFactory = entityRsrcFactoryLocator.locateEntityResourceFactory();
        EmbeddedEhcacheServiceLocator reqValidatorLocator = EmbeddedEhcacheServiceLocator.locator();
        this.validator = reqValidatorLocator.locateRequestValidator();
    }

    public Response getXMLCacheManagerConfigs(UriInfo info) {
        LOG.info(String.format("Invoking CacheManagerConfigsResourceServiceImpl.getXMLCacheManagerConfigs: %s", info.getRequestUri()));
        this.validator.validateSafe(info);
        String names = (String)((PathSegment)info.getPathSegments().get(1)).getMatrixParameters().getFirst((Object)"names");
        HashSet<String> cmNames = names == null ? null : new HashSet<String>(Arrays.asList(names.split(",")));
        Collection<CacheManagerConfigEntity> configs = this.entityResourceFactory.createCacheManagerConfigEntities((Set<String>)cmNames);
        ConfigContainerEntity cc = new ConfigContainerEntity();
        cc.setConfiguration(configs);
        cc.setAgentId("embedded");
        return Response.ok((Object)cc).build();
    }
}

