/*
 * Decompiled with CFR 0.152.
 */
package net.sf.ehcache.management;

import net.sf.ehcache.CacheException;
import net.sf.ehcache.CacheManager;
import net.sf.ehcache.config.ManagementRESTServiceConfiguration;
import net.sf.ehcache.management.EmbeddedEhcacheServiceLocator;
import net.sf.ehcache.management.ManagementServer;
import net.sf.ehcache.management.resource.services.validator.impl.EmbeddedEhcacheRequestValidator;
import net.sf.ehcache.management.service.SamplerRepositoryService;
import net.sf.ehcache.management.service.impl.DfltSamplerRepositoryService;
import org.terracotta.management.ServiceLocator;
import org.terracotta.management.embedded.StandaloneServer;
import org.terracotta.management.resource.services.validator.RequestValidator;

public final class ManagementServerImpl
implements ManagementServer {
    private final StandaloneServer standaloneServer = new StandaloneServer();
    private final SamplerRepositoryService samplerRepoSvc;

    public ManagementServerImpl(ManagementRESTServiceConfiguration configuration) {
        this.setupContainer(configuration);
        this.loadEmbeddedAgentServiceLocator(configuration);
        EmbeddedEhcacheServiceLocator locator = EmbeddedEhcacheServiceLocator.locator();
        this.samplerRepoSvc = locator.locateSamplerRepositoryService();
    }

    public void start() {
        try {
            this.standaloneServer.start();
        }
        catch (Exception e) {
            throw new CacheException("error starting management server", (Throwable)e);
        }
    }

    public void stop() {
        try {
            this.standaloneServer.stop();
        }
        catch (Exception e) {
            throw new CacheException("error stopping management server", (Throwable)e);
        }
    }

    public void register(CacheManager managedResource) {
        this.samplerRepoSvc.register(managedResource);
    }

    public void unregister(CacheManager managedResource) {
        this.samplerRepoSvc.unregister(managedResource);
    }

    public boolean hasRegistered() {
        return this.samplerRepoSvc.hasRegistered();
    }

    private void setupContainer(ManagementRESTServiceConfiguration configuration) {
        this.standaloneServer.setBasePackage("net.sf.ehcache.management");
        this.standaloneServer.setHost(configuration.getHost());
        this.standaloneServer.setPort(configuration.getPort());
    }

    private void loadEmbeddedAgentServiceLocator(ManagementRESTServiceConfiguration configuration) {
        configuration.setNeedClientAuth(false);
        configuration.setSecurityServiceLocation(null);
        configuration.setSslEnabled(false);
        configuration.setSecurityServiceTimeout(0);
        DfltSamplerRepositoryService samplerRepoSvc = new DfltSamplerRepositoryService();
        ServiceLocator.load((ServiceLocator)new EmbeddedEhcacheServiceLocator(true, (RequestValidator)new EmbeddedEhcacheRequestValidator(), samplerRepoSvc, samplerRepoSvc, samplerRepoSvc, samplerRepoSvc, configuration));
    }
}

