/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.modules.ehcache.store.bulkload;

import java.io.Serializable;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import net.sf.ehcache.store.StoreListener;
import org.terracotta.modules.ehcache.store.bulkload.BulkLoadConstants;
import org.terracotta.modules.ehcache.store.bulkload.BulkLoadEnabledNodesSet;
import org.terracotta.modules.ehcache.store.bulkload.BulkLoadShutdownHook;
import org.terracotta.toolkit.builder.ToolkitCacheConfigBuilder;
import org.terracotta.toolkit.cache.ToolkitCache;
import org.terracotta.toolkit.cache.ToolkitCacheListener;
import org.terracotta.toolkit.cluster.ClusterNode;
import org.terracotta.toolkit.concurrent.locks.ToolkitReadWriteLock;
import org.terracotta.toolkit.config.Configuration;
import org.terracotta.toolkit.internal.ToolkitInternal;
import org.terracotta.toolkit.internal.ToolkitLogger;
import org.terracotta.toolkit.internal.cache.ToolkitCacheInternal;
import org.terracotta.toolkit.internal.concurrent.locks.ToolkitLockTypeInternal;
import org.terracotta.toolkit.search.QueryBuilder;
import org.terracotta.toolkit.search.attribute.ToolkitAttributeExtractor;

public class BulkLoadToolkitCache<K, V>
implements ToolkitCacheInternal<K, V> {
    private static final String BULK_LOAD_LOCK_ID = "bulk-load-concurrent-lock";
    private final ToolkitLogger logger;
    private final ReentrantReadWriteLock readWriteLock = new ReentrantReadWriteLock();
    private final ToolkitCacheInternal<K, V> toolkitCache;
    private final BulkLoadEnabledNodesSet bulkLoadEnabledNodesSet;
    private final AtomicBoolean currentNodeBulkLoadEnabled = new AtomicBoolean(false);
    private final ToolkitInternal toolkitInternal;
    private final Lock concurrentLock;
    private boolean localCacheEnabledBeforeBulkloadEnabled;
    private final String name;
    private final BulkLoadShutdownHook bulkLoadShutdownHook;
    private final boolean loggingEnabled;

    public BulkLoadToolkitCache(ToolkitInternal toolkit, String name, ToolkitCacheInternal<K, V> aggregateServerMap, BulkLoadShutdownHook bulkLoadShutdownHook, StoreListener listener) {
        this.toolkitInternal = toolkit;
        this.name = name;
        this.logger = toolkit.getLogger(BulkLoadToolkitCache.class.getName());
        this.toolkitCache = aggregateServerMap;
        this.bulkLoadEnabledNodesSet = new BulkLoadEnabledNodesSet(toolkit, name, listener);
        this.bulkLoadShutdownHook = bulkLoadShutdownHook;
        this.loggingEnabled = BulkLoadConstants.isLoggingEnabled(toolkit.getProperties());
        this.concurrentLock = toolkit.getLock(BULK_LOAD_LOCK_ID, ToolkitLockTypeInternal.CONCURRENT);
    }

    public void debug(String msg) {
        this.logger.info((Object)("['" + this.name + "'] " + msg));
    }

    public void acquireLocalReadLock() {
        this.readWriteLock.readLock().lock();
    }

    public void acquireLocalWriteLock() {
        this.readWriteLock.writeLock().lock();
    }

    public void releaseLocalReadLock() {
        this.readWriteLock.readLock().unlock();
    }

    public void releaseLocalWriteLock() {
        this.readWriteLock.writeLock().unlock();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setBulkLoadEnabledInCurrentNode(boolean enableBulkLoad) {
        this.acquireLocalWriteLock();
        try {
            if (enableBulkLoad) {
                if (this.currentNodeBulkLoadEnabled.compareAndSet(false, true)) {
                    this.enterBulkLoadMode();
                } else if (this.loggingEnabled) {
                    this.debug("Trying to enable bulk-load mode when already bulk-loading.");
                }
            } else if (this.currentNodeBulkLoadEnabled.compareAndSet(true, false)) {
                this.exitBulkLoadMode();
            } else if (this.loggingEnabled) {
                this.debug("Trying to disable bulk-load mode when not bulk-loading.");
            }
        }
        finally {
            this.releaseLocalWriteLock();
        }
    }

    private void enterBulkLoadMode() {
        if (this.loggingEnabled) {
            this.debug("Enabling bulk-load");
        }
        this.localCacheEnabledBeforeBulkloadEnabled = this.toolkitCache.getConfiguration().getBoolean("localCacheEnabled");
        if (this.localCacheEnabledBeforeBulkloadEnabled) {
            this.setLocalCacheEnabled(false);
        }
        this.bulkLoadEnabledNodesSet.addCurrentNode();
        this.bulkLoadShutdownHook.registerCache(this);
    }

    private void exitBulkLoadMode() {
        if (this.loggingEnabled) {
            this.debug("Turning off bulk-load");
        }
        this.toolkitInternal.waitUntilAllTransactionsComplete();
        this.toolkitCache.clearLocalCache();
        if (this.localCacheEnabledBeforeBulkloadEnabled) {
            this.setLocalCacheEnabled(true);
        }
        this.bulkLoadEnabledNodesSet.removeCurrentNode();
        this.bulkLoadShutdownHook.unregisterCache((ToolkitCache)this);
    }

    private void setLocalCacheEnabled(boolean enabled) {
        new ToolkitCacheConfigBuilder().localCacheEnabled(enabled).apply(this.toolkitCache);
    }

    public void waitUntilBulkLoadCompleteInCluster() throws InterruptedException {
        this.bulkLoadEnabledNodesSet.waitUntilSetEmpty();
    }

    public boolean isBulkLoadEnabledInCluster() {
        return this.bulkLoadEnabledNodesSet.isBulkLoadEnabledInCluster();
    }

    public boolean isBulkLoadEnabledInCurrentNode() {
        return this.currentNodeBulkLoadEnabled.get();
    }

    public V getQuiet(Object key) {
        return this.doGet(key, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void putNoReturn(K key, V value, long createTimeInSecs, int customMaxTTISeconds, int customMaxTTLSeconds) {
        this.concurrentLock.lock();
        try {
            this.toolkitCache.unlockedPutNoReturn(key, value, (int)createTimeInSecs, customMaxTTISeconds, customMaxTTLSeconds);
        }
        finally {
            this.concurrentLock.unlock();
        }
    }

    public V putIfAbsent(K key, V value, long createTimeInSecs, int customMaxTTISeconds, int customMaxTTLSeconds) {
        throw new UnsupportedOperationException();
    }

    public V unsafeLocalGet(Object key) {
        return (V)this.toolkitCache.unsafeLocalGet(key);
    }

    public void putNoReturn(K key, V value) {
        this.putNoReturn(key, value, this.now(), 0, 0);
    }

    public int localSize() {
        return this.toolkitCache.localSize();
    }

    public Set<K> localKeySet() {
        return this.toolkitCache.localKeySet();
    }

    public boolean containsLocalKey(Object key) {
        return this.toolkitCache.containsLocalKey(key);
    }

    public Map<K, V> getAll(Collection<? extends K> keys) {
        return this.toolkitCache.getAll(keys);
    }

    public Map<K, V> getAllQuiet(Collection<K> keys) {
        return this.toolkitCache.getAllQuiet(keys);
    }

    public void addListener(ToolkitCacheListener<K> listener) {
        this.toolkitCache.addListener(listener);
    }

    public void removeListener(ToolkitCacheListener<K> listener) {
        this.toolkitCache.removeListener(listener);
    }

    public ToolkitReadWriteLock createLockForKey(K key) {
        return this.toolkitCache.createLockForKey(key);
    }

    public Configuration getConfiguration() {
        return this.toolkitCache.getConfiguration();
    }

    public void setConfigField(String name, Serializable value) {
        this.toolkitCache.setConfigField(name, value);
    }

    public boolean containsKey(Object key) {
        return this.toolkitCache.containsKey(key);
    }

    public boolean containsValue(Object arg0) {
        throw new UnsupportedOperationException();
    }

    public Set<Map.Entry<K, V>> entrySet() {
        return this.toolkitCache.entrySet();
    }

    public V get(Object obj) {
        return this.doGet(obj, false);
    }

    public V doGet(Object obj, boolean quiet) {
        return (V)this.toolkitCache.unlockedGet(obj, quiet);
    }

    public boolean isEmpty() {
        return this.size() == 0;
    }

    public Set<K> keySet() {
        return this.toolkitCache.keySet();
    }

    private int now() {
        return (int)System.currentTimeMillis() / 1000;
    }

    public void putAll(Map<? extends K, ? extends V> map) {
        for (Map.Entry<K, V> e : map.entrySet()) {
            this.putNoReturn(e.getKey(), e.getValue());
        }
    }

    public void removeAll(Set<K> keys) {
        for (K key : keys) {
            this.remove(key);
        }
    }

    public int size() {
        return this.toolkitCache.size();
    }

    public Collection<V> values() {
        throw new UnsupportedOperationException();
    }

    public String getName() {
        return this.toolkitCache.getName();
    }

    public boolean isDestroyed() {
        return this.toolkitCache.isDestroyed();
    }

    public void destroy() {
        this.bulkLoadEnabledNodesSet.disposeLocally();
        this.toolkitCache.destroy();
    }

    public void disposeLocally() {
        this.bulkLoadEnabledNodesSet.disposeLocally();
        this.toolkitCache.disposeLocally();
    }

    public V putIfAbsent(K key, V value) {
        throw new UnsupportedOperationException();
    }

    public boolean remove(Object key, Object value) {
        throw new UnsupportedOperationException();
    }

    public boolean replace(K key, V oldValue, V newValue) {
        throw new UnsupportedOperationException();
    }

    public V replace(K key, V value) {
        throw new UnsupportedOperationException();
    }

    public void clear() {
        this.toolkitCache.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeNoReturn(Object key) {
        this.concurrentLock.lock();
        try {
            this.toolkitCache.unlockedRemoveNoReturn(key);
        }
        finally {
            this.concurrentLock.unlock();
        }
    }

    public V remove(Object key) {
        Object rv = this.toolkitCache.unlockedGet(key, true);
        this.removeNoReturn(key);
        return (V)rv;
    }

    public QueryBuilder createQueryBuilder() {
        return this.toolkitCache.createQueryBuilder();
    }

    public long localOnHeapSizeInBytes() {
        return this.toolkitCache.localOnHeapSizeInBytes();
    }

    public long localOffHeapSizeInBytes() {
        return this.toolkitCache.localOffHeapSizeInBytes();
    }

    public int localOnHeapSize() {
        return this.toolkitCache.localOnHeapSize();
    }

    public int localOffHeapSize() {
        return this.toolkitCache.localOffHeapSize();
    }

    public boolean containsKeyLocalOnHeap(Object key) {
        return this.toolkitCache.containsKeyLocalOnHeap(key);
    }

    public boolean containsKeyLocalOffHeap(Object key) {
        return this.toolkitCache.containsKeyLocalOffHeap(key);
    }

    public V put(K key, V value) {
        return this.put(key, value, this.now(), 0, 0);
    }

    public V put(K key, V value, int createTimeInSecs, int customMaxTTISeconds, int customMaxTTLSeconds) {
        Object rv = this.toolkitCache.unlockedGet(key, true);
        this.putNoReturn(key, value, createTimeInSecs, customMaxTTISeconds, customMaxTTLSeconds);
        return (V)rv;
    }

    public Map<Object, Set<ClusterNode>> getNodesWithKeys(Set portableKeys) {
        return this.toolkitCache.getNodesWithKeys(portableKeys);
    }

    public void unlockedPutNoReturn(K k, V v, int createTime, int customTTI, int customTTL) {
        this.toolkitCache.unlockedPutNoReturn(k, v, createTime, customTTI, customTTL);
    }

    public void unlockedRemoveNoReturn(Object k) {
        this.toolkitCache.unlockedRemoveNoReturn(k);
    }

    public void clearLocalCache() {
        throw new UnsupportedOperationException();
    }

    public V unlockedGet(Object k, boolean quiet) {
        return this.doGet(k, quiet);
    }

    public void setAttributeExtractor(ToolkitAttributeExtractor<K, V> extractor) {
        this.toolkitCache.setAttributeExtractor(extractor);
    }

    public Map<K, V> unlockedGetAll(Collection<K> keys, boolean quiet) {
        return quiet ? this.getAllQuiet(keys) : this.getAll(keys);
    }
}

