/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.modules.ehcache.store;

import java.io.Serializable;
import net.sf.ehcache.Ehcache;
import net.sf.ehcache.config.CacheConfiguration;
import net.sf.ehcache.config.CacheConfigurationListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.terracotta.modules.ehcache.store.CacheConfigChangeNotificationMsg;
import org.terracotta.toolkit.cache.ToolkitCache;
import org.terracotta.toolkit.events.ToolkitNotificationEvent;
import org.terracotta.toolkit.events.ToolkitNotificationListener;
import org.terracotta.toolkit.events.ToolkitNotifier;
import org.terracotta.toolkit.internal.cache.ToolkitCacheInternal;

public class CacheConfigChangeBridge
implements CacheConfigurationListener,
ToolkitNotificationListener {
    private static final Logger LOG = LoggerFactory.getLogger(CacheConfigChangeBridge.class);
    private final ToolkitNotifier notifier;
    private final ToolkitCache backend;
    private final Ehcache cache;
    private final String fullyQualifiedEhcacheName;

    public CacheConfigChangeBridge(Ehcache cache, String fullyQualifiedEhcacheName, ToolkitCacheInternal backend, ToolkitNotifier<CacheConfigChangeNotificationMsg> notifier) {
        this.cache = cache;
        this.fullyQualifiedEhcacheName = fullyQualifiedEhcacheName;
        this.backend = backend;
        this.notifier = notifier;
    }

    public void connectConfigs() {
        this.cache.getCacheConfiguration().addConfigurationListener((CacheConfigurationListener)this);
        this.notifier.addNotificationListener((ToolkitNotificationListener)this);
    }

    public void disconnectConfigs() {
        this.cache.getCacheConfiguration().removeConfigurationListener((CacheConfigurationListener)this);
        this.notifier.removeNotificationListener((ToolkitNotificationListener)this);
    }

    private void change(DynamicConfigType type, Serializable newValue, boolean notifyRemote) {
        this.backend.setConfigField(type.getToolkitConfigName(), newValue);
        if (notifyRemote) {
            this.notifier.notifyListeners((Object)new CacheConfigChangeNotificationMsg(this.fullyQualifiedEhcacheName, type.getToolkitConfigName(), newValue));
        }
    }

    public void timeToIdleChanged(long oldTimeToIdle, long newTimeToIdle) {
        this.change(DynamicConfigType.MAX_TTI_SECONDS, Integer.valueOf((int)newTimeToIdle), true);
    }

    public void timeToLiveChanged(long oldTimeToLive, long newTimeToLive) {
        this.change(DynamicConfigType.MAX_TTL_SECONDS, Integer.valueOf((int)newTimeToLive), true);
    }

    public void diskCapacityChanged(int oldCapacity, int newCapacity) {
        throw new IllegalStateException("Disk capacity should not change for terracotta clustered caches");
    }

    public void maxEntriesInCacheChanged(long oldCapacity, long newCapacity) {
        if (newCapacity > Integer.MAX_VALUE) {
            throw new IllegalArgumentException("Values greater than Integer.MAX_VALUE are not currently supported.");
        }
        this.change(DynamicConfigType.MAX_TOTAL_COUNT, Integer.valueOf(CacheConfigChangeBridge.mapMaxEntriesInCacheToTotalCount((int)newCapacity)), true);
    }

    public void memoryCapacityChanged(int oldCapacity, int newCapacity) {
        this.change(DynamicConfigType.MAX_COUNT_LOCAL_HEAP, Integer.valueOf(newCapacity), false);
    }

    public void maxBytesLocalHeapChanged(long oldValue, long newValue) {
        this.change(DynamicConfigType.MAX_BYTES_LOCAL_HEAP, Long.valueOf(newValue), false);
    }

    public void maxBytesLocalDiskChanged(long oldValue, long newValue) {
    }

    public void loggingChanged(boolean oldValue, boolean newValue) {
    }

    public void registered(CacheConfiguration config) {
    }

    public void deregistered(CacheConfiguration config) {
    }

    public void onNotification(ToolkitNotificationEvent event) {
        if (this.shouldProcessNotification(event)) {
            this.processConfigChangeNotification((CacheConfigChangeNotificationMsg)event.getMessage());
        } else {
            LOG.warn("Ignoring uninterested notification - " + event);
        }
    }

    private void processConfigChangeNotification(CacheConfigChangeNotificationMsg notification) {
        try {
            DynamicConfigType type = DynamicConfigType.getTypeFromToolkitConfigName(notification.getToolkitConfigName());
            Serializable newValue = notification.getNewValue();
            switch (type) {
                case MAX_TTI_SECONDS: {
                    this.cache.getCacheConfiguration().internalSetTimeToIdle(CacheConfigChangeBridge.getLong(newValue));
                    break;
                }
                case MAX_TTL_SECONDS: {
                    this.cache.getCacheConfiguration().internalSetTimeToLive(CacheConfigChangeBridge.getLong(newValue));
                    break;
                }
                case MAX_TOTAL_COUNT: {
                    this.cache.getCacheConfiguration().internalSetMaxEntriesInCache(CacheConfigChangeBridge.mapTotalCountToMaxEntriesInCache(CacheConfigChangeBridge.getInt(newValue)));
                    break;
                }
                case MAX_COUNT_LOCAL_HEAP: {
                    this.cache.getCacheConfiguration().internalSetMemCapacity(CacheConfigChangeBridge.getInt(newValue));
                    break;
                }
                case MAX_BYTES_LOCAL_HEAP: {
                    this.cache.getCacheConfiguration().internalSetMemCapacityInBytes(CacheConfigChangeBridge.getLong(newValue));
                }
            }
        }
        catch (IllegalArgumentException e) {
            LOG.warn("Notification will be ignored. Caught IllegalArgumentException while processing notification: " + notification + ", exception: " + e.getMessage());
        }
    }

    private boolean shouldProcessNotification(ToolkitNotificationEvent event) {
        return event.getMessage() instanceof CacheConfigChangeNotificationMsg && ((CacheConfigChangeNotificationMsg)event.getMessage()).getFullyQualifiedEhcacheName().equals(this.fullyQualifiedEhcacheName);
    }

    private static long getLong(Object newValue) {
        if (newValue instanceof Integer) {
            return ((Integer)newValue).intValue();
        }
        if (newValue instanceof Long) {
            return (Long)newValue;
        }
        throw new IllegalArgumentException("Expected long value but got: " + newValue);
    }

    private static int getInt(Object newValue) {
        if (newValue instanceof Integer) {
            return (Integer)newValue;
        }
        throw new IllegalArgumentException("Expected int value but got: " + newValue);
    }

    public static int mapMaxEntriesInCacheToTotalCount(int maxEntriesInCache) {
        if (maxEntriesInCache == 0) {
            return -1;
        }
        return maxEntriesInCache;
    }

    private static int mapTotalCountToMaxEntriesInCache(int totalCount) {
        if (totalCount == -1) {
            return 0;
        }
        return totalCount;
    }

    private static enum DynamicConfigType {
        MAX_TOTAL_COUNT("maxTotalCount"),
        MAX_COUNT_LOCAL_HEAP("maxCountLocalHeap"),
        MAX_BYTES_LOCAL_HEAP("maxBytesLocalHeap"),
        MAX_TTI_SECONDS("maxTTISeconds"),
        MAX_TTL_SECONDS("maxTTLSeconds");

        private final String toolkitConfigName;

        private DynamicConfigType(String toolkitConfigName) {
            this.toolkitConfigName = toolkitConfigName;
        }

        public String getToolkitConfigName() {
            return this.toolkitConfigName;
        }

        public static DynamicConfigType getTypeFromToolkitConfigName(String toolkitName) {
            for (DynamicConfigType type : DynamicConfigType.values()) {
                if (!type.getToolkitConfigName().equals(toolkitName)) continue;
                return type;
            }
            throw new IllegalArgumentException("Unknown toolkit config name - " + toolkitName);
        }
    }
}

