/*
 * Copyright Terracotta, Inc.
 * Copyright Super iPaaS Integration LLC, an IBM Company 2024
 */
package com.terracotta.management.resource.services.utils;

/**
 * @author Ludovic Orban
 */
public class TimeStringParser {

  public static long parseTime(String timeString) throws NumberFormatException {
      if (timeString.endsWith("d")) {
        String days = timeString.substring(0, timeString.length() - 1);
        return System.currentTimeMillis() - Integer.parseInt(days) * 24 * 60 * 60 * 1000L;
      } else if (timeString.endsWith("h")) {
        String hours = timeString.substring(0, timeString.length() - 1);
        return System.currentTimeMillis() - Integer.parseInt(hours) * 60 * 60 * 1000L;
      } else if (timeString.endsWith("m")) {
        String minutes = timeString.substring(0, timeString.length() - 1);
        return System.currentTimeMillis() - Integer.parseInt(minutes) * 60 * 1000L;
      } else if (timeString.endsWith("s")) {
        String seconds = timeString.substring(0, timeString.length() - 1);
        return System.currentTimeMillis() - Integer.parseInt(seconds) * 1000L;
      } else {
        return Long.parseLong(timeString);
      }
  }

}
