/*
 * Decompiled with CFR 0.152.
 */
package net.sf.ehcache.terracotta;

import net.sf.ehcache.CacheException;
import net.sf.ehcache.Ehcache;
import net.sf.ehcache.cluster.CacheCluster;
import net.sf.ehcache.config.TerracottaClientConfiguration;
import net.sf.ehcache.event.CacheEventListener;
import net.sf.ehcache.store.Store;
import net.sf.ehcache.terracotta.ClusteredInstanceFactory;
import net.sf.ehcache.transaction.xa.EhcacheXAStore;
import net.sf.ehcache.writer.writebehind.WriteBehind;
import org.terracotta.express.Client;
import org.terracotta.express.ClientFactory;

public class StandaloneTerracottaClusteredInstanceFactory
implements ClusteredInstanceFactory {
    private final Client client;
    private final ClusteredInstanceFactory realFactory;

    public StandaloneTerracottaClusteredInstanceFactory(TerracottaClientConfiguration terracottaConfig) {
        boolean isURLConfig = terracottaConfig.isUrlConfig();
        String tcConfig = null;
        tcConfig = isURLConfig ? terracottaConfig.getUrl() : terracottaConfig.getEmbeddedConfig();
        this.client = ClientFactory.getOrCreateClient((String)tcConfig, (boolean)isURLConfig, (Class[])new Class[]{this.getClass()});
        try {
            this.realFactory = (ClusteredInstanceFactory)this.client.instantiate("org.terracotta.modules.ehcache.store.TerracottaClusteredInstanceFactory", new Class[]{TerracottaClientConfiguration.class}, new Object[]{terracottaConfig});
        }
        catch (Exception e) {
            throw new CacheException("Unable to create Terracotta client", (Throwable)e);
        }
    }

    public Store createStore(Ehcache cache) {
        return this.realFactory.createStore(cache);
    }

    public WriteBehind createWriteBehind(Ehcache cache) {
        return this.realFactory.createWriteBehind(cache);
    }

    public CacheEventListener createEventReplicator(Ehcache cache) {
        return this.realFactory.createEventReplicator(cache);
    }

    public String getUUID() {
        return this.realFactory.getUUID();
    }

    public CacheCluster getTopology() {
        return this.realFactory.getTopology();
    }

    public EhcacheXAStore createXAStore(Ehcache cache, Store store, boolean bypassValidation) {
        return this.realFactory.createXAStore(cache, store, bypassValidation);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown() {
        try {
            this.realFactory.shutdown();
        }
        finally {
            this.client.shutdown();
        }
    }
}

