/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.agent.repkg.de.schlichtherle.io;

import java.io.IOException;
import org.terracotta.agent.repkg.de.schlichtherle.io.rof.FilterReadOnlyFile;
import org.terracotta.agent.repkg.de.schlichtherle.io.rof.ReadOnlyFile;

final class CountingReadOnlyFile
extends FilterReadOnlyFile {
    private static volatile long total;
    private static volatile boolean reset;

    CountingReadOnlyFile(ReadOnlyFile rof) {
        super(rof);
        CountingReadOnlyFile.init();
    }

    static long getTotal() {
        return total;
    }

    static void init() {
        if (reset) {
            reset = false;
            total = 0L;
        }
    }

    static void resetOnInit() {
        reset = true;
    }

    public int read() throws IOException {
        int ret = this.rof.read();
        if (ret != -1) {
            ++total;
        }
        return ret;
    }

    public int read(byte[] b) throws IOException {
        int ret = this.rof.read(b);
        if (ret != -1) {
            total += (long)ret;
        }
        return ret;
    }

    public int read(byte[] b, int off, int len) throws IOException {
        int ret = this.rof.read(b, off, len);
        if (ret != -1) {
            total += (long)ret;
        }
        return ret;
    }

    public int skipBytes(int n) throws IOException {
        int ret = this.rof.skipBytes(n);
        total += (long)ret;
        return ret;
    }
}

