/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.agent.repkg.de.schlichtherle.util.zip;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.lang.ref.Reference;
import java.lang.ref.SoftReference;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.zip.CRC32;
import java.util.zip.Checksum;
import java.util.zip.DataFormatException;
import java.util.zip.Inflater;
import java.util.zip.InflaterInputStream;
import java.util.zip.ZipException;
import org.terracotta.agent.repkg.de.schlichtherle.io.rof.BufferedReadOnlyFile;
import org.terracotta.agent.repkg.de.schlichtherle.io.rof.ReadOnlyFile;
import org.terracotta.agent.repkg.de.schlichtherle.io.rof.SimpleReadOnlyFile;
import org.terracotta.agent.repkg.de.schlichtherle.util.zip.CRC32Exception;
import org.terracotta.agent.repkg.de.schlichtherle.util.zip.ZipEntry;

public class BasicZipFile {
    private static final long LONG_MSB = Long.MIN_VALUE;
    private static final int LFH_FILE_NAME_LENGTH_OFFSET = 26;
    private static final int EOCD_NUM_ENTRIES_OFFSET = 10;
    private static final int EOCD_CD_SIZE_OFFSET = 12;
    private static final int EOCD_CD_LOCATION_OFFSET = 16;
    private static final int EOCD_COMMENT_OFFSET = 20;
    private static final Set allocatedInflaters = new HashSet();
    private static final List releasedInflaters = new LinkedList();
    public static final String DEFAULT_CHARSET = "UTF-8";
    private final String charset;
    private String comment;
    private final Map entries = new LinkedHashMap();
    private ReadOnlyFile archive;
    private int openStreams;
    private long preamble;
    private long postamble;
    private OffsetMapper mapper;

    public BasicZipFile(String name) throws NullPointerException, FileNotFoundException, ZipException, IOException {
        this.charset = DEFAULT_CHARSET;
        try {
            this.init(null, new File(name), true, false);
        }
        catch (UnsupportedEncodingException cannotHappen) {
            throw new AssertionError((Object)cannotHappen);
        }
    }

    public BasicZipFile(String name, String charset) throws NullPointerException, UnsupportedEncodingException, FileNotFoundException, ZipException, IOException {
        this.charset = charset;
        this.init(null, new File(name), true, false);
    }

    public BasicZipFile(String name, String charset, boolean preambled, boolean postambled) throws NullPointerException, UnsupportedEncodingException, FileNotFoundException, ZipException, IOException {
        this.charset = charset;
        this.init(null, new File(name), preambled, postambled);
    }

    public BasicZipFile(File file) throws NullPointerException, FileNotFoundException, ZipException, IOException {
        this.charset = DEFAULT_CHARSET;
        try {
            this.init(null, file, true, false);
        }
        catch (UnsupportedEncodingException cannotHappen) {
            throw new AssertionError((Object)cannotHappen);
        }
    }

    public BasicZipFile(File file, String charset) throws NullPointerException, UnsupportedEncodingException, FileNotFoundException, ZipException, IOException {
        this.charset = charset;
        this.init(null, file, true, false);
    }

    public BasicZipFile(File file, String charset, boolean preambled, boolean postambled) throws NullPointerException, UnsupportedEncodingException, FileNotFoundException, ZipException, IOException {
        this.charset = charset;
        this.init(null, file, preambled, postambled);
    }

    public BasicZipFile(ReadOnlyFile rof) throws NullPointerException, FileNotFoundException, ZipException, IOException {
        this.charset = DEFAULT_CHARSET;
        try {
            this.init(rof, null, true, false);
        }
        catch (UnsupportedEncodingException cannotHappen) {
            throw new AssertionError((Object)cannotHappen);
        }
    }

    public BasicZipFile(ReadOnlyFile rof, String charset) throws NullPointerException, UnsupportedEncodingException, FileNotFoundException, ZipException, IOException {
        this.charset = charset;
        this.init(rof, null, true, false);
    }

    public BasicZipFile(ReadOnlyFile rof, String charset, boolean preambled, boolean postambled) throws NullPointerException, UnsupportedEncodingException, FileNotFoundException, ZipException, IOException {
        this.charset = charset;
        this.init(rof, null, preambled, postambled);
    }

    private void init(ReadOnlyFile rof, File file, boolean preambled, boolean postambled) throws NullPointerException, UnsupportedEncodingException, FileNotFoundException, ZipException, IOException {
        if (this.charset == null) {
            throw new NullPointerException("charset");
        }
        new String(new byte[0], this.charset);
        if (rof == null) {
            if (file == null) {
                throw new NullPointerException();
            }
            rof = this.createReadOnlyFile(file);
        } else assert (file == null);
        this.archive = rof;
        try {
            BufferedReadOnlyFile brof = this.archive instanceof BufferedReadOnlyFile ? (BufferedReadOnlyFile)this.archive : new BufferedReadOnlyFile(this.archive);
            this.mountCentralDirectory(brof, preambled, postambled);
        }
        catch (IOException failure) {
            if (file != null) {
                rof.close();
            }
            throw failure;
        }
        assert (this.mapper != null);
    }

    protected ReadOnlyFile createReadOnlyFile(File file) throws FileNotFoundException, IOException {
        return new SimpleReadOnlyFile(file);
    }

    private void mountCentralDirectory(ReadOnlyFile rof, boolean preambled, boolean postambled) throws ZipException, IOException {
        int numEntries = this.findCentralDirectory(rof, preambled, postambled);
        assert (this.mapper != null);
        this.preamble = Long.MAX_VALUE;
        byte[] sig = new byte[4];
        byte[] cfh = new byte[46 - sig.length];
        while (true) {
            rof.readFully(sig);
            if (BasicZipFile.readUInt(sig, 0) != 33639248L) break;
            rof.readFully(cfh);
            int general = BasicZipFile.readUShort(cfh, 4);
            int nameLen = BasicZipFile.readUShort(cfh, 24);
            byte[] name = new byte[nameLen];
            rof.readFully(name);
            boolean utf8 = (general & 0x800) != 0;
            String charset = utf8 ? DEFAULT_CHARSET : this.charset;
            ZipEntry entry = this.createZipEntry(new String(name, charset));
            try {
                int off = 0;
                int versionMadeBy = BasicZipFile.readUShort(cfh, off);
                off += 2;
                entry.setPlatform((short)(versionMadeBy >> 8));
                off += 2;
                entry.setGeneral(general);
                off += 2;
                assert (entry.getGeneralBit(11) == utf8);
                int method = BasicZipFile.readUShort(cfh, off);
                off += 2;
                if (method != 0 && method != 8) {
                    throw new ZipException(entry.getName() + ": unsupported compression method: " + method);
                }
                entry.setMethod(method);
                entry.setDosTime(BasicZipFile.readUInt(cfh, off));
                entry.setCrc(BasicZipFile.readUInt(cfh, off += 4));
                entry.setCompressedSize(BasicZipFile.readUInt(cfh, off += 4));
                entry.setSize(BasicZipFile.readUInt(cfh, off += 4));
                off += 4;
                int extraLen = BasicZipFile.readUShort(cfh, off += 2);
                int commentLen = BasicZipFile.readUShort(cfh, off += 2);
                off += 2;
                off += 2;
                off += 2;
                long lfhOff = this.mapper.location(BasicZipFile.readUInt(cfh, off += 4));
                entry.offset = lfhOff | Long.MIN_VALUE;
                if (lfhOff < this.preamble) {
                    this.preamble = lfhOff;
                }
                if (extraLen > 0) {
                    byte[] extra = new byte[extraLen];
                    rof.readFully(extra);
                    entry.setExtra(extra);
                }
                if (commentLen > 0) {
                    byte[] comment = new byte[commentLen];
                    rof.readFully(comment);
                    entry.setComment(new String(comment, charset));
                }
            }
            catch (IllegalArgumentException incompatibleZipFile) {
                ZipException exc = new ZipException(entry.getName());
                exc.initCause(incompatibleZipFile);
                throw exc;
            }
            this.entries.put(entry.getName(), entry);
            --numEntries;
        }
        if (numEntries % 65536 != 0) {
            throw new ZipException("expected " + Math.abs(numEntries) + (numEntries > 0 ? " more" : " less") + " entries in the Central Directory");
        }
        if (this.preamble == Long.MAX_VALUE) {
            this.preamble = 0L;
        }
    }

    private int findCentralDirectory(ReadOnlyFile rof, boolean preambled, boolean postambled) throws ZipException, IOException {
        byte[] sig = new byte[4];
        if (!preambled) {
            rof.seek(0L);
            rof.readFully(sig);
            long signature = BasicZipFile.readUInt(sig, 0);
            boolean bl = preambled = signature == 67324752L || signature == 101010256L;
        }
        if (preambled) {
            long length = rof.length();
            long max = length - 22L;
            long min = !postambled && max >= 65535L ? max - 65535L : 0L;
            for (long eocdOff = max; eocdOff >= min; --eocdOff) {
                rof.seek(eocdOff);
                rof.readFully(sig);
                if (BasicZipFile.readUInt(sig, 0) != 101010256L) continue;
                byte[] eocd = new byte[22 - sig.length];
                rof.readFully(eocd);
                int numEntries = BasicZipFile.readUShort(eocd, 10 - sig.length);
                long cdSize = BasicZipFile.readUInt(eocd, 12 - sig.length);
                long cdLoc = BasicZipFile.readUInt(eocd, 16 - sig.length);
                int commentLen = BasicZipFile.readUShort(eocd, 20 - sig.length);
                if (commentLen > 0) {
                    byte[] comment = new byte[commentLen];
                    rof.readFully(comment);
                    this.setComment(new String(comment, this.charset));
                }
                this.postamble = length - rof.getFilePointer();
                long start = eocdOff - cdSize;
                rof.seek(start);
                this.mapper = (start -= cdLoc) != 0L ? new IrregularOffsetMapper(start) : new OffsetMapper();
                return numEntries;
            }
        }
        throw new ZipException("expected End Of Central Directory signature");
    }

    protected ZipEntry createZipEntry(String name) {
        return new ZipEntry(name);
    }

    public String getComment() {
        return this.comment;
    }

    private void setComment(String comment) {
        this.comment = comment;
    }

    public boolean busy() {
        return this.openStreams > 0;
    }

    public String getCharset() {
        return this.charset;
    }

    public String getEncoding() {
        return this.getCharset();
    }

    public Enumeration entries() {
        return Collections.enumeration(this.entries.values());
    }

    public ZipEntry getEntry(String name) {
        return (ZipEntry)this.entries.get(name);
    }

    public int size() {
        return this.entries.size();
    }

    public long length() throws IOException {
        this.ensureOpen();
        return this.archive.length();
    }

    public long getPreambleLength() {
        return this.preamble;
    }

    public InputStream getPreambleInputStream() throws IOException {
        this.ensureOpen();
        return new IntervalInputStream(0L, this.preamble);
    }

    public long getPostambleLength() {
        return this.postamble;
    }

    public InputStream getPostambleInputStream() throws IOException {
        this.ensureOpen();
        return new IntervalInputStream(this.archive.length() - this.postamble, this.postamble);
    }

    public boolean offsetsConsiderPreamble() {
        assert (this.mapper != null);
        return this.mapper.location(0L) == 0L;
    }

    public final InputStream getInputStream(String name) throws IOException {
        return this.getInputStream(name, false, true);
    }

    public final InputStream getInputStream(ZipEntry entry) throws IOException {
        return this.getInputStream(entry.getName(), false, true);
    }

    public final InputStream getCheckedInputStream(String name) throws IOException {
        return this.getInputStream(name, true, true);
    }

    public final InputStream getCheckedInputStream(ZipEntry entry) throws IOException {
        return this.getInputStream(entry.getName(), true, true);
    }

    public InputStream getInputStream(String name, boolean inflate) throws IOException {
        return this.getInputStream(name, false, inflate);
    }

    public final InputStream getInputStream(ZipEntry entry, boolean inflate) throws IOException {
        return this.getInputStream(entry.getName(), false, inflate);
    }

    protected InputStream getInputStream(String name, boolean check, boolean inflate) throws IOException {
        this.ensureOpen();
        if (name == null) {
            throw new NullPointerException();
        }
        ZipEntry entry = (ZipEntry)this.entries.get(name);
        if (entry == null) {
            return null;
        }
        long offset = entry.offset;
        assert (offset != -1L);
        if (offset < 0L) {
            this.archive.seek(offset &= Long.MAX_VALUE);
            byte[] lfh = new byte[30];
            this.archive.readFully(lfh);
            long lfhSig = BasicZipFile.readUInt(lfh, 0);
            if (lfhSig != 67324752L) {
                throw new ZipException(name + ": expected Local File Header signature");
            }
            offset += (long)(30 + BasicZipFile.readUShort(lfh, 26) + BasicZipFile.readUShort(lfh, 28));
            if (check) {
                long localCrc;
                if (entry.getGeneralBit(3)) {
                    byte[] dd = new byte[8];
                    this.archive.seek(offset + entry.getCompressedSize());
                    this.archive.readFully(dd);
                    long ddSig = BasicZipFile.readUInt(dd, 0);
                    localCrc = ddSig == 134695760L ? BasicZipFile.readUInt(dd, 4) : ddSig;
                } else {
                    localCrc = BasicZipFile.readUInt(lfh, 14);
                }
                if (entry.getCrc() != localCrc) {
                    throw new CRC32Exception(name, entry.getCrc(), localCrc);
                }
            }
            entry.offset = offset;
        }
        IntervalInputStream iis = new IntervalInputStream(offset, entry.getCompressedSize());
        int bufSize = BasicZipFile.getBufferSize(entry);
        InputStream in = iis;
        switch (entry.getMethod()) {
            case 8: {
                if (inflate) {
                    iis.addDummy();
                    in = new PooledInflaterInputStream(in, bufSize);
                    if (!check) break;
                    in = new CheckedInputStream(in, entry, bufSize);
                    break;
                }
                if (!check) break;
                in = new RawCheckedInputStream(in, entry, bufSize);
                break;
            }
            case 0: {
                if (!check) break;
                in = new CheckedInputStream(in, entry, bufSize);
                break;
            }
            default: {
                assert (false) : "this should already have been checked by mountCentralDirectory()";
                break;
            }
        }
        return in;
    }

    private static final int getBufferSize(ZipEntry entry) {
        long size = entry.getSize();
        if (size > 65536L) {
            size = 65536L;
        } else if (size < 8192L) {
            size = 8192L;
        }
        return (int)size;
    }

    private final void ensureOpen() throws ZipException {
        if (this.archive == null) {
            throw new ZipException("ZIP file has been closed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Inflater allocateInflater() {
        Inflater inflater = null;
        List list = releasedInflaters;
        synchronized (list) {
            Iterator i = releasedInflaters.iterator();
            while (i.hasNext()) {
                inflater = (Inflater)((Reference)i.next()).get();
                i.remove();
                if (inflater == null) continue;
            }
            if (inflater == null) {
                inflater = new Inflater(true);
            }
            allocatedInflaters.add(inflater);
        }
        return inflater;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void releaseInflater(Inflater inflater) {
        inflater.reset();
        List list = releasedInflaters;
        synchronized (list) {
            releasedInflaters.add(new SoftReference<Inflater>(inflater));
            allocatedInflaters.remove(inflater);
        }
    }

    private static long skipWithBuffer(InputStream in, long toSkip, byte[] buf) throws IOException {
        long len;
        long total = 0L;
        while ((len = toSkip - total) > 0L && (len = (long)in.read(buf, 0, len < (long)buf.length ? (int)len : buf.length)) >= 0L) {
            total += len;
        }
        return total;
    }

    public void close() throws IOException {
        if (this.archive != null) {
            ReadOnlyFile oldArchive = this.archive;
            this.archive = null;
            oldArchive.close();
        }
    }

    private static final int readUShort(byte[] b, int off) {
        return (b[off + 1] & 0xFF) << 8 | b[off] & 0xFF;
    }

    private static final long readUInt(byte[] b, int off) {
        off += 3;
        long v = (long)b[off--] & 0xFFL;
        v <<= 8;
        v |= (long)b[off--] & 0xFFL;
        v <<= 8;
        v |= (long)b[off--] & 0xFFL;
        v <<= 8;
        return v |= (long)b[off] & 0xFFL;
    }

    private static class IrregularOffsetMapper
    extends OffsetMapper {
        final long start;

        IrregularOffsetMapper(long start) {
            this.start = start;
        }

        long location(long offset) {
            return this.start + offset;
        }
    }

    private static class OffsetMapper {
        private OffsetMapper() {
        }

        long location(long offset) {
            return offset;
        }
    }

    private abstract class AccountedInputStream
    extends InputStream {
        private boolean closed;

        public AccountedInputStream() {
            BasicZipFile.this.openStreams++;
        }

        public void close() throws IOException {
            if (!this.closed) {
                this.closed = true;
                BasicZipFile.this.openStreams--;
                super.close();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void finalize() throws Throwable {
            try {
                this.close();
            }
            finally {
                super.finalize();
            }
        }
    }

    private class IntervalInputStream
    extends AccountedInputStream {
        private long remaining;
        private long fp;
        private boolean addDummyByte;

        IntervalInputStream(long start, long remaining) {
            assert (start >= 0L);
            assert (remaining >= 0L);
            this.remaining = remaining;
            this.fp = start;
        }

        public int read() throws IOException {
            BasicZipFile.this.ensureOpen();
            if (this.remaining <= 0L) {
                if (this.addDummyByte) {
                    this.addDummyByte = false;
                    return 0;
                }
                return -1;
            }
            BasicZipFile.this.archive.seek(this.fp);
            int ret = BasicZipFile.this.archive.read();
            if (ret >= 0) {
                ++this.fp;
                --this.remaining;
            }
            return ret;
        }

        public int read(byte[] b, int off, int len) throws IOException {
            if (len <= 0) {
                if (len < 0) {
                    throw new IndexOutOfBoundsException();
                }
                return 0;
            }
            BasicZipFile.this.ensureOpen();
            if (this.remaining <= 0L) {
                if (this.addDummyByte) {
                    this.addDummyByte = false;
                    b[off] = 0;
                    return 1;
                }
                return -1;
            }
            if ((long)len > this.remaining) {
                len = (int)this.remaining;
            }
            BasicZipFile.this.archive.seek(this.fp);
            int ret = BasicZipFile.this.archive.read(b, off, len);
            if (ret > 0) {
                this.fp += (long)ret;
                this.remaining -= (long)ret;
            }
            return ret;
        }

        void addDummy() {
            this.addDummyByte = true;
        }

        public int available() throws IOException {
            BasicZipFile.this.ensureOpen();
            long available = this.remaining;
            if (this.addDummyByte) {
                ++available;
            }
            return available > Integer.MAX_VALUE ? Integer.MAX_VALUE : (int)available;
        }
    }

    private static final class RawCheckedInputStream
    extends FilterInputStream {
        private final Checksum crc = new CRC32();
        private final byte[] singleByteBuf = new byte[1];
        private final Inflater inf = BasicZipFile.access$100();
        private final byte[] infBuf;
        private final ZipEntry entry;
        private boolean closed;

        public RawCheckedInputStream(InputStream in, ZipEntry entry, int size) {
            super(in);
            this.infBuf = new byte[size];
            this.entry = entry;
        }

        private void ensureOpen() throws IOException {
            if (this.closed) {
                throw new IOException("input stream has been closed");
            }
        }

        public int read() throws IOException {
            int read;
            while ((read = this.read(this.singleByteBuf, 0, 1)) == 0) {
            }
            return read > 0 ? this.singleByteBuf[0] & 0xFF : -1;
        }

        public int read(byte[] buf, int off, int len) throws IOException {
            if (len == 0) {
                return 0;
            }
            this.ensureOpen();
            if (buf == null) {
                throw new NullPointerException();
            }
            int offPlusLen = off + len;
            if ((off | len | offPlusLen | buf.length - offPlusLen) < 0) {
                throw new IndexOutOfBoundsException();
            }
            int read = this.in.read(buf, off, len);
            if (read >= 0) {
                this.inf.setInput(buf, off, read);
            } else {
                buf[off] = 0;
                this.inf.setInput(buf, off, 1);
            }
            try {
                int inflated;
                while ((inflated = this.inf.inflate(this.infBuf, 0, this.infBuf.length)) > 0) {
                    this.crc.update(this.infBuf, 0, inflated);
                }
            }
            catch (DataFormatException dfe) {
                IOException ioe = new IOException(dfe.toString());
                ioe.initCause(dfe);
                throw ioe;
            }
            assert (read >= 0 || this.inf.finished());
            assert (read < 0 || this.inf.needsInput());
            assert (!this.inf.needsDictionary());
            return read;
        }

        public long skip(long toSkip) throws IOException {
            return BasicZipFile.skipWithBuffer(this, toSkip, new byte[this.infBuf.length]);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void close() throws IOException {
            long actualCrc;
            if (this.closed) {
                return;
            }
            try {
                while (this.skip(Long.MAX_VALUE) > 0L) {
                }
            }
            finally {
                this.closed = true;
                BasicZipFile.releaseInflater(this.inf);
                super.close();
            }
            long expectedCrc = this.entry.getCrc();
            if (expectedCrc != (actualCrc = this.crc.getValue())) {
                throw new CRC32Exception(this.entry.getName(), expectedCrc, actualCrc);
            }
        }

        public void mark(int readlimit) {
        }

        public void reset() throws IOException {
            throw new IOException("mark()/reset() not supported");
        }

        public boolean markSupported() {
            return false;
        }
    }

    private static final class CheckedInputStream
    extends java.util.zip.CheckedInputStream {
        private final ZipEntry entry;
        private final int size;

        public CheckedInputStream(InputStream in, ZipEntry entry, int size) {
            super(in, new CRC32());
            this.entry = entry;
            this.size = size;
        }

        public long skip(long toSkip) throws IOException {
            return BasicZipFile.skipWithBuffer(this, toSkip, new byte[this.size]);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void close() throws IOException {
            long actualCrc;
            try {
                while (this.skip(Long.MAX_VALUE) > 0L) {
                }
            }
            finally {
                super.close();
            }
            long expectedCrc = this.entry.getCrc();
            if (expectedCrc != (actualCrc = this.getChecksum().getValue())) {
                throw new CRC32Exception(this.entry.getName(), expectedCrc, actualCrc);
            }
        }
    }

    private static final class PooledInflaterInputStream
    extends InflaterInputStream {
        private boolean closed;

        public PooledInflaterInputStream(InputStream in, int size) {
            super(in, BasicZipFile.allocateInflater(), size);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void close() throws IOException {
            if (this.closed) {
                return;
            }
            this.closed = true;
            try {
                super.close();
            }
            finally {
                BasicZipFile.releaseInflater(this.inf);
            }
        }
    }
}

