/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.agent.repkg.de.schlichtherle.io;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.terracotta.agent.repkg.de.schlichtherle.io.ArchiveController;
import org.terracotta.agent.repkg.de.schlichtherle.io.ArchiveException;
import org.terracotta.agent.repkg.de.schlichtherle.io.ArchiveFileSystem;
import org.terracotta.agent.repkg.de.schlichtherle.io.ArchiveFileSystemController;
import org.terracotta.agent.repkg.de.schlichtherle.io.ArchiveInputBusyException;
import org.terracotta.agent.repkg.de.schlichtherle.io.ArchiveInputBusyWarningException;
import org.terracotta.agent.repkg.de.schlichtherle.io.ArchiveOutputBusyException;
import org.terracotta.agent.repkg.de.schlichtherle.io.ArchiveOutputBusyWarningException;
import org.terracotta.agent.repkg.de.schlichtherle.io.ArchiveWarningException;
import org.terracotta.agent.repkg.de.schlichtherle.io.CountingOutputStream;
import org.terracotta.agent.repkg.de.schlichtherle.io.CountingReadOnlyFile;
import org.terracotta.agent.repkg.de.schlichtherle.io.File;
import org.terracotta.agent.repkg.de.schlichtherle.io.Files;
import org.terracotta.agent.repkg.de.schlichtherle.io.IORunnable;
import org.terracotta.agent.repkg.de.schlichtherle.io.InputArchiveMetaData;
import org.terracotta.agent.repkg.de.schlichtherle.io.InputIOException;
import org.terracotta.agent.repkg.de.schlichtherle.io.OutputArchiveMetaData;
import org.terracotta.agent.repkg.de.schlichtherle.io.ReentrantLock;
import org.terracotta.agent.repkg.de.schlichtherle.io.Streams;
import org.terracotta.agent.repkg.de.schlichtherle.io.archive.spi.ArchiveDriver;
import org.terracotta.agent.repkg.de.schlichtherle.io.archive.spi.ArchiveEntry;
import org.terracotta.agent.repkg.de.schlichtherle.io.archive.spi.InputArchive;
import org.terracotta.agent.repkg.de.schlichtherle.io.archive.spi.OutputArchive;
import org.terracotta.agent.repkg.de.schlichtherle.io.archive.spi.TransientIOException;
import org.terracotta.agent.repkg.de.schlichtherle.io.rof.ReadOnlyFile;
import org.terracotta.agent.repkg.de.schlichtherle.io.rof.SimpleReadOnlyFile;
import org.terracotta.agent.repkg.de.schlichtherle.io.util.Temps;

final class UpdatingArchiveController
extends ArchiveFileSystemController {
    private static final String CLASS_NAME = "de/schlichtherle/io/UpdatingArchiveController".replace('/', '.');
    private static final Logger logger = Logger.getLogger(CLASS_NAME, CLASS_NAME);
    static final String TEMP_FILE_PREFIX = "tzp-ctrl";
    static final String TEMP_FILE_SUFFIX = ".tmp";
    private java.io.File inFile;
    private InputArchive inArchive;
    private java.io.File outFile;
    private OutputArchive outArchive;
    private boolean needsReassembly;

    UpdatingArchiveController(java.io.File target, ArchiveController enclController, String enclEntryName, ArchiveDriver driver) {
        super(target, enclController, enclEntryName, driver);
    }

    void mount(boolean autoCreate) throws IOException {
        assert (this.writeLock().isLocked());
        assert (this.inArchive == null);
        assert (this.outFile == null);
        assert (this.outArchive == null);
        assert (this.getFileSystem() == null);
        logger.log(Level.FINER, "mount.entering", new Object[]{this.getPath(), autoCreate});
        try {
            this.mount0(autoCreate);
        }
        catch (IOException ex) {
            assert (this.writeLock().isLocked());
            assert (this.inArchive == null);
            assert (this.outFile == null);
            assert (this.outArchive == null);
            assert (this.getFileSystem() == null);
            logger.log(Level.FINER, "mount.throwing", ex);
            throw ex;
        }
        logger.log(Level.FINER, "mount.exiting");
        assert (this.writeLock().isLocked());
        assert (autoCreate || this.inArchive != null);
        assert (autoCreate || this.outFile == null);
        assert (autoCreate || this.outArchive == null);
        assert (this.getFileSystem() != null);
    }

    private void mount0(boolean autoCreate) throws IOException {
        if (this.isRfsEntryTarget()) {
            long time;
            if (this.inFile == null) {
                this.inFile = this.getTarget();
            }
            if ((time = this.inFile.lastModified()) != 0L) {
                boolean isReadOnly = !Files.isWritableOrCreatable(this.inFile);
                try {
                    this.initInArchive(this.inFile);
                }
                catch (IOException ex) {
                    throw new ArchiveController.RfsEntryFalsePositiveException(ex);
                }
                this.setFileSystem(new ArchiveFileSystem(this, this.inArchive, time, isReadOnly));
            } else {
                if (!autoCreate) {
                    throw new ArchiveController.ArchiveFileNotFoundException("may not create");
                }
                this.ensureOutArchive();
                this.setFileSystem(new ArchiveFileSystem(this));
            }
        } else if (this.inFile == null) {
            this.unwrap(this.getEnclController(), this.getEnclEntryName(), autoCreate);
        } else {
            try {
                this.initInArchive(this.inFile);
            }
            catch (IOException ex) {
                assert (false) : "We should never get here! Read the source code comments for full details.";
                throw new ArchiveController.FileArchiveEntryFalsePositiveException(this.getEnclController(), this.getEnclEntryName(), ex);
            }
            this.setFileSystem(new ArchiveFileSystem(this, this.inArchive, this.inFile.lastModified(), false));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void unwrap(final ArchiveController controller, final String entryName, boolean autoCreate) throws IOException {
        assert (controller != null);
        assert (entryName != null);
        assert (!"".equals(entryName));
        assert (this.inFile == null);
        try {
            final ReentrantLock lock = autoCreate ? controller.writeLock() : controller.readLock();
            controller.readLock().lock();
            if (controller.hasNewData(entryName) || autoCreate) {
                controller.readLock().unlock();
                /*
                 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
                 */
                class Locker
                implements IORunnable {
                    Locker() {
                    }

                    @Override
                    public void run() throws IOException {
                        controller.autoUmount(entryName);
                        lock.lock();
                    }
                }
                controller.runWriteLocked(new Locker());
            }
            try {
                this.unwrapFromLockedController(controller, entryName, autoCreate);
            }
            finally {
                lock.unlock();
            }
        }
        catch (ArchiveController.DirectoryArchiveEntryFalsePositiveException ex) {
            if (ex.getEnclController() == controller) {
                throw ex;
            }
            this.unwrap(controller.getEnclController(), controller.enclEntryName(entryName), autoCreate);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void unwrapFromLockedController(ArchiveController controller, String entryName, boolean autoCreate) throws IOException {
        ArchiveFileSystem controllerFileSystem;
        assert (controller != null);
        assert (controller.readLock().isLocked() || controller.writeLock().isLocked());
        assert (entryName != null);
        assert (!"".equals(entryName));
        assert (this.inFile == null);
        try {
            controllerFileSystem = controller.autoMount(autoCreate && File.isLenient());
        }
        catch (ArchiveController.RfsEntryFalsePositiveException ex) {
            assert (false) : "FIXME: Explain or remove this!";
            throw (IOException)ex.getCause();
        }
        if (controllerFileSystem.isFile(entryName)) {
            java.io.File tmp = Temps.createTempFile(TEMP_FILE_PREFIX, TEMP_FILE_SUFFIX);
            try {
                File.cp(controller.createInputStream0(entryName), new FileOutputStream(tmp));
                try {
                    this.initInArchive(tmp);
                }
                catch (IOException ex) {
                    throw new ArchiveController.FileArchiveEntryFalsePositiveException(controller, entryName, ex);
                }
                this.setFileSystem(new ArchiveFileSystem(this, this.inArchive, controllerFileSystem.lastModified(entryName), controllerFileSystem.isReadOnly()));
                this.inFile = tmp;
            }
            catch (Throwable ex) {
                if (!tmp.delete()) {
                    IOException ioe = new IOException(tmp.getPath() + " (couldn't delete corrupted input file)");
                    ioe.initCause(ex);
                    throw ioe;
                }
                if (ex instanceof IOException) {
                    throw (IOException)ex;
                }
                if (ex instanceof RuntimeException) {
                    throw (RuntimeException)ex;
                }
                throw (Error)ex;
            }
        }
        if (controllerFileSystem.isDirectory(entryName)) {
            throw new ArchiveController.DirectoryArchiveEntryFalsePositiveException(controller, entryName, new FileNotFoundException("cannot read directories"));
        }
        if (!autoCreate) {
            throw new ArchiveController.ArchiveFileNotFoundException("may not create");
        }
        assert (autoCreate);
        assert (controller.writeLock().isLocked());
        ArchiveFileSystem.Delta delta = controllerFileSystem.link(entryName, File.isLenient());
        this.ensureOutArchive();
        try {
            delta.commit();
        }
        catch (IOException ex) {
            try {
                try {
                    this.outArchive.close();
                }
                finally {
                    this.outArchive = null;
                }
            }
            finally {
                boolean deleted = this.outFile.delete();
                assert (deleted);
                this.outFile = null;
            }
            throw ex;
        }
        this.setFileSystem(new ArchiveFileSystem(this));
    }

    private void initInArchive(java.io.File inFile) throws IOException {
        assert (this.writeLock().isLocked());
        assert (this.inArchive == null);
        logger.log(Level.FINEST, "initInArchive.entering", inFile);
        try {
            ReadOnlyFile rof = new SimpleReadOnlyFile(inFile);
            if (this.isRfsEntryTarget()) {
                rof = new CountingReadOnlyFile(rof);
            }
            try {
                this.inArchive = this.getDriver().createInputArchive(this, rof);
            }
            catch (Throwable ex) {
                rof.close();
                if (ex instanceof IOException) {
                    throw (IOException)ex;
                }
                if (ex instanceof RuntimeException) {
                    throw (RuntimeException)ex;
                }
                if (ex instanceof Error) {
                    throw (Error)ex;
                }
                throw new AssertionError((Object)ex);
            }
            this.inArchive.setMetaData(new InputArchiveMetaData(this, this.inArchive));
        }
        catch (IOException ex) {
            assert (this.inArchive == null);
            logger.log(Level.FINEST, "initInArchive.throwing", ex);
            throw ex;
        }
        logger.log(Level.FINEST, "initInArchive.exiting", new Integer(this.inArchive.getNumArchiveEntries()));
        assert (this.inArchive != null);
    }

    InputStream createInputStream(ArchiveEntry entry, ArchiveEntry dstEntry) throws IOException {
        assert (entry != null);
        assert (this.readLock().isLocked() || this.writeLock().isLocked());
        assert (!this.hasNewData(entry.getName()));
        assert (!entry.isDirectory());
        InputStream in = this.inArchive.getMetaData().createInputStream(entry, dstEntry);
        if (in == null) {
            throw new ArchiveController.ArchiveEntryNotFoundException(entry.getName(), "bad archive driver: returned illegal null value");
        }
        return in;
    }

    OutputStream createOutputStream(ArchiveEntry entry, ArchiveEntry srcEntry) throws IOException {
        assert (entry != null);
        assert (this.writeLock().isLocked());
        assert (!this.hasNewData(entry.getName()));
        assert (!entry.isDirectory());
        this.ensureOutArchive();
        OutputStream out = this.outArchive.getMetaData().createOutputStream(entry, srcEntry);
        if (out == null) {
            throw new ArchiveController.ArchiveEntryNotFoundException(entry.getName(), "bad archive driver: returned illegal null value");
        }
        return out;
    }

    void touch() throws IOException {
        assert (this.writeLock().isLocked());
        this.ensureOutArchive();
        super.touch();
    }

    private void ensureOutArchive() throws IOException {
        assert (this.writeLock().isLocked());
        if (this.outArchive != null) {
            return;
        }
        java.io.File tmp = this.outFile;
        if (tmp == null) {
            tmp = this.isRfsEntryTarget() && !this.getTarget().isFile() ? this.getTarget() : Temps.createTempFile(TEMP_FILE_PREFIX, TEMP_FILE_SUFFIX);
        }
        try {
            this.initOutArchive(tmp);
        }
        catch (TransientIOException ex) {
            throw ex.getTransientCause();
        }
        this.outFile = tmp;
    }

    private void initOutArchive(java.io.File outFile) throws IOException {
        assert (this.writeLock().isLocked());
        assert (this.outArchive == null);
        logger.log(Level.FINEST, "initOutArchive.entering", outFile);
        try {
            OutputStream out = new FileOutputStream(outFile);
            if (outFile == this.getTarget()) {
                out = new CountingOutputStream(out);
            }
            try {
                this.outArchive = this.getDriver().createOutputArchive(this, out, this.inArchive);
            }
            catch (Throwable ex) {
                ((OutputStream)out).close();
                if (!outFile.delete()) {
                    IOException ioe = new IOException(outFile.getPath() + " (couldn't delete corrupted output file)");
                    ioe.initCause(ex);
                    throw ioe;
                }
                if (ex instanceof IOException) {
                    throw (IOException)ex;
                }
                if (ex instanceof RuntimeException) {
                    throw (RuntimeException)ex;
                }
                if (ex instanceof Error) {
                    throw (Error)ex;
                }
                throw new AssertionError((Object)ex);
            }
            this.outArchive.setMetaData(new OutputArchiveMetaData(this, this.outArchive));
        }
        catch (IOException ex) {
            assert (this.outArchive == null);
            logger.log(Level.FINEST, "initOutArchive.throwing", ex);
            throw ex;
        }
        logger.log(Level.FINEST, "initOutArchive.exiting");
        assert (this.outArchive != null);
    }

    boolean hasNewData(String entryName) {
        assert (this.readLock().isLocked() || this.writeLock().isLocked());
        return this.outArchive != null && this.outArchive.getArchiveEntry(entryName) != null;
    }

    void umount(ArchiveException exceptionChain, boolean waitInputStreams, boolean closeInputStreams, boolean waitOutputStreams, boolean closeOutputStreams, boolean umount, boolean reassemble) throws ArchiveException {
        assert (closeInputStreams || !closeOutputStreams);
        assert (!umount || reassemble);
        assert (this.writeLock().isLocked());
        assert (this.inArchive == null || this.inFile != null);
        assert (!this.isTouched() || this.outArchive != null);
        assert (this.outArchive == null || this.outFile != null);
        logger.log(Level.FINER, "umount.entering", new Object[]{this.getPath(), exceptionChain, waitInputStreams, closeInputStreams, waitOutputStreams, closeOutputStreams, umount, reassemble});
        try {
            this.umount0(exceptionChain, waitInputStreams, closeInputStreams, waitOutputStreams, closeOutputStreams, umount, reassemble);
        }
        catch (ArchiveException ex) {
            logger.log(Level.FINER, "umount.throwing", ex);
            throw ex;
        }
        logger.log(Level.FINER, "umount.exiting");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void umount0(ArchiveException exceptionChain, boolean waitInputStreams, boolean closeInputStreams, boolean waitOutputStreams, boolean closeOutputStreams, boolean umount, boolean reassemble) throws ArchiveException {
        ArchiveException newExceptionChain;
        block32: {
            InputArchiveMetaData inMetaData;
            int inStreams;
            OutputArchiveMetaData outMetaData;
            int outStreams;
            newExceptionChain = exceptionChain;
            if (this.outArchive != null && (outStreams = (outMetaData = this.outArchive.getMetaData()).waitAllOutputStreamsByOtherThreads(waitOutputStreams ? 0L : 50L)) > 0) {
                if (!closeOutputStreams) {
                    throw new ArchiveOutputBusyException(newExceptionChain, this.getPath(), outStreams);
                }
                newExceptionChain = new ArchiveOutputBusyWarningException(newExceptionChain, this.getPath(), outStreams);
            }
            if (this.inArchive != null && (inStreams = (inMetaData = this.inArchive.getMetaData()).waitAllInputStreamsByOtherThreads(waitInputStreams ? 0L : 50L)) > 0) {
                if (!closeInputStreams) {
                    throw new ArchiveInputBusyException(newExceptionChain, this.getPath(), inStreams);
                }
                newExceptionChain = new ArchiveInputBusyWarningException(newExceptionChain, this.getPath(), inStreams);
            }
            try {
                if (this.isTouched()) {
                    this.needsReassembly = true;
                    try {
                        newExceptionChain = this.update(newExceptionChain);
                        assert (this.getFileSystem() == null);
                        assert (this.inArchive == null);
                    }
                    finally {
                        assert (this.outArchive == null);
                    }
                    try {
                        if (reassemble) {
                            newExceptionChain = this.reassemble(newExceptionChain);
                            this.needsReassembly = false;
                        }
                        this.shutdownStep3(umount && !this.needsReassembly);
                        break block32;
                    }
                    catch (Throwable throwable) {
                        this.shutdownStep3(umount && !this.needsReassembly);
                        throw throwable;
                    }
                }
                if (reassemble && this.needsReassembly) {
                    assert (this.outFile == null);
                    assert (this.inFile != null);
                    this.shutdownStep2(newExceptionChain);
                    this.outFile = this.inFile;
                    this.inFile = null;
                    try {
                        newExceptionChain = this.reassemble(newExceptionChain);
                        this.needsReassembly = false;
                        this.shutdownStep3(umount && !this.needsReassembly);
                        break block32;
                    }
                    catch (Throwable throwable) {
                        this.shutdownStep3(umount && !this.needsReassembly);
                        throw throwable;
                    }
                }
                if (umount) {
                    assert (reassemble);
                    assert (!this.needsReassembly);
                    this.shutdownStep2(newExceptionChain);
                    this.shutdownStep3(true);
                } else assert (this.outArchive == null);
            }
            catch (ArchiveException ex) {
                throw ex;
            }
            catch (IOException ex) {
                throw new ArchiveException(newExceptionChain, ex);
            }
            finally {
                this.setScheduled(this.needsReassembly);
            }
        }
        if (newExceptionChain != exceptionChain) {
            throw newExceptionChain;
        }
    }

    final int waitAllInputStreamsByOtherThreads(long timeout) {
        return this.inArchive != null ? this.inArchive.getMetaData().waitAllInputStreamsByOtherThreads(timeout) : 0;
    }

    final int waitAllOutputStreamsByOtherThreads(long timeout) {
        return this.outArchive != null ? this.outArchive.getMetaData().waitAllOutputStreamsByOtherThreads(timeout) : 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ArchiveException update(ArchiveException exceptionChain) throws ArchiveException {
        assert (this.writeLock().isLocked());
        assert (this.isTouched());
        assert (this.outArchive != null);
        assert (this.checkNoDeletedEntriesWithNewData(exceptionChain) == exceptionChain);
        ArchiveFileSystem fileSystem = this.getFileSystem();
        ArchiveEntry root = fileSystem.getRoot();
        try {
            try {
                try {
                    exceptionChain = this.shutdownStep1(exceptionChain);
                    ArchiveWarningException inputEntryCorrupted = null;
                    ArchiveWarningException outputEntryCorrupted = null;
                    Enumeration e = fileSystem.getArchiveEntries();
                    while (e.hasMoreElements()) {
                        ArchiveEntry entry = (ArchiveEntry)e.nextElement();
                        String entryName = entry.getName();
                        if (this.hasNewData(entryName)) continue;
                        if (entry.isDirectory()) {
                            if (root == entry || entry.getTime() < 0L) continue;
                            this.outArchive.getOutputStream(entry, null).close();
                            continue;
                        }
                        if (this.inArchive != null && this.inArchive.getArchiveEntry(entryName) != null) {
                            InputStream in;
                            assert (entry == this.inArchive.getArchiveEntry(entryName));
                            try {
                                in = this.inArchive.getInputStream(entry, entry);
                                assert (in != null);
                            }
                            catch (IOException ex) {
                                if (inputEntryCorrupted != null) continue;
                                inputEntryCorrupted = new ArchiveWarningException(exceptionChain, this.getPath() + " (skipped one or more corrupted archive entries in the input)", ex);
                                exceptionChain = inputEntryCorrupted;
                                continue;
                            }
                            try {
                                OutputStream out = this.outArchive.getOutputStream(entry, entry);
                                try {
                                    Streams.cat(in, out);
                                    continue;
                                }
                                catch (InputIOException ex) {
                                    if (outputEntryCorrupted != null) continue;
                                    outputEntryCorrupted = new ArchiveWarningException(exceptionChain, this.getPath() + " (one or more archive entries in the output are corrupted)", (IOException)ex);
                                    exceptionChain = outputEntryCorrupted;
                                    continue;
                                }
                                finally {
                                    out.close();
                                    continue;
                                }
                            }
                            finally {
                                try {
                                    in.close();
                                    continue;
                                }
                                catch (IOException ex) {
                                    if (inputEntryCorrupted == null) {
                                        inputEntryCorrupted = new ArchiveWarningException(exceptionChain, this.getPath() + " (one or more archive entries in the input are corrupted)", ex);
                                        exceptionChain = inputEntryCorrupted;
                                    }
                                    throw ex;
                                }
                            }
                        }
                        this.outArchive.getOutputStream(entry, null).close();
                    }
                }
                finally {
                    this.shutdownStep2(exceptionChain);
                }
            }
            catch (IOException ex) {
                boolean deleted = this.outFile.delete();
                this.outFile = null;
                assert (deleted);
                throw ex;
            }
        }
        catch (ArchiveException ex) {
            throw ex;
        }
        catch (IOException ex) {
            throw new ArchiveException(exceptionChain, this.getPath() + " (could not update archive file - all changes are lost)", ex);
        }
        if (!this.outFile.setLastModified(root.getTime())) {
            exceptionChain = new ArchiveWarningException(exceptionChain, this.getPath() + " (couldn't preserve last modification time)");
        }
        return exceptionChain;
    }

    private ArchiveException checkNoDeletedEntriesWithNewData(ArchiveException exceptionChain) {
        assert (this.isTouched());
        assert (this.getFileSystem() != null);
        ArchiveFileSystem fileSystem = this.getFileSystem();
        Enumeration e = this.outArchive.getArchiveEntries();
        while (e.hasMoreElements()) {
            ArchiveEntry entry = (ArchiveEntry)e.nextElement();
            String entryName = entry.getName();
            if (fileSystem.get(entryName) != null) continue;
            exceptionChain = new ArchiveWarningException(exceptionChain, this.getPath() + " (couldn't remove archive entry: " + entryName + ")");
        }
        return exceptionChain;
    }

    private ArchiveException reassemble(ArchiveException exceptionChain) throws ArchiveException {
        assert (this.writeLock().isLocked());
        if (this.isRfsEntryTarget()) {
            if (this.outFile != this.getTarget()) {
                try {
                    FileInputStream in;
                    CountingOutputStream out = new CountingOutputStream(new FileOutputStream(this.getTarget()));
                    try {
                        in = new FileInputStream(this.outFile);
                    }
                    catch (IOException ex) {
                        ((OutputStream)out).close();
                        throw ex;
                    }
                    File.cp(in, out);
                }
                catch (IOException cause) {
                    throw new ArchiveException(exceptionChain, this.getPath() + " (could not reassemble archive file - all changes are lost)", cause);
                }
                long time = this.outFile.lastModified();
                if (time != 0L && !this.getTarget().setLastModified(time)) {
                    exceptionChain = new ArchiveWarningException(exceptionChain, this.getPath() + " (couldn't preserve last modification time)");
                }
            }
        } else {
            try {
                this.wrap(this.getEnclController(), this.getEnclEntryName());
            }
            catch (IOException cause) {
                throw new ArchiveException(exceptionChain, this.getEnclController().getPath() + "/" + this.getEnclEntryName() + " (could not update archive entry - all changes are lost)", cause);
            }
        }
        return exceptionChain;
    }

    private void wrap(final ArchiveController controller, final String entryName) throws IOException {
        assert (this.writeLock().isLocked());
        assert (controller != null);
        assert (entryName != null);
        assert (!"".equals(entryName));
        controller.runWriteLocked(new IORunnable(){

            public void run() throws IOException {
                UpdatingArchiveController.this.wrapToWriteLockedController(controller, entryName);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void wrapToWriteLockedController(ArchiveController controller, String entryName) throws IOException {
        assert (controller != null);
        assert (controller.writeLock().isLocked());
        assert (entryName != null);
        assert (!"".equals(entryName));
        FileInputStream in = new FileInputStream(this.outFile);
        try {
            Files.cp0(true, this.outFile, in, controller, entryName);
        }
        finally {
            ((InputStream)in).close();
        }
    }

    void reset() throws IOException {
        assert (this.writeLock().isLocked());
        ArchiveException exceptionChain = this.shutdownStep1(null);
        this.shutdownStep2(exceptionChain);
        this.shutdownStep3(true);
        this.setScheduled(false);
        if (exceptionChain != null) {
            throw exceptionChain;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void finalize() throws Throwable {
        try {
            logger.log(Level.FINEST, "finalize.entering", this.getPath());
            if (this.isTouched() || this.readLock().isLocked() || this.writeLock().isLocked()) {
                logger.log(Level.SEVERE, "finalize.invalidState", this.getPath());
            }
            this.shutdownStep1(null);
            this.shutdownStep2(null);
            this.shutdownStep3(true);
        }
        finally {
            super.finalize();
        }
    }

    private ArchiveException shutdownStep1(ArchiveException exceptionChain) {
        if (this.outArchive != null) {
            exceptionChain = this.outArchive.getMetaData().closeAllOutputStreams(exceptionChain);
        }
        if (this.inArchive != null) {
            exceptionChain = this.inArchive.getMetaData().closeAllInputStreams(exceptionChain);
        }
        return exceptionChain;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void shutdownStep2(ArchiveException exceptionChain) throws IOException {
        ArchiveException oldExceptionChain = exceptionChain;
        super.reset();
        if (this.outArchive != null) {
            try {
                this.outArchive.close();
            }
            catch (IOException ex) {
                exceptionChain = new ArchiveException(exceptionChain, ex);
            }
            finally {
                this.outArchive = null;
            }
        }
        if (this.inArchive != null) {
            try {
                this.inArchive.close();
            }
            catch (IOException ex) {
                exceptionChain = new ArchiveException(exceptionChain, ex);
            }
            finally {
                this.inArchive = null;
            }
        }
        if (exceptionChain != oldExceptionChain) {
            throw exceptionChain;
        }
    }

    private void shutdownStep3(boolean deleteOutFile) {
        boolean deleted;
        if (this.inFile != null) {
            if (this.inFile != this.getTarget()) {
                deleted = this.inFile.delete();
                assert (deleted);
            }
            this.inFile = null;
        }
        if (this.outFile != null) {
            if (deleteOutFile) {
                if (this.outFile != this.getTarget()) {
                    deleted = this.outFile.delete();
                    assert (deleted);
                }
            } else {
                assert (this.outFile.isFile());
                this.inFile = this.outFile;
            }
            this.outFile = null;
        }
        if (deleteOutFile) {
            this.needsReassembly = false;
        }
    }
}

