/*
 * Decompiled with CFR 0.152.
 */
package net.sf.ehcache.terracotta;

import net.sf.ehcache.CacheException;
import net.sf.ehcache.Ehcache;
import net.sf.ehcache.cluster.CacheCluster;
import net.sf.ehcache.config.TerracottaClientConfiguration;
import net.sf.ehcache.event.CacheEventListener;
import net.sf.ehcache.store.Store;
import net.sf.ehcache.terracotta.ClusteredInstanceFactory;
import net.sf.ehcache.transaction.SoftLockManager;
import net.sf.ehcache.transaction.TransactionIDFactory;
import net.sf.ehcache.util.ProductInfo;
import net.sf.ehcache.writer.writebehind.WriteBehind;
import org.terracotta.express.Client;
import org.terracotta.express.ClientFactory;
import org.terracotta.express.ClientFactoryExtras;

public class ExpressEnterpriseTerracottaClusteredInstanceFactory
implements ClusteredInstanceFactory {
    private final Client client;
    private final ClusteredInstanceFactory realFactory;

    public ExpressEnterpriseTerracottaClusteredInstanceFactory(TerracottaClientConfiguration terracottaConfig) {
        this.assertCoreVersionMatches();
        boolean isURLConfig = terracottaConfig.isUrlConfig();
        String tcConfig = null;
        tcConfig = isURLConfig ? terracottaConfig.getUrl() : terracottaConfig.getEmbeddedConfig();
        this.client = terracottaConfig.isRejoin() ? ClientFactoryExtras.createDedicatedRejoinClient((String)tcConfig, (boolean)isURLConfig, (Class[])new Class[]{this.getClass()}) : ClientFactory.getOrCreateClient((String)tcConfig, (boolean)isURLConfig, (Class[])new Class[]{this.getClass()});
        try {
            this.realFactory = (ClusteredInstanceFactory)this.client.instantiate("org.terracotta.modules.ehcache.store.EnterpriseTerracottaClusteredInstanceFactory", new Class[]{TerracottaClientConfiguration.class}, new Object[]{terracottaConfig});
        }
        catch (Exception e) {
            throw new CacheException("Unable to create Terracotta client", (Throwable)e);
        }
    }

    private void assertCoreVersionMatches() {
        boolean ignoreVersionCheck = Boolean.getBoolean("terracotta.ehcache.versioncheck.skip");
        if (!ignoreVersionCheck) {
            ProductInfo productInfo = new ProductInfo("/terracotta-ehcache-version.properties");
            try {
                productInfo.assertRequiredCoreVersionPresent();
            }
            catch (NoSuchMethodError error) {
                throw new CacheException("The version of ehcache-core found on the classpath is too ancient for this version of ehcache-terracotta-ee. Please make sure both have the exact same version number!");
            }
        }
    }

    public Store createStore(Ehcache cache) {
        return this.realFactory.createStore(cache);
    }

    public WriteBehind createWriteBehind(Ehcache cache) {
        return this.realFactory.createWriteBehind(cache);
    }

    public CacheEventListener createEventReplicator(Ehcache cache) {
        return this.realFactory.createEventReplicator(cache);
    }

    public String getUUID() {
        return this.realFactory.getUUID();
    }

    public CacheCluster getTopology() {
        return this.realFactory.getTopology();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown() {
        try {
            this.realFactory.shutdown();
        }
        finally {
            this.client.shutdown();
        }
    }

    public TransactionIDFactory createTransactionIDFactory(String uuid, String cacheManagerName) {
        return this.realFactory.createTransactionIDFactory(uuid, cacheManagerName);
    }

    public SoftLockManager getOrCreateSoftLockManager(Ehcache cache) {
        return this.realFactory.getOrCreateSoftLockManager(cache);
    }
}

