/*
 * Decompiled with CFR 0.152.
 */
package net.sf.ehcache.distribution.jms;

import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.sf.ehcache.CacheException;
import net.sf.ehcache.Ehcache;
import net.sf.ehcache.Element;
import net.sf.ehcache.Status;
import net.sf.ehcache.distribution.CacheManagerPeerProvider;
import net.sf.ehcache.distribution.CachePeer;
import net.sf.ehcache.distribution.CacheReplicator;
import net.sf.ehcache.distribution.jms.Action;
import net.sf.ehcache.distribution.jms.JMSEventMessage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JMSCacheReplicator
implements CacheReplicator {
    public static final long DEFAULT_ASYNC_INTERVAL = 1000L;
    private static final Logger LOG = Logger.getLogger(JMSCacheReplicator.class.getName());
    private long asynchronousReplicationInterval = 1000L;
    private boolean replicatePuts;
    private boolean replicateUpdates;
    private boolean replicateUpdatesViaCopy;
    private boolean replicateRemovals;
    private boolean replicateAsync;
    private List<AsyncJMSEventMessage> replicationQueue;
    private Status status;

    public JMSCacheReplicator(boolean replicatePuts, boolean replicateUpdates, boolean replicateUpdatesViaCopy, boolean replicateRemovals, boolean replicateAsync, long asynchronousReplicationInterval) {
        if (LOG.isLoggable(Level.FINEST)) {
            LOG.finest("JMSCacheReplicator constructor ( replicatePuts = " + replicatePuts + ", replicateUpdates = " + replicateUpdates + ", " + "replicateUpdatesViaCopy = " + replicateUpdatesViaCopy + ", replicateRemovals = " + replicateRemovals + ", replicateAsync = " + replicateAsync + " ) called");
        }
        this.replicationQueue = new LinkedList<AsyncJMSEventMessage>();
        this.replicatePuts = replicatePuts;
        this.replicateUpdates = replicateUpdates;
        this.replicateUpdatesViaCopy = replicateUpdatesViaCopy;
        this.replicateRemovals = replicateRemovals;
        this.replicateAsync = replicateAsync;
        this.asynchronousReplicationInterval = asynchronousReplicationInterval;
        if (replicateAsync) {
            JMSReplicationThread replicationThread = new JMSReplicationThread();
            replicationThread.start();
        }
        this.status = Status.STATUS_ALIVE;
    }

    public boolean alive() {
        if (LOG.isLoggable(Level.FINEST)) {
            LOG.finest("alive ( ) called ");
        }
        return this.status == Status.STATUS_ALIVE;
    }

    public boolean isReplicateUpdatesViaCopy() {
        if (LOG.isLoggable(Level.FINEST)) {
            LOG.finest("isReplicateUpdatesViaCopy ( ) called ");
        }
        return this.replicateUpdatesViaCopy;
    }

    public boolean notAlive() {
        if (LOG.isLoggable(Level.FINEST)) {
            LOG.finest("notAlive ( ) called ");
        }
        return !this.alive();
    }

    public long getAsynchronousReplicationInterval() {
        return this.asynchronousReplicationInterval;
    }

    public void dispose() {
        if (LOG.isLoggable(Level.FINEST)) {
            LOG.finest("dispose ( ) called ");
        }
        this.status = Status.STATUS_SHUTDOWN;
        if (this.replicateAsync) {
            this.flushReplicationQueue();
        }
    }

    public void notifyElementEvicted(Ehcache cache, Element element) {
    }

    public void notifyElementExpired(Ehcache cache, Element element) {
    }

    public void notifyElementPut(Ehcache cache, Element element) throws CacheException {
        if (this.notAlive()) {
            return;
        }
        if (!this.replicatePuts) {
            return;
        }
        if (LOG.isLoggable(Level.FINEST)) {
            LOG.finest("notifyElementPut ( cache = " + cache + ", element = " + element + ") called ");
        }
        if (!element.isKeySerializable()) {
            LOG.warning("Key " + element.getObjectKey() + " is not Serializable and cannot be replicated.");
            return;
        }
        if (!element.isSerializable()) {
            LOG.warning("Object with key " + element.getObjectKey() + " is not Serializable and cannot be replicated");
            return;
        }
        this.replicatePut(cache, element);
    }

    public void notifyElementUpdated(Ehcache cache, Element element) throws CacheException {
        if (this.notAlive()) {
            return;
        }
        if (!this.replicateUpdates) {
            return;
        }
        if (LOG.isLoggable(Level.FINEST)) {
            LOG.finest("notifyElementUpdated ( cache = " + cache + ", element = " + element + ") called ");
        }
        if (!element.isKeySerializable()) {
            LOG.warning("Key " + element.getObjectKey() + " is not Serializable and cannot be replicated.");
            return;
        }
        if (!element.isSerializable()) {
            LOG.warning("Object with key " + element.getObjectKey() + " is not Serializable and cannot be replicated");
            return;
        }
        if (this.replicateUpdatesViaCopy) {
            this.replicatePut(cache, element);
        } else {
            this.replicateRemoval(cache, element);
        }
    }

    private void replicatePut(Ehcache cache, Element element) {
        JMSEventMessage message = new JMSEventMessage(Action.PUT, element.getKey(), element, cache.getName(), null);
        this.sendNotification(cache, message);
    }

    public void notifyElementRemoved(Ehcache cache, Element element) throws CacheException {
        if (LOG.isLoggable(Level.FINEST)) {
            LOG.finest("notifyElementRemoved ( cache = " + cache + ", element = " + element + ")");
        }
        if (this.notAlive()) {
            return;
        }
        if (!this.replicateRemovals) {
            return;
        }
        if (LOG.isLoggable(Level.FINEST)) {
            LOG.finest("notifyElementRemoved ( cache = " + cache + ", element = " + element + ")");
        }
        if (!element.isKeySerializable()) {
            LOG.warning("Key " + element.getObjectKey() + " is not Serializable and cannot be replicated.");
            return;
        }
        this.replicateRemoval(cache, element);
    }

    private void replicateRemoval(Ehcache cache, Element element) {
        JMSEventMessage message = new JMSEventMessage(Action.REMOVE, element.getKey(), null, cache.getName(), null);
        this.sendNotification(cache, message);
    }

    public void notifyRemoveAll(Ehcache cache) {
        if (this.notAlive()) {
            return;
        }
        if (!this.replicateRemovals) {
            return;
        }
        if (LOG.isLoggable(Level.FINEST)) {
            LOG.finest("notifyRemoveAll ( cache = " + cache + ") ");
        }
        JMSEventMessage message = new JMSEventMessage(Action.REMOVE_ALL, null, null, cache.getName(), null);
        this.sendNotification(cache, message);
    }

    public Object clone() throws CloneNotSupportedException {
        super.clone();
        return new JMSCacheReplicator(this.replicatePuts, this.replicateUpdates, this.replicateUpdatesViaCopy, this.replicateRemovals, this.replicateAsync, this.asynchronousReplicationInterval);
    }

    protected void sendNotification(Ehcache cache, JMSEventMessage message) {
        if (LOG.isLoggable(Level.FINEST)) {
            LOG.finest("sendNotification ( " + message.toString() + " )");
        }
        if (this.replicateAsync) {
            this.addMessageToQueue(cache, message);
            return;
        }
        ArrayList<JMSEventMessage> messages = new ArrayList<JMSEventMessage>();
        messages.add(message);
        for (CachePeer peer : JMSCacheReplicator.listRemoteCachePeers(cache)) {
            try {
                peer.send(messages);
            }
            catch (RemoteException e) {
                throw new CacheException((Throwable)e);
            }
        }
    }

    protected static List<CachePeer> listRemoteCachePeers(Ehcache cache) {
        CacheManagerPeerProvider provider = cache.getCacheManager().getCacheManagerPeerProvider("JMS");
        return provider.listRemoteCachePeers(cache);
    }

    private void replicationThreadMain() {
        while (true) {
            if (this.alive() && this.replicationQueue != null && this.replicationQueue.size() == 0) {
                try {
                    Thread.sleep(this.getAsynchronousReplicationInterval());
                }
                catch (InterruptedException e) {
                    LOG.fine("Spool Thread interrupted.");
                    return;
                }
            }
            if (this.notAlive()) {
                return;
            }
            try {
                this.flushReplicationQueue();
                continue;
            }
            catch (Throwable e) {
                LOG.log(Level.WARNING, "Exception on flushing of replication queue: " + e.getMessage() + ". Continuing...", e);
                continue;
            }
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addMessageToQueue(Ehcache cache, JMSEventMessage message) {
        List<AsyncJMSEventMessage> list = this.replicationQueue;
        synchronized (list) {
            this.replicationQueue.add(new AsyncJMSEventMessage(cache, message));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void flushReplicationQueue() {
        ArrayList<AsyncJMSEventMessage> replicationQueueCopy;
        if (LOG.isLoggable(Level.FINEST)) {
            LOG.finest("flushReplicationQueue ( ) called ");
        }
        List<AsyncJMSEventMessage> list = this.replicationQueue;
        synchronized (list) {
            if (this.replicationQueue.size() == 0) {
                return;
            }
            replicationQueueCopy = new ArrayList<AsyncJMSEventMessage>(this.replicationQueue);
            this.replicationQueue.clear();
        }
        ArrayList<JMSEventMessage> messages = new ArrayList<JMSEventMessage>(1);
        for (AsyncJMSEventMessage message : replicationQueueCopy) {
            Ehcache cache = message.getCache();
            List<CachePeer> cachePeers = JMSCacheReplicator.listRemoteCachePeers(cache);
            messages.add(message.getMessage());
            for (CachePeer peer : cachePeers) {
                try {
                    peer.send(messages);
                }
                catch (RemoteException e) {
                    LOG.warning("Unable to send message to remote peer. Message was: " + e.getMessage() + " continuing to send" + "remaining messages.");
                }
            }
            messages.clear();
        }
    }

    protected static final class AsyncJMSEventMessage {
        private Ehcache cache;
        private JMSEventMessage message;

        public AsyncJMSEventMessage(Ehcache cache, JMSEventMessage message) {
            this.cache = cache;
            this.message = message;
        }

        public Ehcache getCache() {
            return this.cache;
        }

        public JMSEventMessage getMessage() {
            return this.message;
        }
    }

    private final class JMSReplicationThread
    extends Thread {
        public JMSReplicationThread() {
            super("JMS Replication Thread");
            this.setDaemon(true);
            this.setPriority(5);
        }

        public void run() {
            JMSCacheReplicator.this.replicationThreadMain();
        }
    }
}

