/*
 * Decompiled with CFR 0.152.
 */
package net.sf.ehcache.distribution.jgroups;

import java.io.Serializable;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Queue;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ConcurrentMap;
import net.sf.ehcache.Element;
import net.sf.ehcache.distribution.CachePeer;
import net.sf.ehcache.distribution.jgroups.JGroupEventMessage;
import net.sf.ehcache.store.chm.ConcurrentHashMap;
import org.jgroups.Address;
import org.jgroups.Channel;
import org.jgroups.ChannelClosedException;
import org.jgroups.ChannelNotConnectedException;
import org.jgroups.Message;
import org.jgroups.View;
import org.jgroups.util.Util;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JGroupsCachePeer
implements CachePeer {
    private static final Logger LOG = LoggerFactory.getLogger((String)JGroupsCachePeer.class.getName());
    private static final int CHUNK_SIZE = 100;
    private final Channel channel;
    private final ConcurrentMap<Long, Queue<JGroupEventMessage>> asyncReplicationQueues = new ConcurrentHashMap();
    private final Timer timer;
    private volatile boolean alive;

    public JGroupsCachePeer(Channel channel, String clusterName) {
        this.channel = channel;
        this.alive = true;
        this.timer = new Timer(clusterName + " Async Replication Thread", true);
    }

    public void send(List eventMessages) throws RemoteException {
        this.send(null, eventMessages);
    }

    public List<Address> getGroupMembership() {
        View view = this.channel.getView();
        return view.getMembers();
    }

    public List<Address> getOtherGroupMembers() {
        Address localAddress = this.getLocalAddress();
        List<Address> members = this.getGroupMembership();
        ArrayList<Address> addresses = new ArrayList<Address>(members.size() - 1);
        for (Address member : members) {
            if (member.equals(localAddress)) continue;
            addresses.add(member);
        }
        return addresses;
    }

    public Address getLocalAddress() {
        return this.channel.getAddress();
    }

    public void dispose() {
        this.alive = false;
        this.disposeTimer();
        this.flushAllQueues();
        this.asyncReplicationQueues.clear();
    }

    private void disposeTimer() {
        if (this.timer != null) {
            this.timer.cancel();
            this.timer.purge();
        }
    }

    public void send(Address dest, List<JGroupEventMessage> eventMessages) {
        if (!this.alive || eventMessages == null || eventMessages.isEmpty()) {
            LOG.warn("Ignoring send request of {} messages. Replicator alive = {}", (Object)(eventMessages == null ? null : Integer.valueOf(eventMessages.size())), (Object)this.alive);
            return;
        }
        LinkedList<JGroupEventMessage> synchronousEventMessages = new LinkedList<JGroupEventMessage>();
        for (JGroupEventMessage groupEventMessage : eventMessages) {
            if (groupEventMessage.isAsync()) {
                long asyncTime = groupEventMessage.getAsyncTime();
                Queue<JGroupEventMessage> queue = this.getMessageQueue(asyncTime);
                queue.offer(groupEventMessage);
                LOG.trace("Queued {} for asynchronous sending.", (Object)groupEventMessage);
                continue;
            }
            synchronousEventMessages.add(groupEventMessage);
            LOG.trace("Sending {} synchronously.", (Object)groupEventMessage);
        }
        if (synchronousEventMessages.size() == 0) {
            return;
        }
        LOG.debug("Sending {} JGroupEventMessages synchronously.", (Object)synchronousEventMessages.size());
        this.sendData(dest, synchronousEventMessages);
    }

    private Queue<JGroupEventMessage> getMessageQueue(long asyncTime) {
        Queue queue = (Queue)this.asyncReplicationQueues.get(asyncTime);
        if (queue == null) {
            ConcurrentLinkedQueue<JGroupEventMessage> newQueue = new ConcurrentLinkedQueue<JGroupEventMessage>();
            queue = this.asyncReplicationQueues.putIfAbsent(asyncTime, newQueue);
            if (queue == null) {
                LOG.debug("Created asynchronous message queue for {}ms period", (Object)asyncTime);
                AsyncTimerTask task = new AsyncTimerTask(newQueue);
                this.timer.schedule((TimerTask)task, asyncTime, asyncTime);
                return newQueue;
            }
        }
        return queue;
    }

    private void sendData(Address dest, List<? extends Serializable> dataList) {
        byte[] data;
        Serializable toSend = dataList.size() == 1 ? dataList.get(0) : (Serializable)((Object)dataList);
        try {
            data = Util.objectToByteBuffer((Object)toSend);
        }
        catch (Exception e) {
            LOG.error("Error serializing data, it will not be sent: " + toSend, (Throwable)e);
            return;
        }
        Message msg = new Message(dest, null, data);
        try {
            this.channel.send(msg);
        }
        catch (ChannelNotConnectedException e) {
            LOG.error("Failed to send message(s) due to the channel being disconnected: " + toSend, (Throwable)e);
        }
        catch (ChannelClosedException e) {
            LOG.error("Failed to send message(s) due to the channel being closed: " + toSend, (Throwable)e);
        }
    }

    private void flushAllQueues() {
        for (Queue queue : this.asyncReplicationQueues.values()) {
            this.flushQueue(queue);
        }
    }

    private void flushQueue(Queue<JGroupEventMessage> queue) {
        ArrayList<JGroupEventMessage> events = new ArrayList<JGroupEventMessage>(100);
        while (!queue.isEmpty()) {
            JGroupEventMessage event;
            events.clear();
            while (!queue.isEmpty() && events.size() < 100 && (event = queue.poll()) != null) {
                if (event.isValid()) {
                    events.add(event);
                    continue;
                }
                LOG.warn("Collected soft reference during asynchronous queue flush, this event will not be replicated: " + (Object)((Object)event));
            }
            LOG.debug("Sending {} JGroupEventMessages from the asynchronous queue.", (Object)events.size());
            this.sendData(null, events);
        }
    }

    public List<?> getElements(List keys) throws RemoteException {
        return null;
    }

    public String getGuid() throws RemoteException {
        return null;
    }

    public List<?> getKeys() throws RemoteException {
        return null;
    }

    public String getName() throws RemoteException {
        return null;
    }

    public Element getQuiet(Serializable key) throws RemoteException {
        return null;
    }

    public String getUrl() throws RemoteException {
        return null;
    }

    public String getUrlBase() throws RemoteException {
        return null;
    }

    public void put(Element element) throws IllegalArgumentException, IllegalStateException, RemoteException {
    }

    public boolean remove(Serializable key) throws IllegalStateException, RemoteException {
        return false;
    }

    public void removeAll() throws RemoteException, IllegalStateException {
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class AsyncTimerTask
    extends TimerTask {
        private final Queue<JGroupEventMessage> queue;

        private AsyncTimerTask(Queue<JGroupEventMessage> newQueue) {
            this.queue = newQueue;
        }

        @Override
        public void run() {
            if (!JGroupsCachePeer.this.alive) {
                this.cancel();
                return;
            }
            JGroupsCachePeer.this.flushQueue(this.queue);
            if (!JGroupsCachePeer.this.alive) {
                this.cancel();
            }
        }
    }
}

