/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.shaded.lucene.search;

import java.io.IOException;
import org.terracotta.shaded.lucene.index.DocsEnum;
import org.terracotta.shaded.lucene.search.Scorer;
import org.terracotta.shaded.lucene.search.Weight;
import org.terracotta.shaded.lucene.search.similarities.Similarity;

final class TermScorer
extends Scorer {
    private final DocsEnum docsEnum;
    private final Similarity.ExactSimScorer docScorer;
    private final int docFreq;

    TermScorer(Weight weight, DocsEnum td, Similarity.ExactSimScorer docScorer, int docFreq) {
        super(weight);
        this.docScorer = docScorer;
        this.docsEnum = td;
        this.docFreq = docFreq;
    }

    @Override
    public int docID() {
        return this.docsEnum.docID();
    }

    @Override
    public int freq() throws IOException {
        return this.docsEnum.freq();
    }

    @Override
    public int nextDoc() throws IOException {
        return this.docsEnum.nextDoc();
    }

    @Override
    public float score() throws IOException {
        assert (this.docID() != Integer.MAX_VALUE);
        return this.docScorer.score(this.docsEnum.docID(), this.docsEnum.freq());
    }

    @Override
    public int advance(int target) throws IOException {
        return this.docsEnum.advance(target);
    }

    public String toString() {
        return "scorer(" + this.weight + ")";
    }

    DocsEnum getDocsEnum() {
        return this.docsEnum;
    }

    int getDocFreq() {
        return this.docFreq;
    }
}

