/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.license.nirvana;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.Date;
import java.util.Properties;
import java.util.concurrent.TimeUnit;
import org.terracotta.license.License;
import org.terracotta.license.LicenseBuilder;
import org.terracotta.license.util.IOUtils;
import org.terracotta.license.util.Utils;

public class NirvanaLicenseGenerator {
    private static final int EVAL_EXPIRATION_DAYS = 30;
    private final Properties nirvanaProps;

    public NirvanaLicenseGenerator(Properties props) {
        this.nirvanaProps = props;
    }

    public License generateEvalLicense(InputStream privateKeyStream) throws Exception {
        LicenseBuilder builder = new LicenseBuilder();
        builder.setPrivateKeyInputStream(privateKeyStream);
        builder.setProduct("Universal Messaging").setEdition("FX").setCapabilities("nirvana").setExpirationDate(this.getEvalExpirationDate()).setLicenseType("Trial");
        builder.setLicenseNumber("0").setLicensee("Generic Evaluation License");
        builder.addProperties(this.nirvanaProps);
        return builder.createLicense();
    }

    private Date getEvalExpirationDate() {
        return new Date(System.currentTimeMillis() + TimeUnit.DAYS.toMillis(30L));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws Exception {
        if (args.length == 0 || !new File(args[0]).exists()) {
            System.out.println("Private key is needed as argument. Please pass the path to existing private key");
            System.exit(1);
        }
        Properties evalProps = new Properties();
        evalProps.load(NirvanaLicenseGenerator.class.getResourceAsStream("evaluation.properties"));
        FileInputStream privateKeyStream = new FileInputStream(args[0]);
        try {
            NirvanaLicenseGenerator generator = new NirvanaLicenseGenerator(Utils.removeWhiteSpaces(evalProps));
            System.out.println(generator.generateEvalLicense(privateKeyStream).fullLicenseAsString());
        }
        finally {
            IOUtils.closeQuietly(privateKeyStream);
        }
    }
}

