/*
 * Decompiled with CFR 0.152.
 */
package net.sf.ehcache.util;

import net.sf.ehcache.CacheManager;
import net.sf.ehcache.util.ProductInfo;
import net.sf.ehcache.util.UpdateChecker;
import org.terracotta.license.License;
import org.terracotta.license.ehcache.LicenseManager;

public class EnterpriseUpdateChecker
extends UpdateChecker {
    private CacheManager cacheManager;

    public EnterpriseUpdateChecker(CacheManager cacheManager) {
        this.cacheManager = cacheManager;
        License license = LicenseManager.getLicense();
        if (license != null) {
            this.putUrlSafe("tc-product", license.product() + " " + new ProductInfo().getVersion());
            this.putUrlSafe("type", license.type());
            this.putUrlSafe("number", license.number());
            if ("BigMemory Max".equals(license.product())) {
                this.putUrlSafe("source", "BigMemory L1");
            } else if ("BigMemory Go".equals(license.product())) {
                this.putUrlSafe("source", "BigMemory Go");
            }
        }
    }

    @Override
    protected void updateParams() {
        super.updateParams();
        this.putUrlSafe("storage-size", Long.toString(this.cacheManager.getConfiguration().getTotalConfiguredOffheap()));
    }
}

