/*
 * Decompiled with CFR 0.152.
 */
package net.sf.ehcache.store.offheap.search;

import com.terracottatech.offheapstore.storage.listener.RecoveryStorageEngineListener;
import com.terracottatech.offheapstore.storage.listener.RuntimeStorageEngineListener;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Callable;
import net.sf.ehcache.Element;
import net.sf.ehcache.config.CacheConfiguration;
import net.sf.ehcache.config.SearchAttribute;
import net.sf.ehcache.search.attribute.AttributeExtractor;
import net.sf.ehcache.store.CopyStrategyHandler;
import net.sf.ehcache.store.offheap.search.LuceneIndexedSearchManager;
import net.sf.ehcache.transaction.SoftLockID;

public class SearchStorageEngineListener<K>
implements RuntimeStorageEngineListener<K, Element>,
RecoveryStorageEngineListener<K, Element> {
    private final Map<String, AttributeExtractor> extractors = new HashMap<String, AttributeExtractor>();
    private final LuceneIndexedSearchManager searchManager;
    private final String cacheName;
    private final int segmentId;
    private final CacheConfiguration config;
    private final CopyStrategyHandler copyStrategyHandler;

    public SearchStorageEngineListener(LuceneIndexedSearchManager searchManager, CacheConfiguration cacheConfig, int segmentId) {
        this.searchManager = searchManager;
        this.segmentId = segmentId;
        this.cacheName = cacheConfig.getName();
        this.config = cacheConfig;
        this.copyStrategyHandler = new CopyStrategyHandler(cacheConfig.isCopyOnRead(), cacheConfig.isCopyOnWrite(), cacheConfig.getCopyStrategy());
        for (Map.Entry<String, SearchAttribute> entry : cacheConfig.getSearchable().getSearchAttributes().entrySet()) {
            this.extractors.put(entry.getKey(), entry.getValue().constructExtractor());
        }
    }

    @Override
    public void recovered(Callable<? extends K> key, Callable<? extends Element> value, ByteBuffer binaryKey, ByteBuffer binaryValue, int hash, int metadata, long encoding) {
        try {
            Element e = value.call();
            this.written(e.getObjectKey(), e, binaryKey, binaryValue, hash, metadata, encoding);
        }
        catch (RuntimeException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    @Override
    public void written(K key, Element value, ByteBuffer binaryKey, ByteBuffer binaryValue, int hash, int metadata, long encoding) {
        if (this.searchManager.shouldIndex()) {
            SoftLockID sl;
            boolean isXa = value.getObjectValue() instanceof SoftLockID;
            if (isXa && (value = (sl = (SoftLockID)value.getObjectValue()).getOldElement()) == null) {
                return;
            }
            this.searchManager.put(this.cacheName, this.segmentId, this.copyStrategyHandler.copyElementForReadIfNeeded(value), SearchStorageEngineListener.getBytes(binaryKey), this.extractors, this.config.getDynamicExtractor());
        }
    }

    @Override
    public void freed(long encoding, int hash, ByteBuffer binaryKey, boolean removed) {
        if (this.searchManager.shouldIndex()) {
            this.searchManager.remove(this.cacheName, SearchStorageEngineListener.getBytes(binaryKey), this.segmentId, removed);
        }
    }

    @Override
    public void cleared() {
        if (this.searchManager.shouldIndex()) {
            this.searchManager.clear(this.cacheName, this.segmentId);
        }
    }

    @Override
    public void copied(int hash, long oldEncoding, long newEncoding, int metadata) {
    }

    private static byte[] getBytes(ByteBuffer buf) {
        if (buf.hasArray() && buf.arrayOffset() == 0 && buf.remaining() == buf.array().length) {
            return buf.array();
        }
        byte[] rv = new byte[buf.remaining()];
        buf.get(rv);
        return rv;
    }
}

