/*
 * Decompiled with CFR 0.152.
 */
package com.terracottatech.search;

import com.terracottatech.search.DeferredQueryResult;
import com.terracottatech.search.IndexException;
import com.terracottatech.search.LuceneIndex;
import com.terracottatech.search.NVPair;
import com.terracottatech.search.NonGroupedIndexQueryResultImpl;
import com.terracottatech.search.NonGroupedQueryResult;
import com.terracottatech.search.QueryInputs;
import com.terracottatech.search.SearchResult;
import com.terracottatech.search.SearchResultSource;
import com.terracottatech.search.SearchResultsManager;
import com.terracottatech.search.ValueID;
import com.terracottatech.search.ValueType;
import com.terracottatech.search.aggregator.Aggregator;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.terracotta.shaded.lucene.document.Document;
import org.terracotta.shaded.lucene.index.IndexReader;

class CachedDocIdResultSource
implements SearchResultSource {
    private final IndexReader reader;
    private final IntList docIds;
    private final QueryInputs queryArgs;
    private List<Aggregator> aggregators;

    CachedDocIdResultSource(IndexReader srcReader, QueryInputs params) {
        this.reader = srcReader;
        this.queryArgs = params;
        this.docIds = new IntList();
    }

    @Override
    public void acceptResult(DeferredQueryResult result) {
        this.docIds.add(result.getLuceneDocId());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SearchResult<NonGroupedQueryResult> getResults(int start, int size) throws IndexException {
        int end = Math.min(this.docIds.size, start + size);
        if (size <= 0 || start < 0) {
            throw new IllegalArgumentException();
        }
        ArrayList<NonGroupedIndexQueryResultImpl> resList = new ArrayList<NonGroupedIndexQueryResultImpl>(size);
        Set groupByAttrs = Collections.EMPTY_SET;
        try {
            IndexReader indexReader = this.reader;
            synchronized (indexReader) {
                if (this.reader.getRefCount() == 0) {
                    throw new IndexException("Result set already closed.");
                }
                for (int i = start; i < end; ++i) {
                    ArrayList<NVPair> attributes = new ArrayList<NVPair>(this.queryArgs.getAttributes().size());
                    ArrayList<NVPair> sortAttributesList = new ArrayList<NVPair>(this.queryArgs.getSortAttributes().size());
                    Document doc = this.reader.document(this.docIds.get(i), this.queryArgs.getFieldNamesToLoad());
                    SearchResultsManager.loadDocumentData(doc, this.queryArgs, attributes, groupByAttrs, sortAttributesList);
                    String key = this.queryArgs.includeKeys() ? doc.get("__TC_KEY_FIELD") : null;
                    ValueID value = this.queryArgs.includeValues() ? (ValueID)LuceneIndex.getFieldValue(doc, "__TC_VALUE_FIELD", ValueType.VALUE_ID) : ValueID.NULL_ID;
                    resList.add(new NonGroupedIndexQueryResultImpl(key, value, attributes, sortAttributesList));
                }
            }
            return new SearchResult<NonGroupedQueryResult>(this.docIds.size(), resList, this.aggregators, this.docIds.size() > 0);
        }
        catch (IOException e) {
            throw new IndexException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        IndexReader indexReader = this.reader;
        synchronized (indexReader) {
            this.reader.close();
        }
    }

    @Override
    public void setAggregatorValues(List<Aggregator> aggregators) {
        this.aggregators = Collections.unmodifiableList(aggregators);
    }

    private static class IntList {
        private int size = 0;
        private int[] data;

        IntList() {
            this(16);
        }

        IntList(int cap) {
            this.data = new int[cap];
        }

        int size() {
            return this.size;
        }

        void add(int toAdd) {
            if (this.size == this.data.length) {
                int[] temp = new int[this.data.length * 2];
                System.arraycopy(this.data, 0, temp, 0, this.data.length);
                this.data = temp;
            }
            this.data[this.size++] = toAdd;
        }

        int get(int index) {
            return this.data[index];
        }
    }
}

