/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.shaded.lucene.util.packed;

import java.io.EOFException;
import java.io.IOException;
import java.util.Arrays;
import org.terracotta.shaded.lucene.store.DataInput;
import org.terracotta.shaded.lucene.store.IndexInput;
import org.terracotta.shaded.lucene.util.LongsRef;
import org.terracotta.shaded.lucene.util.packed.BlockPackedWriter;
import org.terracotta.shaded.lucene.util.packed.PackedInts;

public final class BlockPackedReader {
    final DataInput in;
    final int packedIntsVersion;
    final long valueCount;
    final int blockSize;
    final LongsRef values;
    byte[] blocks;
    int off;
    long ord;

    static long zigZagDecode(long n) {
        return n >>> 1 ^ -(n & 1L);
    }

    static long readVLong(DataInput in) throws IOException {
        byte b = in.readByte();
        if (b >= 0) {
            return b;
        }
        long i = (long)b & 0x7FL;
        b = in.readByte();
        i |= ((long)b & 0x7FL) << 7;
        if (b >= 0) {
            return i;
        }
        b = in.readByte();
        i |= ((long)b & 0x7FL) << 14;
        if (b >= 0) {
            return i;
        }
        b = in.readByte();
        i |= ((long)b & 0x7FL) << 21;
        if (b >= 0) {
            return i;
        }
        b = in.readByte();
        i |= ((long)b & 0x7FL) << 28;
        if (b >= 0) {
            return i;
        }
        b = in.readByte();
        i |= ((long)b & 0x7FL) << 35;
        if (b >= 0) {
            return i;
        }
        b = in.readByte();
        i |= ((long)b & 0x7FL) << 42;
        if (b >= 0) {
            return i;
        }
        b = in.readByte();
        i |= ((long)b & 0x7FL) << 49;
        if (b >= 0) {
            return i;
        }
        b = in.readByte();
        return i |= ((long)b & 0xFFL) << 56;
    }

    public BlockPackedReader(DataInput in, int packedIntsVersion, int blockSize, long valueCount) {
        BlockPackedWriter.checkBlockSize(blockSize);
        this.in = in;
        this.packedIntsVersion = packedIntsVersion;
        this.blockSize = blockSize;
        this.values = new LongsRef(blockSize);
        assert (valueCount >= 0L);
        this.valueCount = valueCount;
        this.off = blockSize;
        this.ord = 0L;
    }

    public void skip(long count) throws IOException {
        assert (count >= 0L);
        if (this.ord + count > this.valueCount || this.ord + count < 0L) {
            throw new EOFException();
        }
        int skipBuffer = (int)Math.min(count, (long)(this.blockSize - this.off));
        this.off += skipBuffer;
        this.ord += (long)skipBuffer;
        if ((count -= (long)skipBuffer) == 0L) {
            return;
        }
        assert (this.off == this.blockSize);
        while (count >= (long)this.blockSize) {
            int token = this.in.readByte() & 0xFF;
            int bitsPerValue = token >>> 1;
            if (bitsPerValue > 64) {
                throw new IOException("Corrupted");
            }
            if ((token & 1) == 0) {
                BlockPackedReader.readVLong(this.in);
            }
            long blockBytes = PackedInts.Format.PACKED.byteCount(this.packedIntsVersion, this.blockSize, bitsPerValue);
            this.skipBytes(blockBytes);
            this.ord += (long)this.blockSize;
            count -= (long)this.blockSize;
        }
        if (count == 0L) {
            return;
        }
        assert (count < (long)this.blockSize);
        this.refill();
        this.ord += count;
        this.off = (int)((long)this.off + count);
    }

    private void skipBytes(long count) throws IOException {
        if (this.in instanceof IndexInput) {
            IndexInput iin = (IndexInput)this.in;
            iin.seek(iin.getFilePointer() + count);
        } else {
            int toSkip;
            if (this.blocks == null) {
                this.blocks = new byte[this.blockSize];
            }
            for (long skipped = 0L; skipped < count; skipped += (long)toSkip) {
                toSkip = (int)Math.min((long)this.blocks.length, count - skipped);
                this.in.readBytes(this.blocks, 0, toSkip);
            }
        }
    }

    public long next() throws IOException {
        this.next(1);
        assert (this.values.length == 1);
        return this.values.longs[this.values.offset];
    }

    public LongsRef next(int count) throws IOException {
        assert (count > 0);
        if (this.ord == this.valueCount) {
            throw new EOFException();
        }
        if (this.off == this.blockSize) {
            this.refill();
        }
        count = Math.min(count, this.blockSize - this.off);
        count = (int)Math.min((long)count, this.valueCount - this.ord);
        this.values.offset = this.off;
        this.values.length = count;
        this.off += count;
        this.ord += (long)count;
        return this.values;
    }

    private void refill() throws IOException {
        long minValue;
        int token = this.in.readByte() & 0xFF;
        boolean minEquals0 = (token & 1) != 0;
        int bitsPerValue = token >>> 1;
        if (bitsPerValue > 64) {
            throw new IOException("Corrupted");
        }
        long l = minValue = minEquals0 ? 0L : BlockPackedReader.zigZagDecode(1L + BlockPackedReader.readVLong(this.in));
        assert (minEquals0 || minValue != 0L);
        if (bitsPerValue == 0) {
            Arrays.fill(this.values.longs, minValue);
        } else {
            PackedInts.Decoder decoder = PackedInts.getDecoder(PackedInts.Format.PACKED, this.packedIntsVersion, bitsPerValue);
            int iterations = this.blockSize / decoder.valueCount();
            int blocksSize = iterations * 8 * decoder.blockCount();
            if (this.blocks == null || this.blocks.length < blocksSize) {
                this.blocks = new byte[blocksSize];
            }
            int valueCount = (int)Math.min(this.valueCount - this.ord, (long)this.blockSize);
            int blocksCount = (int)PackedInts.Format.PACKED.byteCount(this.packedIntsVersion, valueCount, bitsPerValue);
            this.in.readBytes(this.blocks, 0, blocksCount);
            decoder.decode(this.blocks, 0, this.values.longs, 0, iterations);
            if (minValue != 0L) {
                int i = 0;
                while (i < valueCount) {
                    int n = i++;
                    this.values.longs[n] = this.values.longs[n] + minValue;
                }
            }
        }
        this.off = 0;
    }

    public long ord() {
        return this.ord;
    }
}

