/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.shaded.lucene.index;

import java.io.IOException;
import org.terracotta.shaded.lucene.codecs.Codec;
import org.terracotta.shaded.lucene.codecs.StoredFieldsWriter;
import org.terracotta.shaded.lucene.index.DocumentsWriterPerThread;
import org.terracotta.shaded.lucene.index.FieldInfo;
import org.terracotta.shaded.lucene.index.IndexableField;
import org.terracotta.shaded.lucene.index.SegmentWriteState;
import org.terracotta.shaded.lucene.store.IOContext;
import org.terracotta.shaded.lucene.util.ArrayUtil;
import org.terracotta.shaded.lucene.util.RamUsageEstimator;

final class StoredFieldsConsumer {
    StoredFieldsWriter fieldsWriter;
    final DocumentsWriterPerThread docWriter;
    int lastDocID;
    int freeCount;
    final DocumentsWriterPerThread.DocState docState;
    final Codec codec;
    private int numStoredFields;
    private IndexableField[] storedFields;
    private FieldInfo[] fieldInfos;
    int allocCount;

    public StoredFieldsConsumer(DocumentsWriterPerThread docWriter) {
        this.docWriter = docWriter;
        this.docState = docWriter.docState;
        this.codec = docWriter.codec;
    }

    public void reset() {
        this.numStoredFields = 0;
        this.storedFields = new IndexableField[1];
        this.fieldInfos = new FieldInfo[1];
    }

    public void startDocument() {
        this.reset();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void flush(SegmentWriteState state) throws IOException {
        int numDocs = state.segmentInfo.getDocCount();
        if (numDocs > 0) {
            this.initFieldsWriter(state.context);
            this.fill(numDocs);
        }
        if (this.fieldsWriter != null) {
            try {
                this.fieldsWriter.finish(state.fieldInfos, numDocs);
            }
            finally {
                this.fieldsWriter.close();
                this.fieldsWriter = null;
                this.lastDocID = 0;
            }
        }
    }

    private synchronized void initFieldsWriter(IOContext context) throws IOException {
        if (this.fieldsWriter == null) {
            this.fieldsWriter = this.codec.storedFieldsFormat().fieldsWriter(this.docWriter.directory, this.docWriter.getSegmentInfo(), context);
            this.lastDocID = 0;
        }
    }

    void abort() {
        this.reset();
        if (this.fieldsWriter != null) {
            this.fieldsWriter.abort();
            this.fieldsWriter = null;
            this.lastDocID = 0;
        }
    }

    void fill(int docID) throws IOException {
        while (this.lastDocID < docID) {
            this.fieldsWriter.startDocument(0);
            ++this.lastDocID;
            this.fieldsWriter.finishDocument();
        }
    }

    void finishDocument() throws IOException {
        assert (this.docWriter.writer.testPoint("StoredFieldsWriter.finishDocument start"));
        this.initFieldsWriter(IOContext.DEFAULT);
        this.fill(this.docState.docID);
        if (this.fieldsWriter != null && this.numStoredFields > 0) {
            this.fieldsWriter.startDocument(this.numStoredFields);
            for (int i = 0; i < this.numStoredFields; ++i) {
                this.fieldsWriter.writeField(this.fieldInfos[i], this.storedFields[i]);
            }
            this.fieldsWriter.finishDocument();
            ++this.lastDocID;
        }
        this.reset();
        assert (this.docWriter.writer.testPoint("StoredFieldsWriter.finishDocument end"));
    }

    public void addField(IndexableField field, FieldInfo fieldInfo) {
        if (this.numStoredFields == this.storedFields.length) {
            int newSize = ArrayUtil.oversize(this.numStoredFields + 1, RamUsageEstimator.NUM_BYTES_OBJECT_REF);
            IndexableField[] newArray = new IndexableField[newSize];
            System.arraycopy(this.storedFields, 0, newArray, 0, this.numStoredFields);
            this.storedFields = newArray;
            FieldInfo[] newInfoArray = new FieldInfo[newSize];
            System.arraycopy(this.fieldInfos, 0, newInfoArray, 0, this.numStoredFields);
            this.fieldInfos = newInfoArray;
        }
        this.storedFields[this.numStoredFields] = field;
        this.fieldInfos[this.numStoredFields] = fieldInfo;
        ++this.numStoredFields;
        assert (this.docState.testPoint("StoredFieldsWriterPerThread.processFields.writeField"));
    }
}

