/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.modules.ehcache.store;

import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.locks.Lock;
import net.sf.ehcache.Ehcache;
import net.sf.ehcache.Element;
import net.sf.ehcache.ElementData;
import net.sf.ehcache.cluster.CacheCluster;
import net.sf.ehcache.config.DynamicSearchListener;
import net.sf.ehcache.config.Searchable;
import net.sf.ehcache.search.Attribute;
import net.sf.ehcache.search.Result;
import net.sf.ehcache.search.Results;
import net.sf.ehcache.search.SearchException;
import net.sf.ehcache.search.attribute.AttributeExtractor;
import net.sf.ehcache.search.attribute.DynamicAttributesExtractor;
import net.sf.ehcache.search.impl.AggregateOnlyResult;
import net.sf.ehcache.search.impl.BaseResult;
import net.sf.ehcache.search.impl.DynamicSearchChecker;
import net.sf.ehcache.search.impl.ResultsImpl;
import net.sf.ehcache.store.StoreQuery;
import net.sf.ehcache.transaction.SoftLockID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.terracotta.modules.ehcache.ToolkitInstanceFactory;
import org.terracotta.modules.ehcache.search.ClusteredResultsList;
import org.terracotta.modules.ehcache.search.QueryInterpreter;
import org.terracotta.modules.ehcache.store.ClusteredStore;
import org.terracotta.toolkit.ToolkitFeatureType;
import org.terracotta.toolkit.collections.ToolkitMap;
import org.terracotta.toolkit.feature.SearchFeature;
import org.terracotta.toolkit.search.SearchQueryResultSet;
import org.terracotta.toolkit.search.attribute.ToolkitAttributeExtractor;
import org.terracotta.toolkit.search.attribute.ToolkitAttributeExtractorException;

public class EnterpriseClusteredStore
extends ClusteredStore
implements DynamicSearchListener {
    private final ToolkitAttributeExtractor<String, Serializable> xtorBridge = new ToolkitAttributeExtractor<String, Serializable>(){

        public Map<String, Object> attributesFor(String key, Serializable value) {
            String name;
            Element elt;
            Searchable s = EnterpriseClusteredStore.this.cache.getCacheConfiguration().getSearchable();
            if (EnterpriseClusteredStore.this.dynamicAttrExtractor == null && s.isDynamicIndexingAllowed()) {
                throw new ToolkitAttributeExtractorException("Dynamic attributes extractor must be set prior to adding data to cache.");
            }
            if (EnterpriseClusteredStore.this.extractors.isEmpty() && EnterpriseClusteredStore.this.dynamicAttrExtractor == null) {
                return DO_NOT_INDEX;
            }
            ElementData ed = (ElementData)value;
            boolean isXa = ed.getValue() instanceof SoftLockID;
            HashMap<String, Object> attrs = new HashMap<String, Object>();
            if (isXa) {
                SoftLockID sl = (SoftLockID)ed.getValue();
                elt = sl.getOldElement();
                if (elt == null) {
                    return DO_NOT_INDEX;
                }
            } else {
                elt = EnterpriseClusteredStore.this.valueModeHandler.createElement(EnterpriseClusteredStore.this.valueModeHandler.getRealKeyObject(key), ed);
            }
            HashMap<String, ? extends Object> allAttrs = new HashMap<String, Object>();
            allAttrs.putAll(DynamicSearchChecker.getSearchAttributes(elt, EnterpriseClusteredStore.this.extractors.keySet(), EnterpriseClusteredStore.this.dynamicAttrExtractor));
            for (Map.Entry entry : EnterpriseClusteredStore.this.extractors.entrySet()) {
                name = (String)entry.getKey();
                AttributeExtractor extractor = (AttributeExtractor)entry.getValue();
                Object av = extractor.attributeFor(elt, name);
                allAttrs.put(name, av);
            }
            for (Map.Entry attr : allAttrs.entrySet()) {
                int len;
                name = (String)attr.getKey();
                Object av = attr.getValue();
                if (av instanceof String && (len = ((String)av).length()) >= 16384) {
                    throw new SearchException("Cannot index strings with length >= 16384");
                }
                if (av == null) continue;
                attrs.put(name, av);
            }
            return attrs;
        }
    };
    private static final Logger LOG = LoggerFactory.getLogger((String)EnterpriseClusteredStore.class.getName());
    private static final int MAX_STRING_ATTR_LENGTH = 16384;
    private final Map<String, Attribute> searchAttributes = new HashMap<String, Attribute>();
    private final Lock lock;
    private final Map<String, AttributeExtractor> extractors = new HashMap<String, AttributeExtractor>();
    private volatile DynamicAttributesExtractor dynamicAttrExtractor;

    public EnterpriseClusteredStore(ToolkitInstanceFactory toolkitInstanceFactory, Ehcache cache, CacheCluster topology) {
        super(toolkitInstanceFactory, cache, topology);
        this.lock = toolkitInstanceFactory.getOrCreateStoreLock(cache);
        cache.getCacheConfiguration().addDynamicSearchListener(this);
    }

    @Override
    public <T> Attribute<T> getSearchAttribute(String attributeName) {
        return this.searchAttributes.get(attributeName);
    }

    @Override
    public Results executeQuery(StoreQuery query) {
        List<Result> res;
        QueryInterpreter interpreter = new QueryInterpreter(this.backend.createQueryBuilder());
        interpreter.process(query);
        SearchQueryResultSet queryResults = interpreter.executeQuery();
        List aggregatorResults = queryResults.getAggregatorResults();
        if (queryResults.anyCriteriaMatched() && queryResults.getResults().isEmpty() && !aggregatorResults.isEmpty()) {
            res = Collections.singletonList(new AggregateOnlyResult(query));
            ((BaseResult)res.get(0)).setAggregateResults(aggregatorResults);
        } else {
            res = new ClusteredResultsList(queryResults.getResults(), query, this.valueModeHandler);
        }
        return new ResultsImpl((List<? extends Result>)res, query.requestsKeys(), query.requestsValues(), !query.requestedAttributes().isEmpty(), queryResults.anyCriteriaMatched() && !query.getAggregatorInstances().isEmpty());
    }

    @Override
    public boolean isSearchable() {
        return !this.searchAttributes.isEmpty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setAttributeExtractors(Map<String, AttributeExtractor> requestedExtractors) {
        SearchFeature searchFeature;
        if (!(requestedExtractors.isEmpty() || (searchFeature = (SearchFeature)this.toolkitInstanceFactory.getToolkit().getFeature(ToolkitFeatureType.SEARCH)) != null && searchFeature.isEnabled())) {
            throw new UnsupportedOperationException("Search capability is not enabled. Please verify you have correct license");
        }
        this.lock.lock();
        try {
            if (this.extractors.isEmpty()) {
                ToolkitMap<String, AttributeExtractor> clusteredExtractors = this.toolkitInstanceFactory.getOrCreateExtractorsMap(this.cache);
                if (clusteredExtractors.isEmpty()) {
                    clusteredExtractors.putAll(requestedExtractors);
                } else {
                    EnterpriseClusteredStore.reportSearchAttributeDifferences(clusteredExtractors, requestedExtractors);
                }
                this.extractors.putAll((Map<String, AttributeExtractor>)clusteredExtractors);
                for (String name : this.extractors.keySet()) {
                    this.searchAttributes.put(name, new Attribute(name));
                }
                this.backend.setAttributeExtractor(this.xtorBridge);
            } else {
                EnterpriseClusteredStore.reportSearchAttributeDifferences(this.extractors, requestedExtractors);
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public void extractorChanged(DynamicAttributesExtractor oldValue, DynamicAttributesExtractor newValue) {
        this.dynamicAttrExtractor = newValue;
    }

    private static void reportSearchAttributeDifferences(Map<String, AttributeExtractor> actual, Map<String, AttributeExtractor> config) {
        HashSet<String> extraFromConfig = new HashSet<String>(config.keySet());
        extraFromConfig.removeAll(actual.keySet());
        for (String name : extraFromConfig) {
            LOG.warn("local configuration defines attribute [" + name + "] which is not present in the clustered store");
        }
        HashSet<String> extraActual = new HashSet<String>(actual.keySet());
        extraActual.removeAll(config.keySet());
        for (String name : extraActual) {
            LOG.warn("Cluster defines attribute [" + name + "] which is not present in local configuration");
        }
    }
}

