/*
 * Decompiled with CFR 0.152.
 */
package net.sf.ehcache.util;

import net.sf.ehcache.CacheManager;
import net.sf.ehcache.util.ProductInfo;
import net.sf.ehcache.util.UpdateChecker;
import org.terracotta.license.License;
import org.terracotta.license.ehcache.LicenseManager;

public class EnterpriseUpdateChecker
extends UpdateChecker {
    private CacheManager cacheManager;

    public EnterpriseUpdateChecker(CacheManager cacheManager) {
        this.cacheManager = cacheManager;
        ProductInfo pi = new ProductInfo();
        License license = LicenseManager.getLicense();
        String tcProduct = pi.getName() + " " + pi.getVersion();
        String type = "unknown";
        String number = "unknown";
        String source = pi.getName();
        if (license != null) {
            tcProduct = license.product() + " " + pi.getVersion();
            type = license.type();
            number = license.number();
            if ("BigMemory Max".equals(license.product())) {
                source = "BigMemory L1";
            } else if ("BigMemory Go".equals(license.product())) {
                source = "BigMemory Go";
            }
        }
        this.putUrlSafe("tc-product", tcProduct);
        this.putUrlSafe("type", type);
        this.putUrlSafe("number", number);
        this.putUrlSafe("source", source);
    }

    @Override
    protected void updateParams() {
        super.updateParams();
        this.putUrlSafe("storage-size", Long.toString(this.cacheManager.getConfiguration().getTotalConfiguredOffheap()));
    }
}

