/*
 * Decompiled with CFR 0.152.
 */
package net.sf.ehcache.store.offheap.portability;

import com.terracottatech.offheapstore.storage.portability.Portability;
import com.terracottatech.offheapstore.storage.portability.SerializablePortability;
import com.terracottatech.offheapstore.util.ByteBufferInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.Serializable;
import java.nio.ByteBuffer;
import net.sf.ehcache.CacheException;
import net.sf.ehcache.Element;
import net.sf.ehcache.ElementIdHelper;
import net.sf.ehcache.config.CacheConfiguration;
import net.sf.ehcache.store.offheap.portability.AbstractEhcachePortability;
import net.sf.ehcache.util.TimeUtil;

public class EhcacheElementPortability
extends AbstractEhcachePortability
implements Portability<Element> {
    private static final byte COMPACT_ELEMENT = 1;
    private static final byte EXTENDED_ELEMENT = 2;
    private static final byte COMPACT_ELEMENT_WITH_ID = 3;
    private static final byte EXTENDED_ELEMENT_WITH_ID = 4;
    private final CacheConfiguration cacheConfiguration;

    public EhcacheElementPortability(CacheConfiguration cacheConfiguration) {
        super(new SerializablePortability());
        this.cacheConfiguration = cacheConfiguration;
    }

    public EhcacheElementPortability(SerializablePortability delegate, CacheConfiguration cacheConfiguration) {
        super(delegate);
        this.cacheConfiguration = cacheConfiguration;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ByteBuffer encode(Element element) {
        long id;
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        DataOutputStream dout = new DataOutputStream(bout);
        boolean hasId = ElementIdHelper.hasId(element);
        long l = id = hasId ? ElementIdHelper.getId(element) : 0L;
        if (hasId && id == 0L) {
            throw new AssertionError();
        }
        try {
            try {
                if (element.usesCacheDefaultLifespan()) {
                    dout.writeByte(hasId ? 3 : 1);
                    if (hasId) {
                        dout.writeLong(id);
                    }
                    dout.writeLong(element.getVersion());
                    dout.writeInt(TimeUtil.toSecs(element.getCreationTime()));
                    dout.writeInt(TimeUtil.toSecs(element.getLastAccessTime()));
                    dout.writeInt(TimeUtil.toSecs(element.getLastUpdateTime()));
                } else {
                    dout.writeByte(hasId ? 4 : 2);
                    if (hasId) {
                        dout.writeLong(id);
                    }
                    dout.writeLong(element.getVersion());
                    dout.writeBoolean(element.usesCacheDefaultLifespan());
                    dout.writeInt(element.getTimeToLive());
                    dout.writeInt(element.getTimeToIdle());
                    dout.writeInt(TimeUtil.toSecs(element.getCreationTime()));
                    dout.writeInt(TimeUtil.toSecs(element.getLastAccessTime()));
                    dout.writeInt(TimeUtil.toSecs(element.getLastUpdateTime()));
                }
                this.writeObjects(dout, element.getKey(), element.getValue());
            }
            finally {
                dout.close();
            }
        }
        catch (IOException e) {
            throw new CacheException("Failed while encoding element " + element, e);
        }
        return ByteBuffer.wrap(bout.toByteArray());
    }

    @Override
    public Element decode(ByteBuffer buffer) {
        try {
            DataInputStream din = new DataInputStream(new ByteBufferInputStream(buffer));
            byte type = din.readByte();
            switch (type) {
                case 1: 
                case 3: {
                    long id = type == 3 ? din.readLong() : 0L;
                    long version = din.readLong();
                    long creation = TimeUtil.toMillis(din.readInt());
                    long access = TimeUtil.toMillis(din.readInt());
                    long update = TimeUtil.toMillis(din.readInt());
                    Serializable[] payload = this.readObjects(din, 2);
                    Element e = new Element(payload[0], payload[1], version, creation, access, 0L, true, (int)this.cacheConfiguration.getTimeToLiveSeconds(), (int)this.cacheConfiguration.getTimeToIdleSeconds(), update);
                    if (type == 3) {
                        ElementIdHelper.setId(e, id);
                    }
                    return e;
                }
                case 2: 
                case 4: {
                    long id = type == 4 ? din.readLong() : 0L;
                    long version = din.readLong();
                    boolean cacheDefaultLifespan = din.readBoolean();
                    int ttl = din.readInt();
                    int tti = din.readInt();
                    long creation = TimeUtil.toMillis(din.readInt());
                    long access = TimeUtil.toMillis(din.readInt());
                    long update = TimeUtil.toMillis(din.readInt());
                    Serializable[] payload = this.readObjects(din, 2);
                    Element e = new Element(payload[0], payload[1], version, creation, access, 0L, cacheDefaultLifespan, ttl, tti, update);
                    if (type == 4) {
                        ElementIdHelper.setId(e, id);
                    }
                    return e;
                }
            }
            throw new CacheException("Unknown Element encoding " + type);
        }
        catch (ClassNotFoundException e) {
            throw new CacheException("Failed while decoding element " + buffer, e);
        }
        catch (IOException e) {
            throw new CacheException("Failed while decoding element " + buffer, e);
        }
    }

    @Override
    public boolean equals(Object object, ByteBuffer buffer) {
        return object.equals(this.decode(buffer));
    }
}

