/*
 * Decompiled with CFR 0.152.
 */
package net.sf.ehcache.store.offheap.factories;

import com.terracottatech.offheapstore.exceptions.OversizeMappingException;
import com.terracottatech.offheapstore.paging.PageSource;
import com.terracottatech.offheapstore.pinning.PinnableSegment;
import com.terracottatech.offheapstore.storage.StorageEngine;
import com.terracottatech.offheapstore.util.Factory;
import java.io.Serializable;
import java.util.concurrent.locks.Lock;
import net.sf.ehcache.CacheOperationOutcomes;
import net.sf.ehcache.Element;
import net.sf.ehcache.event.RegisteredEventListeners;
import net.sf.ehcache.pool.PoolAccessor;
import net.sf.ehcache.store.offheap.factories.EhcacheSegmentFactory;
import net.sf.ehcache.store.offheap.pool.OffHeapPool;
import net.sf.ehcache.store.offheap.pool.OffHeapPoolParticipant;
import net.sf.ehcache.store.offheap.pool.impl.OffHeapPoolAccessor;
import net.sf.ehcache.store.offheap.util.DelegatingPoolParticipant;
import org.terracotta.statistics.observer.OperationObserver;

public class EhcachePooledSegmentFactory
implements Factory<PinnableSegment<Serializable, Element>> {
    private final OffHeapPool pool;
    private final OffHeapPoolParticipant owner;
    private final RegisteredEventListeners evictionListener;
    private final OperationObserver<CacheOperationOutcomes.EvictionOutcome> evictionObserver;
    private final Factory<? extends StorageEngine<? super Serializable, ? super Element>> storageEngineFactory;
    private final PageSource tableSource;
    private final int tableSize;
    private volatile boolean pinningEnabled;

    public EhcachePooledSegmentFactory(OffHeapPool pool, OffHeapPoolParticipant owner, RegisteredEventListeners evictionListener, OperationObserver<CacheOperationOutcomes.EvictionOutcome> evictionObserver, PageSource source, Factory<? extends StorageEngine<? super Serializable, ? super Element>> storageEngineFactory, int initialTableSize, boolean cachePinned) {
        this.pool = pool;
        this.owner = owner;
        this.evictionListener = evictionListener;
        this.evictionObserver = evictionObserver;
        this.storageEngineFactory = storageEngineFactory;
        this.tableSource = source;
        this.tableSize = initialTableSize;
        this.pinningEnabled = cachePinned;
    }

    @Override
    public PinnableSegment<Serializable, Element> newInstance() {
        StorageEngine<? super Serializable, ? super Element> storageEngine = this.storageEngineFactory.newInstance();
        try {
            return new NotifyingEhcachePooledSegment(this.pool, this.owner, this.evictionListener, this.evictionObserver, this.tableSource, storageEngine, this.tableSize, this.pinningEnabled);
        }
        catch (RuntimeException e) {
            storageEngine.destroy();
            throw e;
        }
    }

    static class NotifyingEhcachePooledSegment
    extends EhcacheSegmentFactory.EhcacheSegment {
        private final RegisteredEventListeners evictionListener;
        private final OperationObserver<CacheOperationOutcomes.EvictionOutcome> evictionObserver;
        private final LocalPoolParticipant localPoolParticipant;
        private final PoolAccessor<OffHeapPoolParticipant> poolAccessor;
        private final OffHeapPool pool;

        NotifyingEhcachePooledSegment(OffHeapPool pool, OffHeapPoolParticipant owner, RegisteredEventListeners evictionListener, OperationObserver<CacheOperationOutcomes.EvictionOutcome> evictionObserver, PageSource source, StorageEngine<? super Serializable, ? super Element> storageEngine, int tableSize, boolean pinningEnabled) {
            super(source, storageEngine, tableSize, pinningEnabled);
            this.pool = pool;
            this.localPoolParticipant = new LocalPoolParticipant(owner);
            this.poolAccessor = new OffHeapPoolAccessor(this.localPoolParticipant);
            this.evictionListener = evictionListener;
            this.evictionObserver = evictionObserver;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean evict(int index, boolean shrink) {
            boolean evicted;
            if (this.cachePinned) {
                throw new OutOfMemoryError("cannot evict pinned cache");
            }
            Element e = (Element)this.getAtTableOffset(index);
            Lock lock = this.writeLock();
            lock.lock();
            try {
                evicted = super.evict(index, shrink);
                if (evicted) {
                    this.evictionListener.notifyElementRemovedOrdered(e);
                }
            }
            finally {
                lock.unlock();
            }
            if (evicted) {
                if (this.evictionListener.hasCacheEventListeners()) {
                    if (e.isExpired()) {
                        this.evictionListener.notifyElementExpiry(e, false);
                    } else {
                        this.evictionListener.notifyElementEvicted(e, false);
                        if (this.evictionObserver != null) {
                            this.evictionObserver.begin();
                            this.evictionObserver.end(CacheOperationOutcomes.EvictionOutcome.SUCCESS);
                        }
                    }
                } else if (this.evictionObserver != null) {
                    this.evictionObserver.begin();
                    this.evictionObserver.end(CacheOperationOutcomes.EvictionOutcome.SUCCESS);
                }
            }
            return evicted;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void storageEngineFailure(Object failure) {
            if (this.cachePinned) {
                StringBuilder sb = new StringBuilder("Storage Engine and Eviction Failed.\n");
                sb.append("Cache pinned : ").append(this.cachePinned).append("\n");
                sb.append("Storage Engine : ").append(this.storageEngine);
                throw new OutOfMemoryError(sb.toString());
            }
            this.localPoolParticipant.setContext(failure);
            try {
                if (!this.pool.getEvictor().freeSpace(this.poolAccessor, this.pool.getPoolAccessors(), -1L)) {
                    throw new OversizeMappingException();
                }
            }
            finally {
                this.localPoolParticipant.clearContext();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Element put(Serializable key, Element value, int metadata) {
            Lock lock = this.writeLock();
            lock.lock();
            try {
                Element oldElement = super.put(key, value, metadata);
                if (oldElement != null) {
                    this.evictionListener.notifyElementRemovedOrdered(oldElement);
                }
                this.evictionListener.notifyElementPutOrdered(value);
                Element element = oldElement;
                return element;
            }
            finally {
                lock.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Element remove(Object key) {
            Lock lock = this.writeLock();
            lock.lock();
            try {
                Element oldElement = (Element)super.remove(key);
                if (oldElement != null) {
                    this.evictionListener.notifyElementRemovedOrdered(oldElement);
                }
                Element element = oldElement;
                return element;
            }
            finally {
                lock.unlock();
            }
        }

        class LocalPoolParticipant
        extends DelegatingPoolParticipant
        implements OffHeapPoolParticipant {
            private Object failure;

            public LocalPoolParticipant(OffHeapPoolParticipant delegate) {
                super(delegate);
            }

            @Override
            public boolean evict(int count, long bytes) {
                try {
                    NotifyingEhcachePooledSegment.super.storageEngineFailure(this.failure);
                    return true;
                }
                catch (OversizeMappingException e) {
                    return false;
                }
            }

            public void setContext(Object failure) {
                this.failure = failure;
            }

            public void clearContext() {
                this.failure = null;
            }
        }
    }
}

