/*
 * Decompiled with CFR 0.152.
 */
package net.sf.ehcache.store.offheap.disk;

import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.util.EnumSet;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import net.sf.ehcache.CacheEntry;
import net.sf.ehcache.CacheException;
import net.sf.ehcache.Ehcache;
import net.sf.ehcache.Element;
import net.sf.ehcache.Status;
import net.sf.ehcache.concurrent.CacheLockProvider;
import net.sf.ehcache.concurrent.ReadWriteLockSync;
import net.sf.ehcache.concurrent.Sync;
import net.sf.ehcache.config.CacheConfiguration;
import net.sf.ehcache.config.PinningConfiguration;
import net.sf.ehcache.config.SizeOfPolicyConfiguration;
import net.sf.ehcache.event.RegisteredEventListeners;
import net.sf.ehcache.pool.Pool;
import net.sf.ehcache.pool.PoolAccessor;
import net.sf.ehcache.pool.PoolParticipant;
import net.sf.ehcache.pool.impl.UnboundedPool;
import net.sf.ehcache.statistics.StatisticBuilder;
import net.sf.ehcache.store.AbstractStore;
import net.sf.ehcache.store.AuthoritativeTier;
import net.sf.ehcache.store.ElementValueComparator;
import net.sf.ehcache.store.Policy;
import net.sf.ehcache.store.Store;
import net.sf.ehcache.store.StoreOperationOutcomes;
import net.sf.ehcache.store.offheap.disk.EhcachePersistentConcurrentOffHeapClockCache;
import net.sf.ehcache.store.offheap.disk.OffHeapDiskStorePoolAccessor;
import net.sf.ehcache.store.offheap.search.LuceneIndexedSearchManager;
import net.sf.ehcache.util.SetAsList;
import net.sf.ehcache.writer.CacheWriterManager;
import org.terracotta.statistics.OperationStatistic;
import org.terracotta.statistics.Statistic;
import org.terracotta.statistics.StatisticsManager;
import org.terracotta.statistics.derived.EventRateSimpleMovingAverage;
import org.terracotta.statistics.derived.OperationResultFilter;
import org.terracotta.statistics.observer.OperationObserver;

public class OffHeapDiskStore
extends AbstractStore
implements AuthoritativeTier,
Store {
    protected final File dataFile;
    protected final EhcachePersistentConcurrentOffHeapClockCache map;
    private final RegisteredEventListeners eventService;
    protected final AtomicReference<Status> status = new AtomicReference<Status>(Status.STATUS_UNINITIALISED);
    protected final PoolAccessor onDiskPoolAccessor;
    private final PoolParticipant participant;
    private CacheLockProvider lockProvider;
    private final CacheConfiguration config;
    private volatile boolean cachePinned;
    private OperationObserver<StoreOperationOutcomes.GetOutcome> getOperationObserver = ((StatisticBuilder.OperationStatisticBuilder)((StatisticBuilder.OperationStatisticBuilder)((StatisticBuilder.OperationStatisticBuilder)StatisticBuilder.operation(StoreOperationOutcomes.GetOutcome.class).of(this)).named("get")).tag("local-disk")).build();
    private OperationObserver<StoreOperationOutcomes.PutOutcome> putOperationObserver = ((StatisticBuilder.OperationStatisticBuilder)((StatisticBuilder.OperationStatisticBuilder)((StatisticBuilder.OperationStatisticBuilder)StatisticBuilder.operation(StoreOperationOutcomes.PutOutcome.class).of(this)).named("put")).tag("local-disk")).build();
    private OperationObserver<StoreOperationOutcomes.RemoveOutcome> removeOperationObserver = ((StatisticBuilder.OperationStatisticBuilder)((StatisticBuilder.OperationStatisticBuilder)((StatisticBuilder.OperationStatisticBuilder)StatisticBuilder.operation(StoreOperationOutcomes.RemoveOutcome.class).of(this)).named("remove")).tag("local-disk")).build();

    public OffHeapDiskStore(File dataFile, EhcachePersistentConcurrentOffHeapClockCache map, RegisteredEventListeners eventService, Pool onDiskPool, Ehcache cache, LuceneIndexedSearchManager searchManager) {
        super(searchManager);
        this.dataFile = dataFile;
        this.map = map;
        this.eventService = eventService;
        this.participant = new Participant();
        if (onDiskPool instanceof UnboundedPool) {
            this.onDiskPoolAccessor = onDiskPool.createPoolAccessor(this.participant, SizeOfPolicyConfiguration.resolveMaxDepth(cache), SizeOfPolicyConfiguration.resolveBehavior(cache).equals((Object)SizeOfPolicyConfiguration.MaxDepthExceededBehavior.ABORT));
        } else {
            this.onDiskPoolAccessor = new OffHeapDiskStorePoolAccessor(onDiskPool, this.participant, this);
            onDiskPool.registerPoolAccessor(this.onDiskPoolAccessor);
        }
        this.config = cache.getCacheConfiguration();
        if (!this.status.compareAndSet(Status.STATUS_UNINITIALISED, Status.STATUS_ALIVE)) {
            throw new AssertionError();
        }
        this.cachePinned = this.determineCachePinned(cache.getCacheConfiguration());
    }

    private boolean determineCachePinned(CacheConfiguration cacheConfiguration) {
        PinningConfiguration pinningConfiguration = cacheConfiguration.getPinningConfiguration();
        if (pinningConfiguration == null) {
            return false;
        }
        switch (pinningConfiguration.getStore()) {
            case LOCALMEMORY: {
                return false;
            }
            case INCACHE: {
                return cacheConfiguration.isOverflowToDisk();
            }
        }
        throw new IllegalArgumentException();
    }

    private boolean isPinned(Object key) {
        return false;
    }

    @Override
    public boolean put(Element element) throws CacheException {
        if (element == null) {
            return false;
        }
        this.putOperationObserver.begin();
        if (this.onDiskPoolAccessor.add(element.getObjectKey(), element.getObjectValue(), element, this.cachePinned) > -1L) {
            if (this.map.put(element.getKey(), element) == null) {
                this.putOperationObserver.end(StoreOperationOutcomes.PutOutcome.ADDED);
                return true;
            }
            this.putOperationObserver.end(StoreOperationOutcomes.PutOutcome.UPDATED);
            return false;
        }
        this.map.remove(element.getObjectKey());
        this.eventService.notifyElementEvicted(element, false);
        this.putOperationObserver.end(StoreOperationOutcomes.PutOutcome.ADDED);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean putWithWriter(Element element, CacheWriterManager writerManager) {
        ReentrantReadWriteLock.WriteLock lock = this.map.getLock(element.getObjectKey()).writeLock();
        lock.lock();
        try {
            boolean result = this.put(element);
            if (writerManager != null) {
                writerManager.put(element);
            }
            boolean bl = result;
            return bl;
        }
        finally {
            lock.unlock();
        }
    }

    @Override
    public Element get(Object key) {
        this.getOperationObserver.begin();
        if (key == null) {
            this.getOperationObserver.end(StoreOperationOutcomes.GetOutcome.MISS);
            return null;
        }
        Element result = (Element)this.map.get(key);
        if (result == null) {
            this.getOperationObserver.end(StoreOperationOutcomes.GetOutcome.MISS);
        } else {
            this.getOperationObserver.end(StoreOperationOutcomes.GetOutcome.HIT);
        }
        return result;
    }

    @Override
    public Element getQuiet(Object key) {
        return this.get(key);
    }

    @Override
    public List<?> getKeys() {
        return new SetAsList(this.map.keySet());
    }

    @Override
    public Element remove(Object key) {
        if (key == null) {
            return null;
        }
        this.removeOperationObserver.begin();
        Element removedElement = (Element)this.map.remove(key);
        if (removedElement != null) {
            this.onDiskPoolAccessor.delete(0L);
        }
        this.removeOperationObserver.end(StoreOperationOutcomes.RemoveOutcome.SUCCESS);
        return removedElement;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Element removeWithWriter(Object key, CacheWriterManager writerManager) throws CacheException {
        ReentrantReadWriteLock.WriteLock lock = this.map.getLock(key).writeLock();
        lock.lock();
        try {
            Element removed = this.remove(key);
            if (writerManager != null) {
                writerManager.remove(new CacheEntry(key, removed));
            }
            Element element = removed;
            return element;
        }
        finally {
            lock.unlock();
        }
    }

    @Override
    public void removeAll() throws CacheException {
        this.map.clear();
        this.onDiskPoolAccessor.clear();
    }

    @Override
    public Element putIfAbsent(Element element) throws NullPointerException {
        if (this.onDiskPoolAccessor.add(element.getObjectKey(), element.getObjectValue(), element, this.cachePinned) > -1L) {
            Element oldElement = this.map.putIfAbsent(element.getKey(), element);
            if (oldElement != null) {
                this.onDiskPoolAccessor.delete(0L);
            }
            return oldElement;
        }
        this.eventService.notifyElementEvicted(element, false);
        return element;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Element removeElement(Element element, ElementValueComparator comparator) throws NullPointerException {
        Object key = element.getObjectKey();
        ReentrantReadWriteLock.WriteLock l = this.map.getLock(key).writeLock();
        l.lock();
        try {
            Element value = (Element)this.map.get(key);
            if (this.map.remove(key, element, comparator)) {
                this.onDiskPoolAccessor.delete(0L);
                Element element2 = value;
                return element2;
            }
            Element element3 = null;
            return element3;
        }
        finally {
            l.unlock();
        }
    }

    @Override
    public boolean replace(Element old, Element element, ElementValueComparator comparator) throws NullPointerException, IllegalArgumentException {
        if (this.onDiskPoolAccessor.add(element.getObjectKey(), element.getObjectValue(), element, this.cachePinned) > -1L) {
            boolean replaced = this.map.replace(element.getKey(), old, element, comparator);
            if (!replaced) {
                this.onDiskPoolAccessor.delete(0L);
            }
            return replaced;
        }
        this.eventService.notifyElementEvicted(element, false);
        return false;
    }

    @Override
    public Element replace(Element element) throws NullPointerException {
        if (this.onDiskPoolAccessor.add(element.getObjectKey(), element.getObjectValue(), element, this.cachePinned) > -1L) {
            Element oldElement = this.map.replace(element.getKey(), element);
            if (oldElement == null) {
                this.onDiskPoolAccessor.delete(0L);
            }
            return oldElement;
        }
        this.eventService.notifyElementEvicted(element, false);
        return null;
    }

    @Override
    public void dispose() {
        if (this.status.compareAndSet(Status.STATUS_ALIVE, Status.STATUS_SHUTDOWN)) {
            try {
                this.map.close();
                this.dataFile.delete();
                this.onDiskPoolAccessor.unlink();
            }
            catch (IOException e) {
                throw new CacheException("Failed to cleanly dispose the disk store", e);
            }
        }
    }

    @Override
    @Statistic(name="size", tags={"local-disk"})
    public int getSize() {
        return this.map.size();
    }

    @Override
    public int getInMemorySize() {
        return 0;
    }

    @Override
    public int getOffHeapSize() {
        return 0;
    }

    @Override
    public int getOnDiskSize() {
        return this.getSize();
    }

    @Override
    public int getTerracottaClusteredSize() {
        return 0;
    }

    @Override
    public long getInMemorySizeInBytes() {
        return 0L;
    }

    @Override
    public long getOffHeapSizeInBytes() {
        return 0L;
    }

    public long getOccupiedMemory() {
        return this.map.getOccupiedMemory();
    }

    @Override
    @Statistic(name="size-in-bytes", tags={"local-disk"})
    public long getOnDiskSizeInBytes() {
        if (this.onDiskPoolAccessor.getSize() < 0L) {
            return this.map.getOccupiedMemory();
        }
        return this.onDiskPoolAccessor.getSize();
    }

    @Override
    public Status getStatus() {
        return this.status.get();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.map.containsKey(key);
    }

    @Override
    public boolean containsKeyOnDisk(Object key) {
        return this.containsKey(key);
    }

    @Override
    public boolean containsKeyOffHeap(Object key) {
        return false;
    }

    @Override
    public boolean containsKeyInMemory(Object key) {
        return false;
    }

    @Override
    public void expireElements() {
        for (Serializable key : this.map.keySet()) {
            Element value = this.get(key);
            if (!value.isExpired() || !this.map.remove(key, value)) continue;
            this.onDiskPoolAccessor.delete(0L);
            this.eventService.notifyElementExpiry(value, false);
        }
    }

    @Override
    public void flush() throws IOException {
    }

    @Override
    public boolean bufferFull() {
        return this.map.bufferFull();
    }

    @Override
    public Policy getInMemoryEvictionPolicy() {
        return null;
    }

    @Override
    public void setInMemoryEvictionPolicy(Policy policy) {
    }

    @Override
    public Object getInternalContext() {
        CacheLockProvider lp = this.lockProvider;
        return lp == null ? (this.lockProvider = new LockProvider()) : lp;
    }

    @Override
    public Object getMBean() {
        return null;
    }

    @Override
    public Element fault(Object key, boolean updateStats) {
        this.getOperationObserver.begin();
        if (key instanceof Serializable) {
            Element e = this.map.getAndPin((Serializable)key);
            if (e == null) {
                this.getOperationObserver.end(StoreOperationOutcomes.GetOutcome.MISS);
            } else {
                this.getOperationObserver.end(StoreOperationOutcomes.GetOutcome.HIT);
            }
            return e;
        }
        this.getOperationObserver.end(StoreOperationOutcomes.GetOutcome.MISS);
        return null;
    }

    @Override
    public boolean putFaulted(Element element) {
        if (element == null) {
            return false;
        }
        this.putOperationObserver.begin();
        if (this.onDiskPoolAccessor.add(element.getObjectKey(), element.getObjectValue(), element, this.cachePinned) > -1L) {
            if (this.map.put(element.getKey(), element, 0x40000000) == null) {
                this.putOperationObserver.end(StoreOperationOutcomes.PutOutcome.ADDED);
                return true;
            }
            this.putOperationObserver.end(StoreOperationOutcomes.PutOutcome.UPDATED);
            return false;
        }
        this.map.remove(element.getObjectKey());
        this.eventService.notifyElementEvicted(element, false);
        this.putOperationObserver.end(StoreOperationOutcomes.PutOutcome.ADDED);
        return true;
    }

    @Override
    public boolean flush(Element element) {
        return this.map.updateMetadata(element.getKey(), 0x40000000, 0);
    }

    public boolean isFaulted(Object key) {
        return this.map.isPinned(key);
    }

    class Participant
    implements PoolParticipant {
        private final EventRateSimpleMovingAverage hitRate = new EventRateSimpleMovingAverage(1L, TimeUnit.SECONDS);
        private final EventRateSimpleMovingAverage missRate = new EventRateSimpleMovingAverage(1L, TimeUnit.SECONDS);

        Participant() {
            OperationStatistic<OperationResultFilter<StoreOperationOutcomes.GetOutcome>> getStatistic = StatisticsManager.getOperationStatisticFor(OffHeapDiskStore.this.getOperationObserver);
            getStatistic.addDerivedStatistic(new OperationResultFilter<StoreOperationOutcomes.GetOutcome>(EnumSet.of(StoreOperationOutcomes.GetOutcome.HIT), this.hitRate));
            getStatistic.addDerivedStatistic(new OperationResultFilter<StoreOperationOutcomes.GetOutcome>(EnumSet.of(StoreOperationOutcomes.GetOutcome.MISS), this.missRate));
        }

        @Override
        public boolean evict(int count, long size) {
            if (OffHeapDiskStore.this.cachePinned) {
                return false;
            }
            for (int i = 0; i < count; ++i) {
                Element evicted = OffHeapDiskStore.this.map.evictOne();
                if (evicted == null) {
                    return false;
                }
                OffHeapDiskStore.this.onDiskPoolAccessor.delete(0L);
            }
            return true;
        }

        @Override
        public float getApproximateHitRate() {
            return this.hitRate.rate(TimeUnit.SECONDS).floatValue();
        }

        @Override
        public float getApproximateMissRate() {
            return this.missRate.rate(TimeUnit.SECONDS).floatValue();
        }

        @Override
        public long getApproximateCountSize() {
            return OffHeapDiskStore.this.map.getSize();
        }
    }

    class LockProvider
    implements CacheLockProvider {
        LockProvider() {
        }

        @Override
        public Sync getSyncForKey(Object key) {
            return new ReadWriteLockSync(OffHeapDiskStore.this.map.getLock(key));
        }
    }
}

