/*
 * Decompiled with CFR 0.152.
 */
package net.sf.ehcache.store.offheap.cachingtier;

import com.terracottatech.offheapstore.AbstractOffHeapClockCache;
import com.terracottatech.offheapstore.eviction.EvictionListeningReadWriteLockedOffHeapClockCache;
import com.terracottatech.offheapstore.exceptions.OversizeMappingException;
import com.terracottatech.offheapstore.paging.PageSource;
import com.terracottatech.offheapstore.storage.OffHeapBufferStorageEngine;
import com.terracottatech.offheapstore.util.Factory;
import java.io.Serializable;
import net.sf.ehcache.Element;
import net.sf.ehcache.pool.PoolAccessor;
import net.sf.ehcache.store.offheap.cachingtier.CachingTierEvictionListener;
import net.sf.ehcache.store.offheap.pool.OffHeapPool;
import net.sf.ehcache.store.offheap.pool.OffHeapPoolParticipant;
import net.sf.ehcache.store.offheap.pool.impl.OffHeapPoolAccessor;
import net.sf.ehcache.store.offheap.util.DelegatingPoolParticipant;

public class CachingTierPooledSegmentFactory
implements Factory<AbstractOffHeapClockCache<Serializable, Element>> {
    private final PageSource tableSource;
    private final Factory<OffHeapBufferStorageEngine<Serializable, Element>> storageEngineFactory;
    private final CachingTierEvictionListener<Serializable, Element> cachingTierEvictionListener;
    private final int tableSize;
    private final OffHeapPool pool;
    private final OffHeapPoolParticipant poolParticipant;

    public CachingTierPooledSegmentFactory(PageSource tableSource, Factory<OffHeapBufferStorageEngine<Serializable, Element>> storageEngineFactory, CachingTierEvictionListener<Serializable, Element> cachingTierEvictionListener, int initialSegmentTableSize, OffHeapPoolParticipant poolParticipant, OffHeapPool pool) {
        this.tableSource = tableSource;
        this.storageEngineFactory = storageEngineFactory;
        this.cachingTierEvictionListener = cachingTierEvictionListener;
        this.tableSize = initialSegmentTableSize;
        this.poolParticipant = poolParticipant;
        this.pool = pool;
    }

    @Override
    public AbstractOffHeapClockCache<Serializable, Element> newInstance() {
        OffHeapBufferStorageEngine<Serializable, Element> storageEngine = this.storageEngineFactory.newInstance();
        try {
            return new CachingTierPooledSegment(this.cachingTierEvictionListener, this.tableSource, storageEngine, this.tableSize, this.poolParticipant, this.pool);
        }
        catch (RuntimeException e) {
            storageEngine.destroy();
            throw e;
        }
    }

    private class CachingTierPooledSegment
    extends EvictionListeningReadWriteLockedOffHeapClockCache<Serializable, Element> {
        private final LocalPoolParticipant localPoolParticipant;
        private final PoolAccessor<OffHeapPoolParticipant> poolAccessor;
        private final OffHeapPool pool;

        public CachingTierPooledSegment(CachingTierEvictionListener<Serializable, Element> cachingTierEvictionListener, PageSource tableSource, OffHeapBufferStorageEngine<Serializable, Element> storageEngine, int tableSize, OffHeapPoolParticipant owner, OffHeapPool pool) {
            super(cachingTierEvictionListener, tableSource, storageEngine, tableSize);
            this.localPoolParticipant = new LocalPoolParticipant(owner);
            this.poolAccessor = new OffHeapPoolAccessor(this.localPoolParticipant);
            this.pool = pool;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void storageEngineFailure(Object failure) {
            this.localPoolParticipant.setContext(failure);
            try {
                if (!this.pool.getEvictor().freeSpace(this.poolAccessor, this.pool.getPoolAccessors(), -1L)) {
                    throw new OversizeMappingException();
                }
            }
            finally {
                this.localPoolParticipant.clearContext();
            }
        }

        class LocalPoolParticipant
        extends DelegatingPoolParticipant
        implements OffHeapPoolParticipant {
            private Object failure;

            public LocalPoolParticipant(OffHeapPoolParticipant delegate) {
                super(delegate);
            }

            @Override
            public boolean evict(int count, long bytes) {
                try {
                    CachingTierPooledSegment.super.storageEngineFailure(this.failure);
                    return true;
                }
                catch (OversizeMappingException e) {
                    return false;
                }
            }

            public void setContext(Object failure) {
                this.failure = failure;
            }

            public void clearContext() {
                this.failure = null;
            }
        }
    }
}

