/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.shaded.lucene.index;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.terracotta.shaded.lucene.codecs.Codec;
import org.terracotta.shaded.lucene.codecs.FieldInfosWriter;
import org.terracotta.shaded.lucene.codecs.FieldsConsumer;
import org.terracotta.shaded.lucene.codecs.PerDocConsumer;
import org.terracotta.shaded.lucene.codecs.StoredFieldsWriter;
import org.terracotta.shaded.lucene.codecs.TermVectorsWriter;
import org.terracotta.shaded.lucene.index.AtomicReader;
import org.terracotta.shaded.lucene.index.AtomicReaderContext;
import org.terracotta.shaded.lucene.index.DocValues;
import org.terracotta.shaded.lucene.index.FieldInfo;
import org.terracotta.shaded.lucene.index.FieldInfos;
import org.terracotta.shaded.lucene.index.Fields;
import org.terracotta.shaded.lucene.index.IndexReader;
import org.terracotta.shaded.lucene.index.MergeState;
import org.terracotta.shaded.lucene.index.MultiFields;
import org.terracotta.shaded.lucene.index.PerDocWriteState;
import org.terracotta.shaded.lucene.index.ReaderSlice;
import org.terracotta.shaded.lucene.index.SegmentInfo;
import org.terracotta.shaded.lucene.index.SegmentReader;
import org.terracotta.shaded.lucene.index.SegmentWriteState;
import org.terracotta.shaded.lucene.index.TypePromoter;
import org.terracotta.shaded.lucene.store.Directory;
import org.terracotta.shaded.lucene.store.IOContext;
import org.terracotta.shaded.lucene.util.IOUtils;
import org.terracotta.shaded.lucene.util.InfoStream;

final class SegmentMerger {
    private final Directory directory;
    private final int termIndexInterval;
    private final Codec codec;
    private final IOContext context;
    private final MergeState mergeState = new MergeState();
    private final FieldInfos.Builder fieldInfosBuilder;

    SegmentMerger(SegmentInfo segmentInfo, InfoStream infoStream, Directory dir, int termIndexInterval, MergeState.CheckAbort checkAbort, FieldInfos.FieldNumbers fieldNumbers, IOContext context) {
        this.mergeState.segmentInfo = segmentInfo;
        this.mergeState.infoStream = infoStream;
        this.mergeState.readers = new ArrayList<AtomicReader>();
        this.mergeState.checkAbort = checkAbort;
        this.directory = dir;
        this.termIndexInterval = termIndexInterval;
        this.codec = segmentInfo.getCodec();
        this.context = context;
        this.fieldInfosBuilder = new FieldInfos.Builder(fieldNumbers);
    }

    final void add(IndexReader reader) {
        for (AtomicReaderContext ctx : reader.leaves()) {
            AtomicReader r = ctx.reader();
            this.mergeState.readers.add(r);
        }
    }

    final void add(SegmentReader reader) {
        this.mergeState.readers.add(reader);
    }

    final MergeState merge() throws IOException {
        this.mergeState.segmentInfo.setDocCount(this.setDocMaps());
        this.mergeDocValuesAndNormsFieldInfos();
        this.setMatchingSegmentReaders();
        int numMerged = this.mergeFields();
        assert (numMerged == this.mergeState.segmentInfo.getDocCount());
        SegmentWriteState segmentWriteState = new SegmentWriteState(this.mergeState.infoStream, this.directory, this.mergeState.segmentInfo, this.mergeState.fieldInfos, this.termIndexInterval, null, this.context);
        this.mergeTerms(segmentWriteState);
        this.mergePerDoc(segmentWriteState);
        if (this.mergeState.fieldInfos.hasNorms()) {
            this.mergeNorms(segmentWriteState);
        }
        if (this.mergeState.fieldInfos.hasVectors()) {
            numMerged = this.mergeVectors();
            assert (numMerged == this.mergeState.segmentInfo.getDocCount());
        }
        FieldInfosWriter fieldInfosWriter = this.codec.fieldInfosFormat().getFieldInfosWriter();
        fieldInfosWriter.write(this.directory, this.mergeState.segmentInfo.name, this.mergeState.fieldInfos, this.context);
        return this.mergeState;
    }

    private void setMatchingSegmentReaders() {
        int numReaders = this.mergeState.readers.size();
        this.mergeState.matchingSegmentReaders = new SegmentReader[numReaders];
        for (int i = 0; i < numReaders; ++i) {
            AtomicReader reader = this.mergeState.readers.get(i);
            if (!(reader instanceof SegmentReader)) continue;
            SegmentReader segmentReader = (SegmentReader)reader;
            boolean same = true;
            FieldInfos segmentFieldInfos = segmentReader.getFieldInfos();
            for (FieldInfo fi : segmentFieldInfos) {
                FieldInfo other = this.mergeState.fieldInfos.fieldInfo(fi.number);
                if (other != null && other.name.equals(fi.name)) continue;
                same = false;
                break;
            }
            if (!same) continue;
            this.mergeState.matchingSegmentReaders[i] = segmentReader;
            ++this.mergeState.matchedCount;
        }
        if (this.mergeState.infoStream.isEnabled("SM")) {
            this.mergeState.infoStream.message("SM", "merge store matchedCount=" + this.mergeState.matchedCount + " vs " + this.mergeState.readers.size());
            if (this.mergeState.matchedCount != this.mergeState.readers.size()) {
                this.mergeState.infoStream.message("SM", "" + (this.mergeState.readers.size() - this.mergeState.matchedCount) + " non-bulk merges");
            }
        }
    }

    private TypePromoter mergeDocValuesType(TypePromoter previous, DocValues docValues) {
        TypePromoter incoming = TypePromoter.create(docValues.getType(), docValues.getValueSize());
        if (previous == null) {
            previous = TypePromoter.getIdentityPromoter();
        }
        return previous.promote(incoming);
    }

    public void mergeDocValuesAndNormsFieldInfos() throws IOException {
        HashMap<FieldInfo, TypePromoter> docValuesTypes = new HashMap<FieldInfo, TypePromoter>();
        HashMap<FieldInfo, TypePromoter> normValuesTypes = new HashMap<FieldInfo, TypePromoter>();
        for (AtomicReader reader : this.mergeState.readers) {
            FieldInfos readerFieldInfos = reader.getFieldInfos();
            for (FieldInfo fi : readerFieldInfos) {
                TypePromoter previous;
                FieldInfo merged = this.fieldInfosBuilder.add(fi);
                if (fi.hasDocValues()) {
                    previous = (TypePromoter)docValuesTypes.get(merged);
                    docValuesTypes.put(merged, this.mergeDocValuesType(previous, reader.docValues(fi.name)));
                }
                if (!fi.hasNorms()) continue;
                previous = (TypePromoter)normValuesTypes.get(merged);
                normValuesTypes.put(merged, this.mergeDocValuesType(previous, reader.normValues(fi.name)));
            }
        }
        this.updatePromoted(normValuesTypes, true);
        this.updatePromoted(docValuesTypes, false);
        this.mergeState.fieldInfos = this.fieldInfosBuilder.finish();
    }

    protected void updatePromoted(Map<FieldInfo, TypePromoter> infoAndPromoter, boolean norms) {
        for (Map.Entry<FieldInfo, TypePromoter> e : infoAndPromoter.entrySet()) {
            FieldInfo fi = e.getKey();
            TypePromoter promoter = e.getValue();
            if (promoter == null) {
                if (norms) {
                    fi.setNormValueType(null);
                    continue;
                }
                fi.setDocValuesType(null);
                continue;
            }
            assert (promoter != TypePromoter.getIdentityPromoter());
            if (norms) {
                if (fi.getNormType() == promoter.type() || fi.omitsNorms()) continue;
                fi.setNormValueType(promoter.type());
                continue;
            }
            if (fi.getDocValuesType() == promoter.type()) continue;
            fi.setDocValuesType(promoter.type());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int mergeFields() throws IOException {
        StoredFieldsWriter fieldsWriter = this.codec.storedFieldsFormat().fieldsWriter(this.directory, this.mergeState.segmentInfo, this.context);
        try {
            int n = fieldsWriter.merge(this.mergeState);
            return n;
        }
        finally {
            fieldsWriter.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final int mergeVectors() throws IOException {
        TermVectorsWriter termVectorsWriter = this.codec.termVectorsFormat().vectorsWriter(this.directory, this.mergeState.segmentInfo, this.context);
        try {
            int n = termVectorsWriter.merge(this.mergeState);
            return n;
        }
        finally {
            termVectorsWriter.close();
        }
    }

    private int setDocMaps() throws IOException {
        int numReaders = this.mergeState.readers.size();
        this.mergeState.docMaps = new MergeState.DocMap[numReaders];
        this.mergeState.docBase = new int[numReaders];
        int docBase = 0;
        for (int i = 0; i < this.mergeState.readers.size(); ++i) {
            MergeState.DocMap docMap;
            AtomicReader reader = this.mergeState.readers.get(i);
            this.mergeState.docBase[i] = docBase;
            this.mergeState.docMaps[i] = docMap = MergeState.DocMap.build(reader);
            docBase += docMap.numDocs();
        }
        return docBase;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void mergeTerms(SegmentWriteState segmentWriteState) throws IOException {
        block7: {
            FieldsConsumer consumer;
            block6: {
                ArrayList<Fields> fields = new ArrayList<Fields>();
                ArrayList<ReaderSlice> slices = new ArrayList<ReaderSlice>();
                int docBase = 0;
                for (int readerIndex = 0; readerIndex < this.mergeState.readers.size(); ++readerIndex) {
                    AtomicReader reader = this.mergeState.readers.get(readerIndex);
                    Fields f = reader.fields();
                    int maxDoc = reader.maxDoc();
                    if (f != null) {
                        slices.add(new ReaderSlice(docBase, maxDoc, readerIndex));
                        fields.add(f);
                    }
                    docBase += maxDoc;
                }
                consumer = this.codec.postingsFormat().fieldsConsumer(segmentWriteState);
                boolean success = false;
                try {
                    consumer.merge(this.mergeState, new MultiFields(fields.toArray(Fields.EMPTY_ARRAY), slices.toArray(ReaderSlice.EMPTY_ARRAY)));
                    success = true;
                    if (!success) break block6;
                }
                catch (Throwable throwable) {
                    if (success) {
                        IOUtils.close(consumer);
                    } else {
                        IOUtils.closeWhileHandlingException(consumer);
                    }
                    throw throwable;
                }
                IOUtils.close(consumer);
                break block7;
            }
            IOUtils.closeWhileHandlingException(consumer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void mergePerDoc(SegmentWriteState segmentWriteState) throws IOException {
        block6: {
            PerDocConsumer docsConsumer;
            block5: {
                docsConsumer = this.codec.docValuesFormat().docsConsumer(new PerDocWriteState(segmentWriteState));
                if (docsConsumer == null) {
                    return;
                }
                boolean success = false;
                try {
                    docsConsumer.merge(this.mergeState);
                    success = true;
                    if (!success) break block5;
                }
                catch (Throwable throwable) {
                    if (success) {
                        IOUtils.close(docsConsumer);
                    } else {
                        IOUtils.closeWhileHandlingException(docsConsumer);
                    }
                    throw throwable;
                }
                IOUtils.close(docsConsumer);
                break block6;
            }
            IOUtils.closeWhileHandlingException(docsConsumer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void mergeNorms(SegmentWriteState segmentWriteState) throws IOException {
        block6: {
            PerDocConsumer docsConsumer;
            block5: {
                docsConsumer = this.codec.normsFormat().docsConsumer(new PerDocWriteState(segmentWriteState));
                if (docsConsumer == null) {
                    return;
                }
                boolean success = false;
                try {
                    docsConsumer.merge(this.mergeState);
                    success = true;
                    if (!success) break block5;
                }
                catch (Throwable throwable) {
                    if (success) {
                        IOUtils.close(docsConsumer);
                    } else {
                        IOUtils.closeWhileHandlingException(docsConsumer);
                    }
                    throw throwable;
                }
                IOUtils.close(docsConsumer);
                break block6;
            }
            IOUtils.closeWhileHandlingException(docsConsumer);
        }
    }
}

