/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.shaded.lucene.codecs.lucene40;

import java.io.IOException;
import org.terracotta.shaded.lucene.codecs.NormsFormat;
import org.terracotta.shaded.lucene.codecs.PerDocConsumer;
import org.terracotta.shaded.lucene.codecs.PerDocProducer;
import org.terracotta.shaded.lucene.codecs.lucene40.Lucene40DocValuesConsumer;
import org.terracotta.shaded.lucene.codecs.lucene40.Lucene40DocValuesProducer;
import org.terracotta.shaded.lucene.index.AtomicReader;
import org.terracotta.shaded.lucene.index.DocValues;
import org.terracotta.shaded.lucene.index.FieldInfo;
import org.terracotta.shaded.lucene.index.FieldInfos;
import org.terracotta.shaded.lucene.index.PerDocWriteState;
import org.terracotta.shaded.lucene.index.SegmentReadState;

public class Lucene40NormsFormat
extends NormsFormat {
    private static final String NORMS_SEGMENT_SUFFIX = "nrm";

    @Override
    public PerDocConsumer docsConsumer(PerDocWriteState state) throws IOException {
        return new Lucene40NormsDocValuesConsumer(state, NORMS_SEGMENT_SUFFIX);
    }

    @Override
    public PerDocProducer docsProducer(SegmentReadState state) throws IOException {
        return new Lucene40NormsDocValuesProducer(state, NORMS_SEGMENT_SUFFIX);
    }

    public static class Lucene40NormsDocValuesConsumer
    extends Lucene40DocValuesConsumer {
        public Lucene40NormsDocValuesConsumer(PerDocWriteState state, String segmentSuffix) {
            super(state, segmentSuffix);
        }

        @Override
        protected DocValues getDocValuesForMerge(AtomicReader reader, FieldInfo info) throws IOException {
            return reader.normValues(info.name);
        }

        @Override
        protected boolean canMerge(FieldInfo info) {
            return info.hasNorms();
        }

        @Override
        protected DocValues.Type getDocValuesType(FieldInfo info) {
            return info.getNormType();
        }
    }

    public static class Lucene40NormsDocValuesProducer
    extends Lucene40DocValuesProducer {
        public Lucene40NormsDocValuesProducer(SegmentReadState state, String segmentSuffix) throws IOException {
            super(state, segmentSuffix);
        }

        @Override
        protected boolean canLoad(FieldInfo info) {
            return info.hasNorms();
        }

        @Override
        protected DocValues.Type getDocValuesType(FieldInfo info) {
            return info.getNormType();
        }

        @Override
        protected boolean anyDocValuesFields(FieldInfos infos) {
            return infos.hasNorms();
        }
    }
}

