/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.util.component;

import java.util.concurrent.CopyOnWriteArrayList;
import org.eclipse.jetty.util.LazyList;
import org.eclipse.jetty.util.component.Container;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;

public class Container {
    private static final Logger LOG = Log.getLogger(Container.class);
    private final CopyOnWriteArrayList<Listener> _listeners = new CopyOnWriteArrayList();

    public void addEventListener(Listener listener) {
        this._listeners.add(listener);
    }

    public void removeEventListener(Listener listener) {
        this._listeners.remove(listener);
    }

    public void update(Object parent, Object oldChild, Object child, String relationship) {
        if (oldChild != null && !oldChild.equals(child)) {
            this.remove(parent, oldChild, relationship);
        }
        if (child != null && !child.equals(oldChild)) {
            this.add(parent, child, relationship);
        }
    }

    public void update(Object parent, Object oldChild, Object child, String relationship, boolean addRemove) {
        if (oldChild != null && !oldChild.equals(child)) {
            this.remove(parent, oldChild, relationship);
            if (addRemove) {
                this.removeBean(oldChild);
            }
        }
        if (child != null && !child.equals(oldChild)) {
            if (addRemove) {
                this.addBean(child);
            }
            this.add(parent, child, relationship);
        }
    }

    public void update(Object parent, Object[] oldChildren, Object[] children, String relationship) {
        this.update(parent, oldChildren, children, relationship, false);
    }

    public void update(Object parent, Object[] oldChildren, Object[] children, String relationship, boolean addRemove) {
        int i;
        Object[] newChildren = null;
        if (children != null) {
            newChildren = new Object[children.length];
            i = children.length;
            while (i-- > 0) {
                boolean new_child = true;
                if (oldChildren != null) {
                    int j = oldChildren.length;
                    while (j-- > 0) {
                        if (children[i] == null || !children[i].equals(oldChildren[j])) continue;
                        oldChildren[j] = null;
                        new_child = false;
                    }
                }
                if (!new_child) continue;
                newChildren[i] = children[i];
            }
        }
        if (oldChildren != null) {
            i = oldChildren.length;
            while (i-- > 0) {
                if (oldChildren[i] == null) continue;
                this.remove(parent, oldChildren[i], relationship);
                if (!addRemove) continue;
                this.removeBean(oldChildren[i]);
            }
        }
        if (newChildren != null) {
            for (i = 0; i < newChildren.length; ++i) {
                if (newChildren[i] == null) continue;
                if (addRemove) {
                    this.addBean(newChildren[i]);
                }
                this.add(parent, newChildren[i], relationship);
            }
        }
    }

    public void addBean(Object obj) {
        if (this._listeners != null) {
            for (int i = 0; i < LazyList.size((Object)this._listeners); ++i) {
                Listener listener = (Listener)LazyList.get((Object)this._listeners, (int)i);
                listener.addBean(obj);
            }
        }
    }

    public void removeBean(Object obj) {
        if (this._listeners != null) {
            for (int i = 0; i < LazyList.size((Object)this._listeners); ++i) {
                ((Listener)LazyList.get((Object)this._listeners, (int)i)).removeBean(obj);
            }
        }
    }

    private void add(Object parent, Object child, String relationship) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Container " + parent + " + " + child + " as " + relationship, new Object[0]);
        }
        if (this._listeners != null) {
            Relationship event = new Relationship(this, parent, child, relationship, null);
            for (int i = 0; i < LazyList.size((Object)this._listeners); ++i) {
                ((Listener)LazyList.get((Object)this._listeners, (int)i)).add(event);
            }
        }
    }

    private void remove(Object parent, Object child, String relationship) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Container " + parent + " - " + child + " as " + relationship, new Object[0]);
        }
        if (this._listeners != null) {
            Relationship event = new Relationship(this, parent, child, relationship, null);
            for (int i = 0; i < LazyList.size((Object)this._listeners); ++i) {
                ((Listener)LazyList.get((Object)this._listeners, (int)i)).remove(event);
            }
        }
    }
}

