/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.util.component;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.eclipse.jetty.util.component.AbstractLifeCycle;
import org.eclipse.jetty.util.component.AggregateLifeCycle;
import org.eclipse.jetty.util.component.Destroyable;
import org.eclipse.jetty.util.component.Dumpable;
import org.eclipse.jetty.util.component.LifeCycle;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 * Exception performing whole class analysis ignored.
 */
public class AggregateLifeCycle
extends AbstractLifeCycle
implements Destroyable,
Dumpable {
    private static final Logger LOG = Log.getLogger(AggregateLifeCycle.class);
    private final List<Bean> _beans = new CopyOnWriteArrayList();
    private boolean _started = false;

    protected void doStart() throws Exception {
        for (Bean b : this._beans) {
            LifeCycle l;
            if (!b._managed || !(b._bean instanceof LifeCycle) || (l = (LifeCycle)b._bean).isRunning()) continue;
            l.start();
        }
        this._started = true;
        super.doStart();
    }

    protected void doStop() throws Exception {
        this._started = false;
        super.doStop();
        ArrayList reverse = new ArrayList(this._beans);
        Collections.reverse(reverse);
        for (Bean b : reverse) {
            LifeCycle l;
            if (!b._managed || !(b._bean instanceof LifeCycle) || !(l = (LifeCycle)b._bean).isRunning()) continue;
            l.stop();
        }
    }

    public void destroy() {
        ArrayList reverse = new ArrayList(this._beans);
        Collections.reverse(reverse);
        for (Bean b : reverse) {
            if (!(b._bean instanceof Destroyable) || !b._managed) continue;
            Destroyable d = (Destroyable)b._bean;
            d.destroy();
        }
        this._beans.clear();
    }

    public boolean contains(Object bean) {
        for (Bean b : this._beans) {
            if (b._bean != bean) continue;
            return true;
        }
        return false;
    }

    public boolean isManaged(Object bean) {
        for (Bean b : this._beans) {
            if (b._bean != bean) continue;
            return b._managed;
        }
        return false;
    }

    public boolean addBean(Object o) {
        return this.addBean(o, !(o instanceof LifeCycle) || !((LifeCycle)o).isStarted());
    }

    public boolean addBean(Object o, boolean managed) {
        if (this.contains(o)) {
            return false;
        }
        Bean b = new Bean(this, o);
        b._managed = managed;
        this._beans.add(b);
        if (o instanceof LifeCycle) {
            LifeCycle l = (LifeCycle)o;
            if (managed && this._started) {
                try {
                    l.start();
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
        }
        return true;
    }

    public void manage(Object bean) {
        for (Bean b : this._beans) {
            if (b._bean != bean) continue;
            b._managed = true;
            return;
        }
        throw new IllegalArgumentException();
    }

    public void unmanage(Object bean) {
        for (Bean b : this._beans) {
            if (b._bean != bean) continue;
            b._managed = false;
            return;
        }
        throw new IllegalArgumentException();
    }

    public Collection<Object> getBeans() {
        return this.getBeans(Object.class);
    }

    public <T> List<T> getBeans(Class<T> clazz) {
        ArrayList<Object> beans = new ArrayList<Object>();
        for (Bean b : this._beans) {
            if (!clazz.isInstance(b._bean)) continue;
            beans.add(b._bean);
        }
        return beans;
    }

    public <T> T getBean(Class<T> clazz) {
        for (Bean b : this._beans) {
            if (!clazz.isInstance(b._bean)) continue;
            return (T)b._bean;
        }
        return null;
    }

    public void removeBeans() {
        this._beans.clear();
    }

    public boolean removeBean(Object o) {
        for (Bean b : this._beans) {
            if (b._bean != o) continue;
            this._beans.remove(b);
            return true;
        }
        return false;
    }

    public void dumpStdErr() {
        try {
            this.dump((Appendable)System.err, "");
        }
        catch (IOException e) {
            LOG.warn((Throwable)e);
        }
    }

    public String dump() {
        return AggregateLifeCycle.dump((Dumpable)this);
    }

    public static String dump(Dumpable dumpable) {
        StringBuilder b = new StringBuilder();
        try {
            dumpable.dump((Appendable)b, "");
        }
        catch (IOException e) {
            LOG.warn((Throwable)e);
        }
        return b.toString();
    }

    public void dump(Appendable out) throws IOException {
        this.dump(out, "");
    }

    protected void dumpThis(Appendable out) throws IOException {
        out.append(String.valueOf(this)).append(" - ").append(this.getState()).append("\n");
    }

    public static void dumpObject(Appendable out, Object o) throws IOException {
        try {
            if (o instanceof LifeCycle) {
                out.append(String.valueOf(o)).append(" - ").append(AbstractLifeCycle.getState((LifeCycle)((LifeCycle)o))).append("\n");
            } else {
                out.append(String.valueOf(o)).append("\n");
            }
        }
        catch (Throwable th) {
            out.append(" => ").append(th.toString()).append('\n');
        }
    }

    public void dump(Appendable out, String indent) throws IOException {
        this.dumpThis(out);
        int size = this._beans.size();
        if (size == 0) {
            return;
        }
        int i = 0;
        for (Bean b : this._beans) {
            ++i;
            if (b._managed) {
                out.append(indent).append(" +- ");
                if (b._bean instanceof Dumpable) {
                    ((Dumpable)b._bean).dump(out, indent + (i == size ? "    " : " |  "));
                    continue;
                }
                AggregateLifeCycle.dumpObject((Appendable)out, (Object)b._bean);
                continue;
            }
            AggregateLifeCycle.dumpObject((Appendable)out, (Object)b._bean);
        }
        if (i != size) {
            out.append(indent).append(" |\n");
        }
    }

    public static void dump(Appendable out, String indent, Collection<?> ... collections) throws IOException {
        if (collections.length == 0) {
            return;
        }
        int size = 0;
        for (Collection<?> c : collections) {
            size += c.size();
        }
        if (size == 0) {
            return;
        }
        int i = 0;
        for (Collection<?> c : collections) {
            for (Object o : c) {
                ++i;
                out.append(indent).append(" +- ");
                if (o instanceof Dumpable) {
                    ((Dumpable)o).dump(out, indent + (i == size ? "    " : " |  "));
                    continue;
                }
                AggregateLifeCycle.dumpObject((Appendable)out, o);
            }
            if (i == size) continue;
            out.append(indent).append(" |\n");
        }
    }
}

