/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.util.component;

import java.util.concurrent.CopyOnWriteArrayList;
import org.eclipse.jetty.util.component.LifeCycle;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;

public abstract class AbstractLifeCycle
implements LifeCycle {
    private static final Logger LOG = Log.getLogger(AbstractLifeCycle.class);
    public static final String STOPPED = "STOPPED";
    public static final String FAILED = "FAILED";
    public static final String STARTING = "STARTING";
    public static final String STARTED = "STARTED";
    public static final String STOPPING = "STOPPING";
    public static final String RUNNING = "RUNNING";
    private final Object _lock = new Object();
    private final int __FAILED = -1;
    private final int __STOPPED = 0;
    private final int __STARTING = 1;
    private final int __STARTED = 2;
    private final int __STOPPING = 3;
    private volatile int _state = 0;
    protected final CopyOnWriteArrayList<LifeCycle.Listener> _listeners = new CopyOnWriteArrayList();

    protected void doStart() throws Exception {
    }

    protected void doStop() throws Exception {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void start() throws Exception {
        Object object = this._lock;
        synchronized (object) {
            try {
                if (this._state == 2 || this._state == 1) {
                    return;
                }
                this.setStarting();
                this.doStart();
                this.setStarted();
            }
            catch (Exception e) {
                this.setFailed((Throwable)e);
                throw e;
            }
            catch (Error e) {
                this.setFailed((Throwable)e);
                throw e;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void stop() throws Exception {
        Object object = this._lock;
        synchronized (object) {
            try {
                if (this._state == 3 || this._state == 0) {
                    return;
                }
                this.setStopping();
                this.doStop();
                this.setStopped();
            }
            catch (Exception e) {
                this.setFailed((Throwable)e);
                throw e;
            }
            catch (Error e) {
                this.setFailed((Throwable)e);
                throw e;
            }
        }
    }

    public boolean isRunning() {
        int state = this._state;
        return state == 2 || state == 1;
    }

    public boolean isStarted() {
        return this._state == 2;
    }

    public boolean isStarting() {
        return this._state == 1;
    }

    public boolean isStopping() {
        return this._state == 3;
    }

    public boolean isStopped() {
        return this._state == 0;
    }

    public boolean isFailed() {
        return this._state == -1;
    }

    public void addLifeCycleListener(LifeCycle.Listener listener) {
        this._listeners.add(listener);
    }

    public void removeLifeCycleListener(LifeCycle.Listener listener) {
        this._listeners.remove(listener);
    }

    public String getState() {
        switch (this._state) {
            case -1: {
                return FAILED;
            }
            case 1: {
                return STARTING;
            }
            case 2: {
                return STARTED;
            }
            case 3: {
                return STOPPING;
            }
            case 0: {
                return STOPPED;
            }
        }
        return null;
    }

    public static String getState(LifeCycle lc) {
        if (lc.isStarting()) {
            return STARTING;
        }
        if (lc.isStarted()) {
            return STARTED;
        }
        if (lc.isStopping()) {
            return STOPPING;
        }
        if (lc.isStopped()) {
            return STOPPED;
        }
        return FAILED;
    }

    private void setStarted() {
        this._state = 2;
        LOG.debug("STARTED {}", new Object[]{this});
        for (LifeCycle.Listener listener : this._listeners) {
            listener.lifeCycleStarted((LifeCycle)this);
        }
    }

    private void setStarting() {
        LOG.debug("starting {}", new Object[]{this});
        this._state = 1;
        for (LifeCycle.Listener listener : this._listeners) {
            listener.lifeCycleStarting((LifeCycle)this);
        }
    }

    private void setStopping() {
        LOG.debug("stopping {}", new Object[]{this});
        this._state = 3;
        for (LifeCycle.Listener listener : this._listeners) {
            listener.lifeCycleStopping((LifeCycle)this);
        }
    }

    private void setStopped() {
        this._state = 0;
        LOG.debug("{} {}", new Object[]{STOPPED, this});
        for (LifeCycle.Listener listener : this._listeners) {
            listener.lifeCycleStopped((LifeCycle)this);
        }
    }

    private void setFailed(Throwable th) {
        this._state = -1;
        LOG.warn("FAILED " + this + ": " + th, th);
        for (LifeCycle.Listener listener : this._listeners) {
            listener.lifeCycleFailure((LifeCycle)this, th);
        }
    }
}

