/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.server.nio;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.nio.channels.ByteChannel;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import java.util.Set;
import org.eclipse.jetty.io.Connection;
import org.eclipse.jetty.io.EndPoint;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.nio.AbstractNIOConnector;
import org.eclipse.jetty.server.nio.BlockingChannelConnector;
import org.eclipse.jetty.util.ConcurrentHashSet;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;

public class BlockingChannelConnector
extends AbstractNIOConnector {
    private static final Logger LOG = Log.getLogger(BlockingChannelConnector.class);
    private transient ServerSocketChannel _acceptChannel;
    private final Set<BlockingChannelEndPoint> _endpoints = new ConcurrentHashSet();

    public Object getConnection() {
        return this._acceptChannel;
    }

    protected void doStart() throws Exception {
        super.doStart();
        this.getThreadPool().dispatch((Runnable)new /* Unavailable Anonymous Inner Class!! */);
    }

    public void open() throws IOException {
        this._acceptChannel = ServerSocketChannel.open();
        this._acceptChannel.configureBlocking(true);
        InetSocketAddress addr = this.getHost() == null ? new InetSocketAddress(this.getPort()) : new InetSocketAddress(this.getHost(), this.getPort());
        this._acceptChannel.socket().bind(addr, this.getAcceptQueueSize());
    }

    public void close() throws IOException {
        if (this._acceptChannel != null) {
            this._acceptChannel.close();
        }
        this._acceptChannel = null;
    }

    public void accept(int acceptorID) throws IOException, InterruptedException {
        SocketChannel channel = this._acceptChannel.accept();
        channel.configureBlocking(true);
        Socket socket = channel.socket();
        this.configure(socket);
        BlockingChannelEndPoint connection = new BlockingChannelEndPoint(this, (ByteChannel)channel);
        connection.dispatch();
    }

    public void customize(EndPoint endpoint, Request request) throws IOException {
        super.customize(endpoint, request);
        endpoint.setMaxIdleTime(this._maxIdleTime);
        this.configure(((SocketChannel)endpoint.getTransport()).socket());
    }

    public int getLocalPort() {
        if (this._acceptChannel == null || !this._acceptChannel.isOpen()) {
            return -1;
        }
        return this._acceptChannel.socket().getLocalPort();
    }

    static /* synthetic */ Set access$000(BlockingChannelConnector x0) {
        return x0._endpoints;
    }

    static /* synthetic */ Logger access$100() {
        return LOG;
    }

    static /* synthetic */ int access$200(BlockingChannelConnector x0) {
        return x0._maxIdleTime;
    }

    static /* synthetic */ void access$300(BlockingChannelConnector x0, Connection x1) {
        x0.connectionOpened(x1);
    }

    static /* synthetic */ void access$400(BlockingChannelConnector x0, Connection x1) {
        x0.connectionClosed(x1);
    }
}

