/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.security.authentication;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import javax.servlet.http.HttpSession;
import javax.servlet.http.HttpSessionActivationListener;
import javax.servlet.http.HttpSessionBindingEvent;
import javax.servlet.http.HttpSessionBindingListener;
import javax.servlet.http.HttpSessionEvent;
import org.eclipse.jetty.security.LoginService;
import org.eclipse.jetty.security.SecurityHandler;
import org.eclipse.jetty.server.Authentication;
import org.eclipse.jetty.server.UserIdentity;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;

public class SessionAuthentication
implements Authentication.User,
Serializable,
HttpSessionActivationListener,
HttpSessionBindingListener {
    private static final Logger LOG = Log.getLogger(SessionAuthentication.class);
    private static final long serialVersionUID = -4643200685888258706L;
    public static final String __J_AUTHENTICATED = "org.eclipse.jetty.security.UserIdentity";
    private final String _method;
    private final String _name;
    private final Object _credentials;
    private transient UserIdentity _userIdentity;
    private transient HttpSession _session;

    public SessionAuthentication(String method, UserIdentity userIdentity, Object credentials) {
        this._method = method;
        this._userIdentity = userIdentity;
        this._name = this._userIdentity.getUserPrincipal().getName();
        this._credentials = credentials;
    }

    public String getAuthMethod() {
        return this._method;
    }

    public UserIdentity getUserIdentity() {
        return this._userIdentity;
    }

    public boolean isUserInRole(UserIdentity.Scope scope, String role) {
        return this._userIdentity.isUserInRole(role, scope);
    }

    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        stream.defaultReadObject();
        SecurityHandler security = SecurityHandler.getCurrentSecurityHandler();
        if (security == null) {
            throw new IllegalStateException("!SecurityHandler");
        }
        LoginService login_service = security.getLoginService();
        if (login_service == null) {
            throw new IllegalStateException("!LoginService");
        }
        this._userIdentity = login_service.login(this._name, this._credentials);
        LOG.debug("Deserialized and relogged in {}", new Object[]{this});
    }

    public void logout() {
        if (this._session != null && this._session.getAttribute(__J_AUTHENTICATED) != null) {
            this._session.removeAttribute(__J_AUTHENTICATED);
        } else {
            this.doLogout();
        }
    }

    private void doLogout() {
        SecurityHandler security = SecurityHandler.getCurrentSecurityHandler();
        if (security != null) {
            security.logout((Authentication.User)this);
        }
        if (this._session != null) {
            this._session.removeAttribute("org.eclipse.jetty.security.secured");
        }
    }

    public String toString() {
        return "Session" + super.toString();
    }

    public void sessionWillPassivate(HttpSessionEvent se) {
    }

    public void sessionDidActivate(HttpSessionEvent se) {
        if (this._session == null) {
            this._session = se.getSession();
        }
    }

    public void valueBound(HttpSessionBindingEvent event) {
    }

    public void valueUnbound(HttpSessionBindingEvent event) {
        this.doLogout();
    }
}

