/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.io.nio;

import java.io.IOException;
import java.nio.channels.SelectableChannel;
import java.nio.channels.SelectionKey;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import java.util.Collection;
import org.eclipse.jetty.io.AsyncEndPoint;
import org.eclipse.jetty.io.ConnectedEndPoint;
import org.eclipse.jetty.io.Connection;
import org.eclipse.jetty.io.nio.AsyncConnection;
import org.eclipse.jetty.io.nio.SelectChannelEndPoint;
import org.eclipse.jetty.io.nio.SelectorManager;
import org.eclipse.jetty.util.TypeUtil;
import org.eclipse.jetty.util.component.AbstractLifeCycle;
import org.eclipse.jetty.util.component.AggregateLifeCycle;
import org.eclipse.jetty.util.component.Dumpable;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;

public abstract class SelectorManager
extends AbstractLifeCycle
implements Dumpable {
    public static final Logger LOG = Log.getLogger((String)"org.eclipse.jetty.io.nio");
    private static final int __MONITOR_PERIOD = Integer.getInteger("org.eclipse.jetty.io.nio.MONITOR_PERIOD", 1000);
    private static final int __MAX_SELECTS = Integer.getInteger("org.eclipse.jetty.io.nio.MAX_SELECTS", 100000);
    private static final int __BUSY_PAUSE = Integer.getInteger("org.eclipse.jetty.io.nio.BUSY_PAUSE", 50);
    private static final int __IDLE_TICK = Integer.getInteger("org.eclipse.jetty.io.nio.IDLE_TICK", 400);
    private int _maxIdleTime;
    private int _lowResourcesMaxIdleTime;
    private long _lowResourcesConnections;
    private SelectSet[] _selectSet;
    private int _selectSets = 1;
    private volatile int _set = 0;
    private boolean _deferringInterestedOps0 = true;
    private int _selectorPriorityDelta = 0;

    public void setMaxIdleTime(long maxIdleTime) {
        this._maxIdleTime = (int)maxIdleTime;
    }

    public void setSelectSets(int selectSets) {
        long lrc = this._lowResourcesConnections * (long)this._selectSets;
        this._selectSets = selectSets;
        this._lowResourcesConnections = lrc / (long)this._selectSets;
    }

    public long getMaxIdleTime() {
        return this._maxIdleTime;
    }

    public int getSelectSets() {
        return this._selectSets;
    }

    public SelectSet getSelectSet(int i) {
        return this._selectSet[i];
    }

    public void register(SocketChannel channel, Object att) {
        int s;
        if ((s = this._set++) < 0) {
            s = -s;
        }
        s %= this._selectSets;
        SelectSet[] sets = this._selectSet;
        if (sets != null) {
            SelectSet set = sets[s];
            set.addChange((SelectableChannel)channel, att);
            set.wakeup();
        }
    }

    public void register(SocketChannel channel) {
        int s;
        if ((s = this._set++) < 0) {
            s = -s;
        }
        s %= this._selectSets;
        SelectSet[] sets = this._selectSet;
        if (sets != null) {
            SelectSet set = sets[s];
            set.addChange((Object)channel);
            set.wakeup();
        }
    }

    public void register(ServerSocketChannel acceptChannel) {
        int s;
        if ((s = this._set++) < 0) {
            s = -s;
        }
        SelectSet set = this._selectSet[s %= this._selectSets];
        set.addChange((Object)acceptChannel);
        set.wakeup();
    }

    public int getSelectorPriorityDelta() {
        return this._selectorPriorityDelta;
    }

    public void setSelectorPriorityDelta(int delta) {
        this._selectorPriorityDelta = delta;
    }

    public long getLowResourcesConnections() {
        return this._lowResourcesConnections * (long)this._selectSets;
    }

    public void setLowResourcesConnections(long lowResourcesConnections) {
        this._lowResourcesConnections = (lowResourcesConnections + (long)this._selectSets - 1L) / (long)this._selectSets;
    }

    public long getLowResourcesMaxIdleTime() {
        return this._lowResourcesMaxIdleTime;
    }

    public void setLowResourcesMaxIdleTime(long lowResourcesMaxIdleTime) {
        this._lowResourcesMaxIdleTime = (int)lowResourcesMaxIdleTime;
    }

    public abstract boolean dispatch(Runnable var1);

    protected void doStart() throws Exception {
        int i;
        this._selectSet = new SelectSet[this._selectSets];
        for (i = 0; i < this._selectSet.length; ++i) {
            this._selectSet[i] = new SelectSet(this, i);
        }
        super.doStart();
        i = 0;
        while (i < this.getSelectSets()) {
            int id;
            boolean selecting;
            if (selecting = this.dispatch((Runnable)new /* Unavailable Anonymous Inner Class!! */)) continue;
            throw new IllegalStateException("!Selecting");
        }
    }

    protected void doStop() throws Exception {
        SelectSet[] sets = this._selectSet;
        this._selectSet = null;
        if (sets != null) {
            for (SelectSet set : sets) {
                if (set == null) continue;
                set.stop();
            }
        }
        super.doStop();
    }

    protected abstract void endPointClosed(SelectChannelEndPoint var1);

    protected abstract void endPointOpened(SelectChannelEndPoint var1);

    protected abstract void endPointUpgraded(ConnectedEndPoint var1, Connection var2);

    public abstract AsyncConnection newConnection(SocketChannel var1, AsyncEndPoint var2, Object var3);

    protected abstract SelectChannelEndPoint newEndPoint(SocketChannel var1, SelectSet var2, SelectionKey var3) throws IOException;

    protected void connectionFailed(SocketChannel channel, Throwable ex, Object attachment) {
        LOG.warn(ex + "," + channel + "," + attachment, new Object[0]);
        LOG.debug(ex);
    }

    public String dump() {
        return AggregateLifeCycle.dump((Dumpable)this);
    }

    public void dump(Appendable out, String indent) throws IOException {
        AggregateLifeCycle.dumpObject((Appendable)out, (Object)this);
        AggregateLifeCycle.dump((Appendable)out, (String)indent, (Collection[])new Collection[]{TypeUtil.asList((Object[])this._selectSet)});
    }

    public boolean isDeferringInterestedOps0() {
        return this._deferringInterestedOps0;
    }

    public void setDeferringInterestedOps0(boolean deferringInterestedOps0) {
        this._deferringInterestedOps0 = deferringInterestedOps0;
    }

    static /* synthetic */ SelectSet[] access$000(SelectorManager x0) {
        return x0._selectSet;
    }

    static /* synthetic */ int access$100() {
        return __MONITOR_PERIOD;
    }

    static /* synthetic */ int access$200() {
        return __BUSY_PAUSE;
    }

    static /* synthetic */ int access$300() {
        return __IDLE_TICK;
    }

    static /* synthetic */ int access$400() {
        return __MAX_SELECTS;
    }

    static /* synthetic */ long access$500(SelectorManager x0) {
        return x0._lowResourcesConnections;
    }

    static /* synthetic */ int access$600(SelectorManager x0) {
        return x0._maxIdleTime;
    }

    static /* synthetic */ int access$700(SelectorManager x0) {
        return x0._lowResourcesMaxIdleTime;
    }
}

