/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.jackson.util;

import java.io.IOException;
import java.math.BigDecimal;
import java.math.BigInteger;
import org.codehaus.jackson.Base64Variant;
import org.codehaus.jackson.JsonGenerationException;
import org.codehaus.jackson.JsonGenerator;
import org.codehaus.jackson.JsonNode;
import org.codehaus.jackson.JsonParser;
import org.codehaus.jackson.JsonProcessingException;
import org.codehaus.jackson.JsonToken;
import org.codehaus.jackson.ObjectCodec;
import org.codehaus.jackson.SerializableString;
import org.codehaus.jackson.impl.JsonWriteContext;
import org.codehaus.jackson.io.SerializedString;
import org.codehaus.jackson.util.TokenBuffer;

public class TokenBuffer
extends JsonGenerator {
    protected static final int DEFAULT_PARSER_FEATURES = JsonParser.Feature.collectDefaults();
    protected ObjectCodec _objectCodec;
    protected int _generatorFeatures;
    protected boolean _closed;
    protected Segment _first;
    protected Segment _last;
    protected int _appendOffset;
    protected JsonWriteContext _writeContext;

    public TokenBuffer(ObjectCodec codec) {
        this._objectCodec = codec;
        this._generatorFeatures = DEFAULT_PARSER_FEATURES;
        this._writeContext = JsonWriteContext.createRootContext();
        this._first = this._last = new Segment();
        this._appendOffset = 0;
    }

    public JsonParser asParser() {
        return this.asParser(this._objectCodec);
    }

    public JsonParser asParser(ObjectCodec codec) {
        return new Parser(this._first, codec);
    }

    public JsonParser asParser(JsonParser src) {
        Parser p = new Parser(this._first, src.getCodec());
        p.setLocation(src.getTokenLocation());
        return p;
    }

    public void serialize(JsonGenerator jgen) throws IOException, JsonGenerationException {
        Segment segment = this._first;
        int ptr = -1;
        while (true) {
            JsonToken t;
            if (++ptr >= 16) {
                ptr = 0;
                if ((segment = segment.next()) == null) break;
            }
            if ((t = segment.type(ptr)) == null) break;
            switch (1.$SwitchMap$org$codehaus$jackson$JsonToken[t.ordinal()]) {
                case 1: {
                    jgen.writeStartObject();
                    break;
                }
                case 2: {
                    jgen.writeEndObject();
                    break;
                }
                case 3: {
                    jgen.writeStartArray();
                    break;
                }
                case 4: {
                    jgen.writeEndArray();
                    break;
                }
                case 5: {
                    Object ob = segment.get(ptr);
                    if (ob instanceof SerializableString) {
                        jgen.writeFieldName((SerializableString)ob);
                        break;
                    }
                    jgen.writeFieldName((String)ob);
                    break;
                }
                case 6: {
                    Object ob = segment.get(ptr);
                    if (ob instanceof SerializableString) {
                        jgen.writeString((SerializableString)ob);
                        break;
                    }
                    jgen.writeString((String)ob);
                    break;
                }
                case 7: {
                    Object n = (Number)segment.get(ptr);
                    if (n instanceof BigInteger) {
                        jgen.writeNumber((BigInteger)n);
                        break;
                    }
                    if (n instanceof Long) {
                        jgen.writeNumber(((Number)n).longValue());
                        break;
                    }
                    jgen.writeNumber(((Number)n).intValue());
                    break;
                }
                case 8: {
                    Object n = segment.get(ptr);
                    if (n instanceof BigDecimal) {
                        jgen.writeNumber((BigDecimal)n);
                        break;
                    }
                    if (n instanceof Float) {
                        jgen.writeNumber(((Float)n).floatValue());
                        break;
                    }
                    if (n instanceof Double) {
                        jgen.writeNumber(((Double)n).doubleValue());
                        break;
                    }
                    if (n == null) {
                        jgen.writeNull();
                        break;
                    }
                    if (n instanceof String) {
                        jgen.writeNumber((String)n);
                        break;
                    }
                    throw new JsonGenerationException("Unrecognized value type for VALUE_NUMBER_FLOAT: " + n.getClass().getName() + ", can not serialize");
                }
                case 9: {
                    jgen.writeBoolean(true);
                    break;
                }
                case 10: {
                    jgen.writeBoolean(false);
                    break;
                }
                case 11: {
                    jgen.writeNull();
                    break;
                }
                case 12: {
                    jgen.writeObject(segment.get(ptr));
                    break;
                }
                default: {
                    throw new RuntimeException("Internal error: should never end up through this code path");
                }
            }
        }
    }

    public String toString() {
        int MAX_COUNT = 100;
        StringBuilder sb = new StringBuilder();
        sb.append("[TokenBuffer: ");
        JsonParser jp = this.asParser();
        int count = 0;
        while (true) {
            JsonToken t;
            try {
                t = jp.nextToken();
            }
            catch (IOException ioe) {
                throw new IllegalStateException(ioe);
            }
            if (t == null) break;
            if (count < 100) {
                if (count > 0) {
                    sb.append(", ");
                }
                sb.append(t.toString());
            }
            ++count;
        }
        if (count >= 100) {
            sb.append(" ... (truncated ").append(count - 100).append(" entries)");
        }
        sb.append(']');
        return sb.toString();
    }

    public JsonGenerator enable(JsonGenerator.Feature f) {
        this._generatorFeatures |= f.getMask();
        return this;
    }

    public JsonGenerator disable(JsonGenerator.Feature f) {
        this._generatorFeatures &= ~f.getMask();
        return this;
    }

    public boolean isEnabled(JsonGenerator.Feature f) {
        return (this._generatorFeatures & f.getMask()) != 0;
    }

    public JsonGenerator useDefaultPrettyPrinter() {
        return this;
    }

    public JsonGenerator setCodec(ObjectCodec oc) {
        this._objectCodec = oc;
        return this;
    }

    public ObjectCodec getCodec() {
        return this._objectCodec;
    }

    public final JsonWriteContext getOutputContext() {
        return this._writeContext;
    }

    public void flush() throws IOException {
    }

    public void close() throws IOException {
        this._closed = true;
    }

    public boolean isClosed() {
        return this._closed;
    }

    public final void writeStartArray() throws IOException, JsonGenerationException {
        this._append(JsonToken.START_ARRAY);
        this._writeContext = this._writeContext.createChildArrayContext();
    }

    public final void writeEndArray() throws IOException, JsonGenerationException {
        this._append(JsonToken.END_ARRAY);
        JsonWriteContext c = this._writeContext.getParent();
        if (c != null) {
            this._writeContext = c;
        }
    }

    public final void writeStartObject() throws IOException, JsonGenerationException {
        this._append(JsonToken.START_OBJECT);
        this._writeContext = this._writeContext.createChildObjectContext();
    }

    public final void writeEndObject() throws IOException, JsonGenerationException {
        this._append(JsonToken.END_OBJECT);
        JsonWriteContext c = this._writeContext.getParent();
        if (c != null) {
            this._writeContext = c;
        }
    }

    public final void writeFieldName(String name) throws IOException, JsonGenerationException {
        this._append(JsonToken.FIELD_NAME, (Object)name);
        this._writeContext.writeFieldName(name);
    }

    public void writeFieldName(SerializableString name) throws IOException, JsonGenerationException {
        this._append(JsonToken.FIELD_NAME, (Object)name);
        this._writeContext.writeFieldName(name.getValue());
    }

    public void writeFieldName(SerializedString name) throws IOException, JsonGenerationException {
        this._append(JsonToken.FIELD_NAME, (Object)name);
        this._writeContext.writeFieldName(name.getValue());
    }

    public void writeString(String text) throws IOException, JsonGenerationException {
        if (text == null) {
            this.writeNull();
        } else {
            this._append(JsonToken.VALUE_STRING, (Object)text);
        }
    }

    public void writeString(char[] text, int offset, int len) throws IOException, JsonGenerationException {
        this.writeString(new String(text, offset, len));
    }

    public void writeString(SerializableString text) throws IOException, JsonGenerationException {
        if (text == null) {
            this.writeNull();
        } else {
            this._append(JsonToken.VALUE_STRING, (Object)text);
        }
    }

    public void writeRawUTF8String(byte[] text, int offset, int length) throws IOException, JsonGenerationException {
        this._reportUnsupportedOperation();
    }

    public void writeUTF8String(byte[] text, int offset, int length) throws IOException, JsonGenerationException {
        this._reportUnsupportedOperation();
    }

    public void writeRaw(String text) throws IOException, JsonGenerationException {
        this._reportUnsupportedOperation();
    }

    public void writeRaw(String text, int offset, int len) throws IOException, JsonGenerationException {
        this._reportUnsupportedOperation();
    }

    public void writeRaw(char[] text, int offset, int len) throws IOException, JsonGenerationException {
        this._reportUnsupportedOperation();
    }

    public void writeRaw(char c) throws IOException, JsonGenerationException {
        this._reportUnsupportedOperation();
    }

    public void writeRawValue(String text) throws IOException, JsonGenerationException {
        this._reportUnsupportedOperation();
    }

    public void writeRawValue(String text, int offset, int len) throws IOException, JsonGenerationException {
        this._reportUnsupportedOperation();
    }

    public void writeRawValue(char[] text, int offset, int len) throws IOException, JsonGenerationException {
        this._reportUnsupportedOperation();
    }

    public void writeNumber(int i) throws IOException, JsonGenerationException {
        this._append(JsonToken.VALUE_NUMBER_INT, (Object)i);
    }

    public void writeNumber(long l) throws IOException, JsonGenerationException {
        this._append(JsonToken.VALUE_NUMBER_INT, (Object)l);
    }

    public void writeNumber(double d) throws IOException, JsonGenerationException {
        this._append(JsonToken.VALUE_NUMBER_FLOAT, (Object)d);
    }

    public void writeNumber(float f) throws IOException, JsonGenerationException {
        this._append(JsonToken.VALUE_NUMBER_FLOAT, (Object)Float.valueOf(f));
    }

    public void writeNumber(BigDecimal dec) throws IOException, JsonGenerationException {
        if (dec == null) {
            this.writeNull();
        } else {
            this._append(JsonToken.VALUE_NUMBER_FLOAT, (Object)dec);
        }
    }

    public void writeNumber(BigInteger v) throws IOException, JsonGenerationException {
        if (v == null) {
            this.writeNull();
        } else {
            this._append(JsonToken.VALUE_NUMBER_INT, (Object)v);
        }
    }

    public void writeNumber(String encodedValue) throws IOException, JsonGenerationException {
        this._append(JsonToken.VALUE_NUMBER_FLOAT, (Object)encodedValue);
    }

    public void writeBoolean(boolean state) throws IOException, JsonGenerationException {
        this._append(state ? JsonToken.VALUE_TRUE : JsonToken.VALUE_FALSE);
    }

    public void writeNull() throws IOException, JsonGenerationException {
        this._append(JsonToken.VALUE_NULL);
    }

    public void writeObject(Object value) throws IOException, JsonProcessingException {
        this._append(JsonToken.VALUE_EMBEDDED_OBJECT, value);
    }

    public void writeTree(JsonNode rootNode) throws IOException, JsonProcessingException {
        this._append(JsonToken.VALUE_EMBEDDED_OBJECT, (Object)rootNode);
    }

    public void writeBinary(Base64Variant b64variant, byte[] data, int offset, int len) throws IOException, JsonGenerationException {
        byte[] copy = new byte[len];
        System.arraycopy(data, offset, copy, 0, len);
        this.writeObject((Object)copy);
    }

    public void copyCurrentEvent(JsonParser jp) throws IOException, JsonProcessingException {
        block0 : switch (1.$SwitchMap$org$codehaus$jackson$JsonToken[jp.getCurrentToken().ordinal()]) {
            case 1: {
                this.writeStartObject();
                break;
            }
            case 2: {
                this.writeEndObject();
                break;
            }
            case 3: {
                this.writeStartArray();
                break;
            }
            case 4: {
                this.writeEndArray();
                break;
            }
            case 5: {
                this.writeFieldName(jp.getCurrentName());
                break;
            }
            case 6: {
                if (jp.hasTextCharacters()) {
                    this.writeString(jp.getTextCharacters(), jp.getTextOffset(), jp.getTextLength());
                    break;
                }
                this.writeString(jp.getText());
                break;
            }
            case 7: {
                switch (1.$SwitchMap$org$codehaus$jackson$JsonParser$NumberType[jp.getNumberType().ordinal()]) {
                    case 1: {
                        this.writeNumber(jp.getIntValue());
                        break block0;
                    }
                    case 2: {
                        this.writeNumber(jp.getBigIntegerValue());
                        break block0;
                    }
                }
                this.writeNumber(jp.getLongValue());
                break;
            }
            case 8: {
                switch (1.$SwitchMap$org$codehaus$jackson$JsonParser$NumberType[jp.getNumberType().ordinal()]) {
                    case 3: {
                        this.writeNumber(jp.getDecimalValue());
                        break block0;
                    }
                    case 4: {
                        this.writeNumber(jp.getFloatValue());
                        break block0;
                    }
                }
                this.writeNumber(jp.getDoubleValue());
                break;
            }
            case 9: {
                this.writeBoolean(true);
                break;
            }
            case 10: {
                this.writeBoolean(false);
                break;
            }
            case 11: {
                this.writeNull();
                break;
            }
            case 12: {
                this.writeObject(jp.getEmbeddedObject());
                break;
            }
            default: {
                throw new RuntimeException("Internal error: should never end up through this code path");
            }
        }
    }

    public void copyCurrentStructure(JsonParser jp) throws IOException, JsonProcessingException {
        JsonToken t = jp.getCurrentToken();
        if (t == JsonToken.FIELD_NAME) {
            this.writeFieldName(jp.getCurrentName());
            t = jp.nextToken();
        }
        switch (1.$SwitchMap$org$codehaus$jackson$JsonToken[t.ordinal()]) {
            case 3: {
                this.writeStartArray();
                while (jp.nextToken() != JsonToken.END_ARRAY) {
                    this.copyCurrentStructure(jp);
                }
                this.writeEndArray();
                break;
            }
            case 1: {
                this.writeStartObject();
                while (jp.nextToken() != JsonToken.END_OBJECT) {
                    this.copyCurrentStructure(jp);
                }
                this.writeEndObject();
                break;
            }
            default: {
                this.copyCurrentEvent(jp);
            }
        }
    }

    protected final void _append(JsonToken type) {
        Segment next = this._last.append(this._appendOffset, type);
        if (next == null) {
            ++this._appendOffset;
        } else {
            this._last = next;
            this._appendOffset = 1;
        }
    }

    protected final void _append(JsonToken type, Object value) {
        Segment next = this._last.append(this._appendOffset, type, value);
        if (next == null) {
            ++this._appendOffset;
        } else {
            this._last = next;
            this._appendOffset = 1;
        }
    }

    protected void _reportUnsupportedOperation() {
        throw new UnsupportedOperationException("Called operation not supported for TokenBuffer");
    }
}

