/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.jackson.map.deser.std;

import java.io.IOException;
import java.util.HashMap;
import org.codehaus.jackson.JsonParser;
import org.codehaus.jackson.JsonProcessingException;
import org.codehaus.jackson.map.DeserializationContext;
import org.codehaus.jackson.map.JsonDeserializer;
import org.codehaus.jackson.map.TypeDeserializer;
import org.codehaus.jackson.map.deser.std.PrimitiveArrayDeserializers;
import org.codehaus.jackson.map.type.TypeFactory;
import org.codehaus.jackson.type.JavaType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PrimitiveArrayDeserializers {
    HashMap<JavaType, JsonDeserializer<Object>> _allDeserializers = new HashMap();
    static final PrimitiveArrayDeserializers instance = new PrimitiveArrayDeserializers();

    protected PrimitiveArrayDeserializers() {
        this.add(Boolean.TYPE, (JsonDeserializer)new BooleanDeser());
        this.add(Byte.TYPE, (JsonDeserializer)new ByteDeser());
        this.add(Short.TYPE, (JsonDeserializer)new ShortDeser());
        this.add(Integer.TYPE, (JsonDeserializer)new IntDeser());
        this.add(Long.TYPE, (JsonDeserializer)new LongDeser());
        this.add(Float.TYPE, (JsonDeserializer)new FloatDeser());
        this.add(Double.TYPE, (JsonDeserializer)new DoubleDeser());
        this.add(String.class, (JsonDeserializer)new StringDeser());
        this.add(Character.TYPE, (JsonDeserializer)new CharDeser());
    }

    public static HashMap<JavaType, JsonDeserializer<Object>> getAll() {
        return PrimitiveArrayDeserializers.instance._allDeserializers;
    }

    private void add(Class<?> cls, JsonDeserializer<?> deser) {
        this._allDeserializers.put(TypeFactory.defaultInstance().constructType(cls), deser);
    }

    public Object deserializeWithType(JsonParser jp, DeserializationContext ctxt, TypeDeserializer typeDeserializer) throws IOException, JsonProcessingException {
        return typeDeserializer.deserializeTypedFromArray(jp, ctxt);
    }
}

