/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.jackson.map;

import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.codehaus.jackson.JsonLocation;
import org.codehaus.jackson.JsonParser;
import org.codehaus.jackson.JsonProcessingException;
import org.codehaus.jackson.map.JsonMappingException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 * Exception performing whole class analysis ignored.
 */
public class JsonMappingException
extends JsonProcessingException {
    private static final long serialVersionUID = 1L;
    static final int MAX_REFS_TO_LIST = 1000;
    protected LinkedList<Reference> _path;

    public JsonMappingException(String msg) {
        super(msg);
    }

    public JsonMappingException(String msg, Throwable rootCause) {
        super(msg, rootCause);
    }

    public JsonMappingException(String msg, JsonLocation loc) {
        super(msg, loc);
    }

    public JsonMappingException(String msg, JsonLocation loc, Throwable rootCause) {
        super(msg, loc, rootCause);
    }

    public static JsonMappingException from(JsonParser jp, String msg) {
        return new JsonMappingException(msg, jp.getTokenLocation());
    }

    public static JsonMappingException from(JsonParser jp, String msg, Throwable problem) {
        return new JsonMappingException(msg, jp.getTokenLocation(), problem);
    }

    public static JsonMappingException wrapWithPath(Throwable src, Object refFrom, String refFieldName) {
        return JsonMappingException.wrapWithPath((Throwable)src, (Reference)new Reference(refFrom, refFieldName));
    }

    public static JsonMappingException wrapWithPath(Throwable src, Object refFrom, int index) {
        return JsonMappingException.wrapWithPath((Throwable)src, (Reference)new Reference(refFrom, index));
    }

    public static JsonMappingException wrapWithPath(Throwable src, Reference ref) {
        JsonMappingException jme;
        if (src instanceof JsonMappingException) {
            jme = (JsonMappingException)src;
        } else {
            String msg = src.getMessage();
            if (msg == null || msg.length() == 0) {
                msg = "(was " + src.getClass().getName() + ")";
            }
            jme = new JsonMappingException(msg, null, src);
        }
        jme.prependPath(ref);
        return jme;
    }

    public List<Reference> getPath() {
        if (this._path == null) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableList(this._path);
    }

    public void prependPath(Object referrer, String fieldName) {
        Reference ref = new Reference(referrer, fieldName);
        this.prependPath(ref);
    }

    public void prependPath(Object referrer, int index) {
        Reference ref = new Reference(referrer, index);
        this.prependPath(ref);
    }

    public void prependPath(Reference r) {
        if (this._path == null) {
            this._path = new LinkedList();
        }
        if (this._path.size() < 1000) {
            this._path.addFirst(r);
        }
    }

    public String getMessage() {
        String msg = super.getMessage();
        if (this._path == null) {
            return msg;
        }
        StringBuilder sb = msg == null ? new StringBuilder() : new StringBuilder(msg);
        sb.append(" (through reference chain: ");
        this._appendPathDesc(sb);
        sb.append(')');
        return sb.toString();
    }

    public String toString() {
        return this.getClass().getName() + ": " + this.getMessage();
    }

    protected void _appendPathDesc(StringBuilder sb) {
        Iterator it = this._path.iterator();
        while (it.hasNext()) {
            sb.append(((Reference)it.next()).toString());
            if (!it.hasNext()) continue;
            sb.append("->");
        }
    }
}

