/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shiro.util;

import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.shiro.util.CollectionUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MapContext
implements Map<String, Object>,
Serializable {
    private static final long serialVersionUID = 5373399119017820322L;
    private final Map<String, Object> backingMap = new HashMap();

    public MapContext() {
    }

    public MapContext(Map<String, Object> map) {
        this();
        if (!CollectionUtils.isEmpty(map)) {
            this.backingMap.putAll(map);
        }
    }

    protected <E> E getTypedValue(String key, Class<E> type) {
        E found = null;
        Object o = this.backingMap.get(key);
        if (o != null) {
            if (!type.isAssignableFrom(o.getClass())) {
                String msg = "Invalid object found in SubjectContext Map under key [" + key + "].  Expected type " + "was [" + type.getName() + "], but the object under that key is of type " + "[" + o.getClass().getName() + "].";
                throw new IllegalArgumentException(msg);
            }
            found = (E)o;
        }
        return found;
    }

    protected void nullSafePut(String key, Object value) {
        if (value != null) {
            this.put(key, value);
        }
    }

    @Override
    public int size() {
        return this.backingMap.size();
    }

    @Override
    public boolean isEmpty() {
        return this.backingMap.isEmpty();
    }

    @Override
    public boolean containsKey(Object o) {
        return this.backingMap.containsKey(o);
    }

    @Override
    public boolean containsValue(Object o) {
        return this.backingMap.containsValue(o);
    }

    @Override
    public Object get(Object o) {
        return this.backingMap.get(o);
    }

    @Override
    public Object put(String s, Object o) {
        return this.backingMap.put(s, o);
    }

    @Override
    public Object remove(Object o) {
        return this.backingMap.remove(o);
    }

    @Override
    public void putAll(Map<? extends String, ?> map) {
        this.backingMap.putAll(map);
    }

    @Override
    public void clear() {
        this.backingMap.clear();
    }

    @Override
    public Set<String> keySet() {
        return Collections.unmodifiableSet(this.backingMap.keySet());
    }

    @Override
    public Collection<Object> values() {
        return Collections.unmodifiableCollection(this.backingMap.values());
    }

    @Override
    public Set<Map.Entry<String, Object>> entrySet() {
        return Collections.unmodifiableSet(this.backingMap.entrySet());
    }
}

