/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shiro.subject.support;

import java.util.Map;
import org.apache.shiro.mgt.SecurityManager;
import org.apache.shiro.subject.Subject;
import org.apache.shiro.subject.support.DelegatingSubject;
import org.apache.shiro.util.CollectionUtils;
import org.apache.shiro.util.ThreadContext;
import org.apache.shiro.util.ThreadState;

public class SubjectThreadState
implements ThreadState {
    private Map<Object, Object> originalResources;
    private final Subject subject;
    private transient SecurityManager securityManager;

    public SubjectThreadState(Subject subject) {
        if (subject == null) {
            throw new IllegalArgumentException("Subject argument cannot be null.");
        }
        this.subject = subject;
        SecurityManager securityManager = null;
        if (subject instanceof DelegatingSubject) {
            securityManager = ((DelegatingSubject)subject).getSecurityManager();
        }
        if (securityManager == null) {
            securityManager = ThreadContext.getSecurityManager();
        }
        this.securityManager = securityManager;
    }

    protected Subject getSubject() {
        return this.subject;
    }

    public void bind() {
        SecurityManager securityManager = this.securityManager;
        if (securityManager == null) {
            securityManager = ThreadContext.getSecurityManager();
        }
        this.originalResources = ThreadContext.getResources();
        ThreadContext.remove();
        ThreadContext.bind((Subject)this.subject);
        if (securityManager != null) {
            ThreadContext.bind((SecurityManager)securityManager);
        }
    }

    public void restore() {
        ThreadContext.remove();
        if (!CollectionUtils.isEmpty((Map)this.originalResources)) {
            ThreadContext.setResources((Map)this.originalResources);
        }
    }

    public void clear() {
        ThreadContext.remove();
    }
}

