/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shiro.subject.support;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.Callable;
import org.apache.shiro.authc.AuthenticationException;
import org.apache.shiro.authc.AuthenticationToken;
import org.apache.shiro.authc.HostAuthenticationToken;
import org.apache.shiro.authz.AuthorizationException;
import org.apache.shiro.authz.Permission;
import org.apache.shiro.authz.UnauthenticatedException;
import org.apache.shiro.mgt.SecurityManager;
import org.apache.shiro.session.Session;
import org.apache.shiro.session.SessionException;
import org.apache.shiro.session.mgt.DefaultSessionContext;
import org.apache.shiro.session.mgt.SessionContext;
import org.apache.shiro.subject.ExecutionException;
import org.apache.shiro.subject.PrincipalCollection;
import org.apache.shiro.subject.Subject;
import org.apache.shiro.subject.support.DelegatingSubject;
import org.apache.shiro.subject.support.DisabledSessionException;
import org.apache.shiro.subject.support.SubjectCallable;
import org.apache.shiro.subject.support.SubjectRunnable;
import org.apache.shiro.util.CollectionUtils;
import org.apache.shiro.util.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DelegatingSubject
implements Subject {
    private static final Logger log = LoggerFactory.getLogger(DelegatingSubject.class);
    private static final String RUN_AS_PRINCIPALS_SESSION_KEY = DelegatingSubject.class.getName() + ".RUN_AS_PRINCIPALS_SESSION_KEY";
    protected PrincipalCollection principals;
    protected boolean authenticated;
    protected String host;
    protected Session session;
    protected boolean sessionCreationEnabled;
    private List<PrincipalCollection> runAsPrincipals;
    protected transient SecurityManager securityManager;

    public DelegatingSubject(SecurityManager securityManager) {
        this(null, false, null, null, securityManager);
    }

    public DelegatingSubject(PrincipalCollection principals, boolean authenticated, String host, Session session, SecurityManager securityManager) {
        this(principals, authenticated, host, session, true, securityManager);
    }

    public DelegatingSubject(PrincipalCollection principals, boolean authenticated, String host, Session session, boolean sessionCreationEnabled, SecurityManager securityManager) {
        if (securityManager == null) {
            throw new IllegalArgumentException("SecurityManager argument cannot be null.");
        }
        this.securityManager = securityManager;
        this.principals = principals;
        this.authenticated = authenticated;
        this.host = host;
        if (session != null) {
            this.session = this.decorate(session);
            this.runAsPrincipals = this.getRunAsPrincipals(this.session);
        }
        this.sessionCreationEnabled = sessionCreationEnabled;
    }

    protected Session decorate(Session session) {
        if (session == null) {
            throw new IllegalArgumentException("session cannot be null");
        }
        return new StoppingAwareProxiedSession(this, session, this, null);
    }

    public SecurityManager getSecurityManager() {
        return this.securityManager;
    }

    protected boolean hasPrincipals() {
        return !CollectionUtils.isEmpty((PrincipalCollection)this.getPrincipals());
    }

    public String getHost() {
        return this.host;
    }

    private Object getPrimaryPrincipal(PrincipalCollection principals) {
        if (!CollectionUtils.isEmpty((PrincipalCollection)principals)) {
            return principals.getPrimaryPrincipal();
        }
        return null;
    }

    public Object getPrincipal() {
        return this.getPrimaryPrincipal(this.getPrincipals());
    }

    public PrincipalCollection getPrincipals() {
        return CollectionUtils.isEmpty((Collection)this.runAsPrincipals) ? this.principals : (PrincipalCollection)this.runAsPrincipals.get(0);
    }

    public boolean isPermitted(String permission) {
        return this.hasPrincipals() && this.securityManager.isPermitted(this.getPrincipals(), permission);
    }

    public boolean isPermitted(Permission permission) {
        return this.hasPrincipals() && this.securityManager.isPermitted(this.getPrincipals(), permission);
    }

    public boolean[] isPermitted(String ... permissions) {
        if (this.hasPrincipals()) {
            return this.securityManager.isPermitted(this.getPrincipals(), permissions);
        }
        return new boolean[permissions.length];
    }

    public boolean[] isPermitted(List<Permission> permissions) {
        if (this.hasPrincipals()) {
            return this.securityManager.isPermitted(this.getPrincipals(), permissions);
        }
        return new boolean[permissions.size()];
    }

    public boolean isPermittedAll(String ... permissions) {
        return this.hasPrincipals() && this.securityManager.isPermittedAll(this.getPrincipals(), permissions);
    }

    public boolean isPermittedAll(Collection<Permission> permissions) {
        return this.hasPrincipals() && this.securityManager.isPermittedAll(this.getPrincipals(), permissions);
    }

    protected void assertAuthzCheckPossible() throws AuthorizationException {
        if (!this.hasPrincipals()) {
            String msg = "This subject is anonymous - it does not have any identifying principals and authorization operations require an identity to check against.  A Subject instance will acquire these identifying principals automatically after a successful login is performed be executing " + Subject.class.getName() + ".login(AuthenticationToken) or when 'Remember Me' " + "functionality is enabled by the SecurityManager.  This exception can also occur when a " + "previously logged-in Subject has logged out which " + "makes it anonymous again.  Because an identity is currently not known due to any of these " + "conditions, authorization is denied.";
            throw new UnauthenticatedException(msg);
        }
    }

    public void checkPermission(String permission) throws AuthorizationException {
        this.assertAuthzCheckPossible();
        this.securityManager.checkPermission(this.getPrincipals(), permission);
    }

    public void checkPermission(Permission permission) throws AuthorizationException {
        this.assertAuthzCheckPossible();
        this.securityManager.checkPermission(this.getPrincipals(), permission);
    }

    public void checkPermissions(String ... permissions) throws AuthorizationException {
        this.assertAuthzCheckPossible();
        this.securityManager.checkPermissions(this.getPrincipals(), permissions);
    }

    public void checkPermissions(Collection<Permission> permissions) throws AuthorizationException {
        this.assertAuthzCheckPossible();
        this.securityManager.checkPermissions(this.getPrincipals(), permissions);
    }

    public boolean hasRole(String roleIdentifier) {
        return this.hasPrincipals() && this.securityManager.hasRole(this.getPrincipals(), roleIdentifier);
    }

    public boolean[] hasRoles(List<String> roleIdentifiers) {
        if (this.hasPrincipals()) {
            return this.securityManager.hasRoles(this.getPrincipals(), roleIdentifiers);
        }
        return new boolean[roleIdentifiers.size()];
    }

    public boolean hasAllRoles(Collection<String> roleIdentifiers) {
        return this.hasPrincipals() && this.securityManager.hasAllRoles(this.getPrincipals(), roleIdentifiers);
    }

    public void checkRole(String role) throws AuthorizationException {
        this.assertAuthzCheckPossible();
        this.securityManager.checkRole(this.getPrincipals(), role);
    }

    public void checkRoles(String ... roleIdentifiers) throws AuthorizationException {
        this.assertAuthzCheckPossible();
        this.securityManager.checkRoles(this.getPrincipals(), roleIdentifiers);
    }

    public void checkRoles(Collection<String> roles) throws AuthorizationException {
        this.assertAuthzCheckPossible();
        this.securityManager.checkRoles(this.getPrincipals(), roles);
    }

    public void login(AuthenticationToken token) throws AuthenticationException {
        Session session;
        PrincipalCollection principals;
        this.clearRunAsIdentities();
        Subject subject = this.securityManager.login((Subject)this, token);
        String host = null;
        if (subject instanceof DelegatingSubject) {
            DelegatingSubject delegating = (DelegatingSubject)subject;
            principals = delegating.principals;
            host = delegating.host;
        } else {
            principals = subject.getPrincipals();
        }
        if (principals == null || principals.isEmpty()) {
            String msg = "Principals returned from securityManager.login( token ) returned a null or empty value.  This value must be non null and populated with one or more elements.";
            throw new IllegalStateException(msg);
        }
        this.principals = principals;
        this.authenticated = true;
        if (token instanceof HostAuthenticationToken) {
            host = ((HostAuthenticationToken)token).getHost();
        }
        if (host != null) {
            this.host = host;
        }
        if ((session = subject.getSession(false)) != null) {
            this.session = this.decorate(session);
            this.runAsPrincipals = this.getRunAsPrincipals(this.session);
        } else {
            this.session = null;
        }
    }

    public boolean isAuthenticated() {
        return this.authenticated;
    }

    public boolean isRemembered() {
        PrincipalCollection principals = this.getPrincipals();
        return principals != null && !principals.isEmpty() && !this.isAuthenticated();
    }

    protected boolean isSessionCreationEnabled() {
        return this.sessionCreationEnabled;
    }

    public Session getSession() {
        return this.getSession(true);
    }

    public Session getSession(boolean create) {
        if (log.isTraceEnabled()) {
            log.trace("attempting to get session; create = " + create + "; session is null = " + (this.session == null) + "; session has id = " + (this.session != null && this.session.getId() != null));
        }
        if (this.session == null && create) {
            if (!this.isSessionCreationEnabled()) {
                String msg = "Session creation has been disabled for the current subject.  This exception indicates that there is either a programming error (using a session when it should never be used) or that Shiro's configuration needs to be adjusted to allow Sessions to be created for the current Subject.  See the " + DisabledSessionException.class.getName() + " JavaDoc " + "for more.";
                throw new DisabledSessionException(msg);
            }
            log.trace("Starting session for host {}", (Object)this.getHost());
            SessionContext sessionContext = this.createSessionContext();
            Session session = this.securityManager.start(sessionContext);
            this.session = this.decorate(session);
        }
        return this.session;
    }

    protected SessionContext createSessionContext() {
        DefaultSessionContext sessionContext = new DefaultSessionContext();
        if (StringUtils.hasText((String)this.host)) {
            sessionContext.setHost(this.host);
        }
        return sessionContext;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void logout() {
        try {
            try {
                this.clearRunAsIdentities();
            }
            catch (SessionException se) {
                log.debug("Encountered session exception trying to clear 'runAs' identities during logout.  This can generally safely be ignored.", (Throwable)se);
            }
            this.securityManager.logout((Subject)this);
        }
        finally {
            this.session = null;
            this.principals = null;
            this.authenticated = false;
            this.runAsPrincipals = null;
        }
    }

    private void sessionStopped() {
        this.session = null;
    }

    public <V> V execute(Callable<V> callable) throws ExecutionException {
        Callable associated = this.associateWith(callable);
        try {
            return associated.call();
        }
        catch (Throwable t) {
            throw new ExecutionException(t);
        }
    }

    public void execute(Runnable runnable) {
        Runnable associated = this.associateWith(runnable);
        associated.run();
    }

    public <V> Callable<V> associateWith(Callable<V> callable) {
        return new SubjectCallable((Subject)this, callable);
    }

    public Runnable associateWith(Runnable runnable) {
        if (runnable instanceof Thread) {
            String msg = "This implementation does not support Thread arguments because of JDK ThreadLocal inheritance mechanisms required by Shiro.  Instead, the method argument should be a non-Thread Runnable and the return value from this method can then be given to an ExecutorService or another Thread.";
            throw new UnsupportedOperationException(msg);
        }
        return new SubjectRunnable((Subject)this, runnable);
    }

    public void runAs(PrincipalCollection principals) {
        if (!this.hasPrincipals()) {
            String msg = "This subject does not yet have an identity.  Assuming the identity of another Subject is only allowed for Subjects with an existing identity.  Try logging this subject in first, or using the " + Subject.Builder.class.getName() + " to build ad hoc Subject instances " + "with identities as necessary.";
            throw new IllegalStateException(msg);
        }
        this.pushIdentity(principals);
    }

    public boolean isRunAs() {
        return !CollectionUtils.isEmpty((Collection)this.runAsPrincipals);
    }

    public PrincipalCollection getPreviousPrincipals() {
        return this.isRunAs() ? this.principals : null;
    }

    public PrincipalCollection releaseRunAs() {
        return this.popIdentity();
    }

    private List<PrincipalCollection> getRunAsPrincipals(Session session) {
        if (session != null) {
            return (List)session.getAttribute((Object)RUN_AS_PRINCIPALS_SESSION_KEY);
        }
        return null;
    }

    private void clearRunAsIdentities() {
        this.runAsPrincipals = null;
        Session session = this.getSession(false);
        if (session != null) {
            session.removeAttribute((Object)RUN_AS_PRINCIPALS_SESSION_KEY);
        }
    }

    private void pushIdentity(PrincipalCollection principals) throws NullPointerException {
        if (CollectionUtils.isEmpty((PrincipalCollection)principals)) {
            String msg = "Specified Subject principals cannot be null or empty for 'run as' functionality.";
            throw new NullPointerException(msg);
        }
        if (this.runAsPrincipals == null) {
            this.runAsPrincipals = new ArrayList();
        }
        this.runAsPrincipals.add(0, principals);
        Session session = this.getSession();
        session.setAttribute((Object)RUN_AS_PRINCIPALS_SESSION_KEY, (Object)this.runAsPrincipals);
    }

    private PrincipalCollection popIdentity() {
        PrincipalCollection popped = null;
        if (!CollectionUtils.isEmpty((Collection)this.runAsPrincipals)) {
            popped = (PrincipalCollection)this.runAsPrincipals.remove(0);
            if (!CollectionUtils.isEmpty((Collection)this.runAsPrincipals)) {
                Session session = this.getSession();
                session.setAttribute((Object)RUN_AS_PRINCIPALS_SESSION_KEY, (Object)this.runAsPrincipals);
            } else {
                Session session = this.getSession(false);
                if (session != null) {
                    session.removeAttribute((Object)RUN_AS_PRINCIPALS_SESSION_KEY);
                }
            }
        }
        return popped;
    }

    static /* synthetic */ void access$100(DelegatingSubject x0) {
        x0.sessionStopped();
    }
}

