/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shiro.subject;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.shiro.subject.PrincipalMap;
import org.apache.shiro.util.CollectionUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SimplePrincipalMap
implements PrincipalMap {
    private Map<String, Map<String, Object>> realmPrincipals;
    private Map<String, Object> combinedPrincipals;

    public SimplePrincipalMap() {
        this(null);
    }

    public SimplePrincipalMap(Map<String, Map<String, Object>> backingMap) {
        if (!CollectionUtils.isEmpty(backingMap)) {
            this.realmPrincipals = backingMap;
            for (Map principals : this.realmPrincipals.values()) {
                if (CollectionUtils.isEmpty((Map)principals)) continue;
                this.ensureCombinedPrincipals().putAll(principals);
            }
        }
    }

    public int size() {
        return CollectionUtils.size((Map)this.combinedPrincipals);
    }

    protected Map<String, Object> ensureCombinedPrincipals() {
        if (this.combinedPrincipals == null) {
            this.combinedPrincipals = new HashMap();
        }
        return this.combinedPrincipals;
    }

    public boolean containsKey(Object o) {
        return this.combinedPrincipals != null && this.combinedPrincipals.containsKey(o);
    }

    public boolean containsValue(Object o) {
        return this.combinedPrincipals != null && this.combinedPrincipals.containsKey(o);
    }

    public Object get(Object o) {
        return this.combinedPrincipals != null && this.combinedPrincipals.containsKey(o);
    }

    public Object put(String s, Object o) {
        return this.ensureCombinedPrincipals().put(s, o);
    }

    public Object remove(Object o) {
        return this.combinedPrincipals != null ? this.combinedPrincipals.remove(o) : null;
    }

    public void putAll(Map<? extends String, ?> map) {
        if (!CollectionUtils.isEmpty(map)) {
            this.ensureCombinedPrincipals().putAll(map);
        }
    }

    public Set<String> keySet() {
        return CollectionUtils.isEmpty((Map)this.combinedPrincipals) ? Collections.emptySet() : Collections.unmodifiableSet(this.combinedPrincipals.keySet());
    }

    public Collection<Object> values() {
        return CollectionUtils.isEmpty((Map)this.combinedPrincipals) ? Collections.emptySet() : Collections.unmodifiableCollection(this.combinedPrincipals.values());
    }

    public Set<Map.Entry<String, Object>> entrySet() {
        return CollectionUtils.isEmpty((Map)this.combinedPrincipals) ? Collections.emptySet() : Collections.unmodifiableSet(this.combinedPrincipals.entrySet());
    }

    public void clear() {
        this.realmPrincipals = null;
        this.combinedPrincipals = null;
    }

    public Object getPrimaryPrincipal() {
        return !CollectionUtils.isEmpty((Map)this.combinedPrincipals) ? this.combinedPrincipals.values().iterator().next() : null;
    }

    public <T> T oneByType(Class<T> type) {
        if (CollectionUtils.isEmpty((Map)this.combinedPrincipals)) {
            return null;
        }
        for (Object value : this.combinedPrincipals.values()) {
            if (!type.isInstance(value)) continue;
            return type.cast(value);
        }
        return null;
    }

    public <T> Collection<T> byType(Class<T> type) {
        if (CollectionUtils.isEmpty((Map)this.combinedPrincipals)) {
            return Collections.emptySet();
        }
        List instances = null;
        for (Object value : this.combinedPrincipals.values()) {
            if (!type.isInstance(value)) continue;
            if (instances == null) {
                instances = new ArrayList();
            }
            instances.add(type.cast(value));
        }
        return instances != null ? instances : Collections.emptyList();
    }

    public List asList() {
        if (CollectionUtils.isEmpty((Map)this.combinedPrincipals)) {
            return Collections.emptyList();
        }
        ArrayList list = new ArrayList(this.combinedPrincipals.size());
        list.addAll(this.combinedPrincipals.values());
        return list;
    }

    public Set asSet() {
        if (CollectionUtils.isEmpty((Map)this.combinedPrincipals)) {
            return Collections.emptySet();
        }
        HashSet set = new HashSet(this.combinedPrincipals.size());
        set.addAll(this.combinedPrincipals.values());
        return set;
    }

    public Collection fromRealm(String realmName) {
        if (CollectionUtils.isEmpty((Map)this.realmPrincipals)) {
            return Collections.emptySet();
        }
        Map principals = (Map)this.realmPrincipals.get(realmName);
        if (CollectionUtils.isEmpty((Map)principals)) {
            return Collections.emptySet();
        }
        return Collections.unmodifiableCollection(principals.values());
    }

    public Set<String> getRealmNames() {
        if (CollectionUtils.isEmpty((Map)this.realmPrincipals)) {
            return Collections.emptySet();
        }
        return Collections.unmodifiableSet(this.realmPrincipals.keySet());
    }

    public boolean isEmpty() {
        return CollectionUtils.isEmpty((Map)this.combinedPrincipals);
    }

    public Iterator iterator() {
        return this.asList().iterator();
    }

    public Map<String, Object> getRealmPrincipals(String name) {
        if (this.realmPrincipals == null) {
            return null;
        }
        Map principals = (Map)this.realmPrincipals.get(name);
        if (principals == null) {
            return null;
        }
        return Collections.unmodifiableMap(principals);
    }

    public Map<String, Object> setRealmPrincipals(String realmName, Map<String, Object> principals) {
        if (realmName == null) {
            throw new NullPointerException("realmName argument cannot be null.");
        }
        if (this.realmPrincipals == null) {
            if (!CollectionUtils.isEmpty(principals)) {
                this.realmPrincipals = new HashMap();
                return this.realmPrincipals.put(realmName, new HashMap<String, Object>(principals));
            }
            return null;
        }
        Map existingPrincipals = (Map)this.realmPrincipals.remove(realmName);
        if (!CollectionUtils.isEmpty(principals)) {
            this.realmPrincipals.put(realmName, new HashMap<String, Object>(principals));
        }
        return existingPrincipals;
    }

    public Object setRealmPrincipal(String realmName, String principalName, Object principal) {
        HashMap<String, Object> principals;
        if (realmName == null) {
            throw new NullPointerException("realmName argument cannot be null.");
        }
        if (principalName == null) {
            throw new NullPointerException("principalName argument cannot be null.");
        }
        if (principal == null) {
            return this.removeRealmPrincipal(realmName, principalName);
        }
        if (this.realmPrincipals == null) {
            this.realmPrincipals = new HashMap();
        }
        if ((principals = (HashMap<String, Object>)this.realmPrincipals.get(realmName)) == null) {
            principals = new HashMap<String, Object>();
            this.realmPrincipals.put(realmName, principals);
        }
        return principals.put(principalName, principal);
    }

    public Object getRealmPrincipal(String realmName, String principalName) {
        if (realmName == null) {
            throw new NullPointerException("realmName argument cannot be null.");
        }
        if (principalName == null) {
            throw new NullPointerException("principalName argument cannot be null.");
        }
        if (this.realmPrincipals == null) {
            return null;
        }
        Map principals = (Map)this.realmPrincipals.get(realmName);
        if (principals != null) {
            return principals.get(principalName);
        }
        return null;
    }

    public Object removeRealmPrincipal(String realmName, String principalName) {
        if (realmName == null) {
            throw new NullPointerException("realmName argument cannot be null.");
        }
        if (principalName == null) {
            throw new NullPointerException("principalName argument cannot be null.");
        }
        if (this.realmPrincipals == null) {
            return null;
        }
        Map principals = (Map)this.realmPrincipals.get(realmName);
        if (principals != null) {
            return principals.remove(principalName);
        }
        return null;
    }
}

