/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shiro.session.mgt;

import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.Set;
import org.apache.shiro.cache.CacheManager;
import org.apache.shiro.cache.CacheManagerAware;
import org.apache.shiro.session.Session;
import org.apache.shiro.session.UnknownSessionException;
import org.apache.shiro.session.mgt.AbstractValidatingSessionManager;
import org.apache.shiro.session.mgt.SessionContext;
import org.apache.shiro.session.mgt.SessionFactory;
import org.apache.shiro.session.mgt.SessionKey;
import org.apache.shiro.session.mgt.SimpleSession;
import org.apache.shiro.session.mgt.SimpleSessionFactory;
import org.apache.shiro.session.mgt.eis.MemorySessionDAO;
import org.apache.shiro.session.mgt.eis.SessionDAO;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultSessionManager
extends AbstractValidatingSessionManager
implements CacheManagerAware {
    private static final Logger log = LoggerFactory.getLogger(DefaultSessionManager.class);
    private SessionFactory sessionFactory = new SimpleSessionFactory();
    protected SessionDAO sessionDAO = new MemorySessionDAO();
    private CacheManager cacheManager;
    private boolean deleteInvalidSessions = true;

    public void setSessionDAO(SessionDAO sessionDAO) {
        this.sessionDAO = sessionDAO;
        this.applyCacheManagerToSessionDAO();
    }

    public SessionDAO getSessionDAO() {
        return this.sessionDAO;
    }

    public SessionFactory getSessionFactory() {
        return this.sessionFactory;
    }

    public void setSessionFactory(SessionFactory sessionFactory) {
        this.sessionFactory = sessionFactory;
    }

    public boolean isDeleteInvalidSessions() {
        return this.deleteInvalidSessions;
    }

    public void setDeleteInvalidSessions(boolean deleteInvalidSessions) {
        this.deleteInvalidSessions = deleteInvalidSessions;
    }

    public void setCacheManager(CacheManager cacheManager) {
        this.cacheManager = cacheManager;
        this.applyCacheManagerToSessionDAO();
    }

    private void applyCacheManagerToSessionDAO() {
        if (this.cacheManager != null && this.sessionDAO != null && this.sessionDAO instanceof CacheManagerAware) {
            ((CacheManagerAware)this.sessionDAO).setCacheManager(this.cacheManager);
        }
    }

    protected Session doCreateSession(SessionContext context) {
        Session s = this.newSessionInstance(context);
        if (log.isTraceEnabled()) {
            log.trace("Creating session for host {}", (Object)s.getHost());
        }
        this.create(s);
        return s;
    }

    protected Session newSessionInstance(SessionContext context) {
        return this.getSessionFactory().createSession(context);
    }

    protected void create(Session session) {
        if (log.isDebugEnabled()) {
            log.debug("Creating new EIS record for new session instance [" + session + "]");
        }
        this.sessionDAO.create(session);
    }

    protected void onStop(Session session) {
        if (session instanceof SimpleSession) {
            SimpleSession ss = (SimpleSession)session;
            Date stopTs = ss.getStopTimestamp();
            ss.setLastAccessTime(stopTs);
        }
        this.onChange(session);
    }

    protected void afterStopped(Session session) {
        if (this.isDeleteInvalidSessions()) {
            this.delete(session);
        }
    }

    protected void onExpiration(Session session) {
        if (session instanceof SimpleSession) {
            ((SimpleSession)session).setExpired(true);
        }
        this.onChange(session);
    }

    protected void afterExpired(Session session) {
        if (this.isDeleteInvalidSessions()) {
            this.delete(session);
        }
    }

    protected void onChange(Session session) {
        this.sessionDAO.update(session);
    }

    protected Session retrieveSession(SessionKey sessionKey) throws UnknownSessionException {
        Serializable sessionId = this.getSessionId(sessionKey);
        if (sessionId == null) {
            log.debug("Unable to resolve session ID from SessionKey [{}].  Returning null to indicate a session could not be found.", (Object)sessionKey);
            return null;
        }
        Session s = this.retrieveSessionFromDataSource(sessionId);
        if (s == null) {
            String msg = "Could not find session with ID [" + sessionId + "]";
            throw new UnknownSessionException(msg);
        }
        return s;
    }

    protected Serializable getSessionId(SessionKey sessionKey) {
        return sessionKey.getSessionId();
    }

    protected Session retrieveSessionFromDataSource(Serializable sessionId) throws UnknownSessionException {
        return this.sessionDAO.readSession(sessionId);
    }

    protected void delete(Session session) {
        this.sessionDAO.delete(session);
    }

    protected Collection<Session> getActiveSessions() {
        Set<Session> active = this.sessionDAO.getActiveSessions();
        return active != null ? active : Collections.emptySet();
    }
}

