/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shiro.realm.ldap;

import javax.naming.AuthenticationException;
import javax.naming.NamingException;
import org.apache.shiro.authc.AuthenticationInfo;
import org.apache.shiro.authc.AuthenticationToken;
import org.apache.shiro.authz.AuthorizationException;
import org.apache.shiro.authz.AuthorizationInfo;
import org.apache.shiro.realm.AuthorizingRealm;
import org.apache.shiro.realm.ldap.DefaultLdapContextFactory;
import org.apache.shiro.realm.ldap.LdapContextFactory;
import org.apache.shiro.subject.PrincipalCollection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractLdapRealm
extends AuthorizingRealm {
    private static final Logger log = LoggerFactory.getLogger(AbstractLdapRealm.class);
    protected String principalSuffix = null;
    protected String searchBase = null;
    protected String url = null;
    protected String systemUsername = null;
    protected String systemPassword = null;
    private LdapContextFactory ldapContextFactory = null;

    public void setPrincipalSuffix(String principalSuffix) {
        this.principalSuffix = principalSuffix;
    }

    public void setSearchBase(String searchBase) {
        this.searchBase = searchBase;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public void setSystemUsername(String systemUsername) {
        this.systemUsername = systemUsername;
    }

    public void setSystemPassword(String systemPassword) {
        this.systemPassword = systemPassword;
    }

    public void setLdapContextFactory(LdapContextFactory ldapContextFactory) {
        this.ldapContextFactory = ldapContextFactory;
    }

    protected void onInit() {
        super.onInit();
        this.ensureContextFactory();
    }

    private LdapContextFactory ensureContextFactory() {
        if (this.ldapContextFactory == null) {
            if (log.isDebugEnabled()) {
                log.debug("No LdapContextFactory specified - creating a default instance.");
            }
            DefaultLdapContextFactory defaultFactory = new DefaultLdapContextFactory();
            defaultFactory.setPrincipalSuffix(this.principalSuffix);
            defaultFactory.setSearchBase(this.searchBase);
            defaultFactory.setUrl(this.url);
            defaultFactory.setSystemUsername(this.systemUsername);
            defaultFactory.setSystemPassword(this.systemPassword);
            this.ldapContextFactory = defaultFactory;
        }
        return this.ldapContextFactory;
    }

    protected AuthenticationInfo doGetAuthenticationInfo(AuthenticationToken token) throws org.apache.shiro.authc.AuthenticationException {
        AuthenticationInfo info;
        try {
            info = this.queryForAuthenticationInfo(token, this.ensureContextFactory());
        }
        catch (AuthenticationException e) {
            throw new org.apache.shiro.authc.AuthenticationException("LDAP authentication failed.", (Throwable)e);
        }
        catch (NamingException e) {
            String msg = "LDAP naming error while attempting to authenticate user.";
            throw new org.apache.shiro.authc.AuthenticationException(msg, (Throwable)e);
        }
        return info;
    }

    protected AuthorizationInfo doGetAuthorizationInfo(PrincipalCollection principals) {
        AuthorizationInfo info;
        try {
            info = this.queryForAuthorizationInfo(principals, this.ensureContextFactory());
        }
        catch (NamingException e) {
            String msg = "LDAP naming error while attempting to retrieve authorization for user [" + principals + "].";
            throw new AuthorizationException(msg, (Throwable)e);
        }
        return info;
    }

    protected abstract AuthenticationInfo queryForAuthenticationInfo(AuthenticationToken var1, LdapContextFactory var2) throws NamingException;

    protected abstract AuthorizationInfo queryForAuthorizationInfo(PrincipalCollection var1, LdapContextFactory var2) throws NamingException;
}

